package com.applovin.mediation;

public class MaxErrorCodes
{
    /**
     * Indicates that no ads are currently eligible for your device.
     */
    public static final int NO_FILL = 204;

    /**
     * Indicates that the system is in unexpected state.
     */
    public static final int UNSPECIFIED_ERROR = -1;

    /**
     * Internal state of the SDK is invalid.
     */
    public static final int INVALID_INTERNAL_STATE = -5201;

    /**
     * Indicates that the mediation adapter has failed to load.
     */
    public static final int MEDIATION_ADAPTER_LOAD_FAILED = -5001;

    /**
     * Indicates that an attempt to show a fullscreen ad (interstitial or rewarded) was made while another fullscreen ad is still showing.
     */
    public static final int FULLSCREEN_AD_ALREADY_SHOWING = -23;

    /**
     * Called when the AppLovin MAX SDK attempts to reload an ad internally after an internally set expiration date, but the provided {@link android.app.Activity} reference has been garbage collected.
     */
    public static final int NO_ACTIVITY = -5601;

    /**
     * Display failure error due to "Don't Keep Activities" being enabled in the developer settings.
     */
    public static final int DONT_KEEP_ACTIVITIES_ENABLED = -5602;
}
