/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.mediation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.applovin.impl.mediation.MaxAdapterParametersImpl;
import com.applovin.impl.mediation.a.b;
import com.applovin.impl.mediation.a.c;
import com.applovin.impl.mediation.a.f;
import com.applovin.impl.mediation.b.d;
import com.applovin.impl.mediation.b.f;
import com.applovin.impl.mediation.b.g;
import com.applovin.impl.mediation.e;
import com.applovin.impl.mediation.i;
import com.applovin.impl.sdk.AppLovinBroadcastManager;
import com.applovin.impl.sdk.e.o;
import com.applovin.impl.sdk.k;
import com.applovin.impl.sdk.network.h;
import com.applovin.impl.sdk.r;
import com.applovin.impl.sdk.utils.o;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MediationServiceImpl
implements AppLovinBroadcastManager.Receiver {
    private final k a;
    private final r b;

    public MediationServiceImpl(k k2) {
        this.a = k2;
        this.b = k2.z();
        k2.aj().registerReceiver(this, new IntentFilter("com.applovin.render_process_gone"));
    }

    public void loadAd(String string2, MaxAdFormat maxAdFormat, h h2, Activity activity, MaxAdListener maxAdListener) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No ad unit ID specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        if (maxAdListener == null) {
            throw new IllegalArgumentException("No listener specified");
        }
        if (TextUtils.isEmpty((CharSequence)this.a.s())) {
            r.i("AppLovinSdk", "Mediation provider is null. Please set AppLovin SDK mediation provider via AppLovinSdk.getInstance(context).setMediationProvider()");
        }
        if (!this.a.d()) {
            r.h("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.a.a();
        if (string2.length() != 16 && !string2.startsWith("test_mode") && !this.a.x().startsWith("05TMD")) {
            r.i("MediationService", "Please double-check the ad unit " + string2 + " for " + maxAdFormat.getLabel() + " : " + Log.getStackTraceString((Throwable)new Throwable("")));
        }
        this.a.G().a(string2, maxAdFormat, h2, activity, maxAdListener);
    }

    public void showFullscreenAd(MaxAd maxAd, String string2, final Activity activity, final MaxAdListener maxAdListener) {
        if (maxAd == null) {
            throw new IllegalArgumentException("No ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        if (!(maxAd instanceof c)) {
            r.i("MediationService", "Unable to show ad for '" + maxAd.getAdUnitId() + "': only REWARDED or INTERSTITIAL ads are eligible for showFullscreenAd(). " + maxAd.getFormat() + " ad was provided.");
            throw new IllegalArgumentException("Provided ad is not a MediatedFullscreenAd");
        }
        this.a.ad().a(true);
        final c c2 = (c)maxAd;
        final i i2 = c2.f();
        if (i2 == null) {
            this.a.ad().a(false);
            this.b.d("MediationService", "Failed to show " + maxAd + ": adapter not found");
            r.i("MediationService", "There may be an integration problem with the adapter for ad unit id '" + c2.getAdUnitId() + "'. Please check if you have a supported version of that SDK integrated into your project.");
            throw new IllegalStateException("Could not find adapter for provided ad");
        }
        c2.c(string2);
        long l2 = c2.u();
        this.b.c("MediationService", "Showing ad " + maxAd.getAdUnitId() + " with delay of " + l2 + "ms...");
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                if (c2.getFormat() == MaxAdFormat.REWARDED || c2.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) {
                    g g2 = new g(c2, MediationServiceImpl.this.a);
                    MediationServiceImpl.this.a.Q().a(g2, o.a.r);
                }
                i2.a(c2, activity);
                MediationServiceImpl.this.a.ad().a(false);
                MediationServiceImpl.this.a(c2, maxAdListener);
                MediationServiceImpl.this.b.b("MediationService", "Scheduling impression for ad manually...");
                MediationServiceImpl.this.processRawAdImpressionPostback(c2);
            }
        }, l2);
    }

    public void destroyAd(MaxAd maxAd) {
        if (!(maxAd instanceof com.applovin.impl.mediation.a.a)) {
            return;
        }
        this.b.c("MediationService", "Destroying " + maxAd);
        com.applovin.impl.mediation.a.a a2 = (com.applovin.impl.mediation.a.a)maxAd;
        i i2 = a2.f();
        if (i2 != null) {
            i2.h();
            a2.o();
        }
    }

    public void loadThirdPartyMediatedAd(String string2, com.applovin.impl.mediation.a.a a2, Activity activity, MaxAdListener maxAdListener) {
        if (a2 == null) {
            throw new IllegalArgumentException("No mediated ad specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("A valid Activity is required");
        }
        this.b.b("MediationService", "Loading " + a2 + "...");
        this.a.ag().a(a2, "WILL_LOAD");
        this.a(a2);
        i i2 = this.a.A().a(a2);
        if (i2 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(a2, activity.getApplicationContext());
            i2.a(maxAdapterParametersImpl, activity);
            com.applovin.impl.mediation.a.a a3 = a2.a(i2);
            i2.a(string2, a3);
            a3.k();
            i2.a(string2, maxAdapterParametersImpl, a3, activity, new a(a3, maxAdListener));
        } else {
            this.b.d("MediationService", "Failed to load " + a2 + ": adapter not loaded");
            this.a(a2, new e(-5001), maxAdListener);
        }
    }

    public void collectSignal(MaxAdFormat maxAdFormat, final com.applovin.impl.mediation.a.g g2, Activity activity, final f.a a2) {
        if (g2 == null) {
            throw new IllegalArgumentException("No spec specified");
        }
        if (activity == null) {
            throw new IllegalArgumentException("No activity specified");
        }
        if (a2 == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        final i i2 = this.a.A().a(g2);
        if (i2 != null) {
            MaxAdapterParametersImpl maxAdapterParametersImpl = MaxAdapterParametersImpl.a(g2, maxAdFormat, activity.getApplicationContext());
            i2.a(maxAdapterParametersImpl, activity);
            MaxSignalCollectionListener maxSignalCollectionListener = new MaxSignalCollectionListener(){

                @Override
                public void onSignalCollected(String string2) {
                    a2.a(com.applovin.impl.mediation.a.f.a(g2, i2, string2));
                }

                @Override
                public void onSignalCollectionFailed(String string2) {
                    MediationServiceImpl.this.a(string2, g2, i2);
                    a2.a(com.applovin.impl.mediation.a.f.b(g2, i2, string2));
                }
            };
            if (g2.a()) {
                if (this.a.B().a(g2)) {
                    this.b.b("MediationService", "Collecting signal for now-initialized adapter: " + i2.b());
                    i2.a(maxAdapterParametersImpl, g2, activity, maxSignalCollectionListener);
                } else {
                    this.b.e("MediationService", "Skip collecting signal for not-initialized adapter: " + i2.b());
                    a2.a(com.applovin.impl.mediation.a.f.a(g2, "Adapter not initialized yet"));
                }
            } else {
                this.b.b("MediationService", "Collecting signal for adapter: " + i2.b());
                i2.a(maxAdapterParametersImpl, g2, activity, maxSignalCollectionListener);
            }
        } else {
            a2.a(com.applovin.impl.mediation.a.f.a(g2, "Could not load adapter"));
        }
    }

    private void a(final c c2, final MaxAdListener maxAdListener) {
        final long l2 = this.a.a(com.applovin.impl.sdk.c.a.E);
        if (l2 <= 0L) {
            return;
        }
        AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

            @Override
            public void run() {
                if (c2.n().get()) {
                    return;
                }
                r.i("MediationService", "Ad (" + c2.K() + ") has not been displayed after " + l2 + "ms. Failing ad display...");
                MediationServiceImpl.this.b(c2, new e(-5201, "Adapter did not call adDisplayed."), maxAdListener);
                MediationServiceImpl.this.a.ad().b(c2);
                MediationServiceImpl.this.a.al().a();
            }
        }, l2);
    }

    private void a(com.applovin.impl.mediation.a.a a2, e e2, MaxAdListener maxAdListener) {
        this.a(e2, a2);
        this.destroyAd(a2);
        com.applovin.impl.sdk.utils.k.a(maxAdListener, a2.getAdUnitId(), e2.getErrorCode());
    }

    private void b(com.applovin.impl.mediation.a.a a2, e e2, MaxAdListener maxAdListener) {
        this.a.ag().a(a2, "DID_FAIL_DISPLAY");
        this.processAdDisplayErrorPostback(e2, a2);
        if (a2.n().compareAndSet(false, true)) {
            com.applovin.impl.sdk.utils.k.a(maxAdListener, (MaxAd)a2, e2.getErrorCode());
        }
    }

    private void a(com.applovin.impl.mediation.a.a a2) {
        this.a("mpreload", (com.applovin.impl.mediation.a.e)a2);
    }

    public void processAdLossPostback(com.applovin.impl.mediation.a.a a2, @Nullable Float f2) {
        String string2 = f2 != null ? f2.toString() : "";
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{MBR}", string2);
        this.a("mloss", hashMap, a2);
    }

    private void b(com.applovin.impl.mediation.a.a a2) {
        this.a.ag().a(a2, "DID_LOAD");
        if (a2.c().endsWith("load")) {
            this.a.ag().a(a2);
        }
        long l2 = a2.j();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("load", hashMap, a2);
    }

    private void a(e e2, com.applovin.impl.mediation.a.a a2) {
        long l2 = a2.j();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{LOAD_TIME_MS}", String.valueOf(l2));
        this.a("mlerr", hashMap, e2, a2);
    }

    public void processAdapterInitializationPostback(com.applovin.impl.mediation.a.e e2, long l2, MaxAdapter.InitializationStatus initializationStatus, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("{INIT_STATUS}", String.valueOf(initializationStatus.getCode()));
        hashMap.put("{INIT_TIME_MS}", String.valueOf(l2));
        this.a("minit", hashMap, new e(string2), e2);
    }

    public void processRawAdImpressionPostback(com.applovin.impl.mediation.a.a a2) {
        this.a.ag().a(a2, "WILL_DISPLAY");
        if (a2.c().endsWith("mimp")) {
            this.a.ag().a(a2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        if (a2 instanceof c) {
            c c2 = (c)a2;
            hashMap.put("{TIME_TO_SHOW_MS}", String.valueOf(c2.t()));
        }
        this.a("mimp", hashMap, a2);
    }

    public void processViewabilityAdImpressionPostback(b b2, long l2) {
        if (b2.c().endsWith("vimp")) {
            this.a.ag().a(b2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("{VIEWABILITY_FLAGS}", String.valueOf(l2));
        hashMap.put("{USED_VIEWABILITY_TIMER}", String.valueOf(b2.x()));
        this.a("mvimp", hashMap, b2);
    }

    public void processCallbackAdImpressionPostback(com.applovin.impl.mediation.a.a a2) {
        if (a2.c().endsWith("cimp")) {
            this.a.ag().a(a2);
        }
        this.a("mcimp", (com.applovin.impl.mediation.a.e)a2);
    }

    private void c(com.applovin.impl.mediation.a.a a2) {
        this.a.ag().a(a2, "DID_CLICKED");
        this.a.ag().a(a2, "DID_CLICK");
        if (a2.c().endsWith("click")) {
            this.a.ag().a(a2);
        }
        this.a("mclick", (com.applovin.impl.mediation.a.e)a2);
    }

    public void processAdDisplayErrorPostback(e e2, com.applovin.impl.mediation.a.a a2) {
        this.a("mierr", Collections.EMPTY_MAP, e2, a2);
    }

    private void a(String string2, com.applovin.impl.mediation.a.g g2, i i2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        com.applovin.impl.sdk.utils.r.a("{ADAPTER_VERSION}", i2.g(), hashMap);
        com.applovin.impl.sdk.utils.r.a("{SDK_VERSION}", i2.f(), hashMap);
        this.a("serr", hashMap, new e(string2), g2);
    }

    private void a(String string2, com.applovin.impl.mediation.a.e e2) {
        this.a(string2, Collections.EMPTY_MAP, null, e2);
    }

    private void a(String string2, Map<String, String> map, com.applovin.impl.mediation.a.e e2) {
        this.a(string2, map, null, e2);
    }

    private void a(String string2, Map<String, String> map, e e2, com.applovin.impl.mediation.a.e e3) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put("{PLACEMENT}", o.c(e3.getPlacement()));
        if (e3 instanceof com.applovin.impl.mediation.a.a) {
            object = (com.applovin.impl.mediation.a.a)e3;
            hashMap.put("{CREATIVE_ID}", o.c(((com.applovin.impl.mediation.a.a)object).getCreativeId()));
        }
        object = new d(string2, hashMap, e2, e3, this.a);
        this.a.Q().a((com.applovin.impl.sdk.e.a)object, o.a.m);
    }

    @Override
    public void onReceive(Context context, Intent intent, @Nullable Map<String, Object> map) {
        Object object;
        if ("com.applovin.render_process_gone".equals(intent.getAction()) && (object = this.a.ad().c()) instanceof com.applovin.impl.mediation.a.a) {
            com.applovin.impl.mediation.a.a a2 = (com.applovin.impl.mediation.a.a)object;
            this.processAdDisplayErrorPostback(MaxAdapterError.WEBVIEW_ERROR, a2);
        }
    }

    private class a
    implements com.applovin.impl.mediation.d {
        private final com.applovin.impl.mediation.a.a b;
        private MaxAdListener c;

        private a(com.applovin.impl.mediation.a.a a2, MaxAdListener maxAdListener) {
            this.b = a2;
            this.c = maxAdListener;
        }

        @Override
        public void a(MaxAdListener maxAdListener) {
            this.c = maxAdListener;
        }

        @Override
        public void onAdLoaded(MaxAd maxAd) {
            this.a(maxAd, (Bundle)null);
        }

        @Override
        public void a(MaxAd maxAd, @Nullable Bundle bundle) {
            this.b.m();
            this.b.a(bundle);
            MediationServiceImpl.this.b(this.b);
            com.applovin.impl.sdk.utils.k.a(this.c, maxAd);
        }

        @Override
        public void onAdLoadFailed(String string2, int n2) {
            this.b.m();
            MediationServiceImpl.this.a(this.b, new e(n2), this.c);
        }

        @Override
        public void a(String string2, e e2) {
            this.b.m();
            MediationServiceImpl.this.a(this.b, e2, this.c);
        }

        @Override
        public void onAdDisplayed(MaxAd maxAd) {
            this.b(maxAd, null);
        }

        @Override
        public void b(MaxAd maxAd, @Nullable Bundle bundle) {
            MediationServiceImpl.this.b.b("MediationService", "Scheduling impression for ad via callback...");
            MediationServiceImpl.this.processCallbackAdImpressionPostback(this.b);
            this.b.a(bundle);
            MediationServiceImpl.this.a.ag().a(this.b, "DID_DISPLAY");
            if (maxAd.getFormat().isFullscreenAd()) {
                MediationServiceImpl.this.a.ad().a(maxAd);
                MediationServiceImpl.this.a.al().a(maxAd);
            }
            com.applovin.impl.sdk.utils.k.b(this.c, maxAd);
        }

        @Override
        public void onAdHidden(final MaxAd maxAd) {
            MediationServiceImpl.this.a.ag().a((com.applovin.impl.mediation.a.a)maxAd, "DID_HIDE");
            long l2 = 0L;
            if (maxAd instanceof c) {
                l2 = ((c)maxAd).v();
            }
            AppLovinSdkUtils.runOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    if (maxAd.getFormat().isFullscreenAd()) {
                        MediationServiceImpl.this.a.ad().b(maxAd);
                        MediationServiceImpl.this.a.al().a();
                    }
                    com.applovin.impl.sdk.utils.k.c(a.this.c, maxAd);
                }
            }, l2);
        }

        @Override
        public void onAdClicked(MaxAd maxAd) {
            MediationServiceImpl.this.c(this.b);
            com.applovin.impl.sdk.utils.k.d(this.c, maxAd);
        }

        @Override
        public void onAdDisplayFailed(MaxAd maxAd, int n2) {
            MediationServiceImpl.this.b(this.b, new e(n2), this.c);
        }

        @Override
        public void a(MaxAd maxAd, e e2) {
            MediationServiceImpl.this.b(this.b, e2, this.c);
            if ((maxAd.getFormat() == MaxAdFormat.REWARDED || maxAd.getFormat() == MaxAdFormat.REWARDED_INTERSTITIAL) && maxAd instanceof c) {
                ((c)maxAd).z();
            }
        }

        @Override
        public void onRewardedVideoStarted(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.k.e(this.c, maxAd);
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.k.f(this.c, maxAd);
        }

        @Override
        public void onUserRewarded(MaxAd maxAd, MaxReward maxReward) {
            com.applovin.impl.sdk.utils.k.a(this.c, maxAd, maxReward);
            f f2 = new f((c)maxAd, MediationServiceImpl.this.a);
            MediationServiceImpl.this.a.Q().a(f2, o.a.r);
        }

        @Override
        public void onAdExpanded(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.k.g(this.c, maxAd);
        }

        @Override
        public void onAdCollapsed(MaxAd maxAd) {
            com.applovin.impl.sdk.utils.k.h(this.c, maxAd);
        }
    }
}

