/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.Borders;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import com.applitools.eyes.selenium.fluent.ImplicitInitiation;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.serializers.BySerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;

public class SimpleRegionBySelector
implements GetSimpleRegion,
IGetSeleniumRegion,
ImplicitInitiation {
    @JsonIgnore
    private EyesWebDriver driver;
    @JsonSerialize(using=BySerializer.class)
    private final By selector;
    @JsonIgnore
    private final Borders padding;
    private String regionId;

    public SimpleRegionBySelector(By selector) {
        this(selector, new Borders(0, 0, 0, 0));
    }

    public SimpleRegionBySelector(By selector, Borders padding) {
        this.selector = selector;
        this.padding = padding;
    }

    @Override
    public void init(Logger logger, EyesWebDriver driver) {
        this.driver = driver;
        new SimpleRegionBySelector(By.cssSelector((String)"asd"), null);
    }

    public List<Region> getRegions(EyesScreenshot screenshot) {
        List<WebElement> elements = this.driver.findElements(this.selector);
        ArrayList<Region> values = new ArrayList<Region>(elements.size());
        for (WebElement element : elements) {
            Rectangle rectangle = EyesDriverUtils.getVisibleElementRect(element, this.driver);
            Dimension size = element.getSize();
            Location adjustedLocation = new Location(rectangle.x, rectangle.y);
            if (screenshot != null) {
                adjustedLocation = screenshot.convertLocation(adjustedLocation, CoordinatesType.CONTEXT_RELATIVE, CoordinatesType.SCREENSHOT_AS_IS);
            }
            Region region = new Region(adjustedLocation, new RectangleSize(size.width, size.height), CoordinatesType.SCREENSHOT_AS_IS);
            region = region.addPadding(this.padding);
            values.add(region);
        }
        return values;
    }

    @Override
    public List<WebElement> getElements() {
        return this.driver.findElements(this.selector);
    }

    public By getSelector() {
        return this.selector;
    }

    public SimpleRegionBySelector regionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    public String getRegionId() {
        return this.regionId;
    }
}

