/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.selenium.fluent;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.fluent.IGetSeleniumRegion;
import com.applitools.eyes.selenium.fluent.ImplicitInitiation;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.eyes.serializers.BySerializer;
import com.applitools.eyes.visualgrid.model.IGetFloatingRegionOffsets;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;

public class FloatingRegionBySelector
implements GetFloatingRegion,
IGetSeleniumRegion,
IGetFloatingRegionOffsets,
ImplicitInitiation {
    @JsonIgnore
    private EyesWebDriver driver;
    @JsonSerialize(using=BySerializer.class)
    private final By selector;
    private final int maxUpOffset;
    private final int maxDownOffset;
    private final int maxLeftOffset;
    private final int maxRightOffset;
    private String regionId;

    public FloatingRegionBySelector(By regionSelector, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.selector = regionSelector;
        this.maxUpOffset = maxUpOffset;
        this.maxDownOffset = maxDownOffset;
        this.maxLeftOffset = maxLeftOffset;
        this.maxRightOffset = maxRightOffset;
    }

    @Override
    public void init(Logger logger, EyesWebDriver driver) {
        this.driver = driver;
    }

    public List<FloatingMatchSettings> getRegions(EyesScreenshot screenshot) {
        List<WebElement> elements = this.driver.findElements(this.selector);
        ArrayList<FloatingMatchSettings> values = new ArrayList<FloatingMatchSettings>();
        for (WebElement element : elements) {
            Rectangle rectangle = EyesDriverUtils.getVisibleElementRect(element, this.driver);
            Location location = new Location(rectangle.x, rectangle.y);
            Dimension size = element.getSize();
            Location adjustedLocation = screenshot != null ? screenshot.getLocationInScreenshot(location, CoordinatesType.CONTEXT_RELATIVE) : location;
            values.add(new FloatingMatchSettings(adjustedLocation.getX(), adjustedLocation.getY(), size.width, size.height, this.maxUpOffset, this.maxDownOffset, this.maxLeftOffset, this.maxRightOffset));
        }
        return values;
    }

    @Override
    public List<WebElement> getElements() {
        return this.driver.findElements(this.selector);
    }

    public int getMaxLeftOffset() {
        return this.maxLeftOffset;
    }

    public int getMaxUpOffset() {
        return this.maxUpOffset;
    }

    public int getMaxRightOffset() {
        return this.maxRightOffset;
    }

    public int getMaxDownOffset() {
        return this.maxDownOffset;
    }

    public By getSelector() {
        return this.selector;
    }

    public FloatingRegionBySelector regionId(String regionId) {
        this.regionId = regionId;
        return this;
    }

    public String getRegionId() {
        return this.regionId;
    }
}

