/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.CutProvider;
import com.applitools.eyes.Region;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;

public class UnscaledFixedCutProvider
implements CutProvider {
    private final int header;
    private final int footer;
    private final int left;
    private final int right;

    public UnscaledFixedCutProvider(int header, int footer, int left, int right) {
        this.header = header;
        this.footer = footer;
        this.left = left;
        this.right = right;
    }

    @Override
    public BufferedImage cut(BufferedImage image) {
        if (this.header > 0) {
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(0, this.header, image.getWidth(), image.getHeight() - this.header));
        }
        if (this.footer > 0) {
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(0, 0, image.getWidth(), image.getHeight() - this.footer));
        }
        if (this.left > 0) {
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(this.left, 0, image.getWidth() - this.left, image.getHeight()));
        }
        if (this.right > 0) {
            image = ImageUtils.cropImage((BufferedImage)image, (Region)new Region(0, 0, image.getWidth() - this.right, image.getHeight()));
        }
        return image;
    }

    @Override
    public CutProvider scale(double scaleRatio) {
        return new UnscaledFixedCutProvider(this.header, this.footer, this.left, this.right);
    }
}

