/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.services;

import com.applitools.connectivity.ServerConnector;
import com.applitools.connectivity.UfgConnector;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.services.EyesService;
import com.applitools.eyes.visualgrid.model.DomAnalyzer;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.HashObject;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.NullDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridDom;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.services.ServiceTaskListener;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class ResourceCollectionService
extends EyesService<FrameData, Map<String, RGridResource>> {
    final Map<String, RGridResource> resourcesCacheMap;
    private IDebugResourceWriter debugResourceWriter;
    final Map<String, SyncTaskListener<Void>> uploadedResourcesCache = Collections.synchronizedMap(new HashMap());
    final Map<String, DomAnalyzer> tasksInDomAnalyzingProcess = Collections.synchronizedMap(new HashMap());
    protected final List<Pair<String, Pair<RGridDom, Map<String, RGridResource>>>> waitingForUploadQueue = Collections.synchronizedList(new ArrayList());

    public ResourceCollectionService(Logger logger, ServerConnector serverConnector, IDebugResourceWriter debugResourceWriter, Map<String, RGridResource> resourcesCacheMap) {
        super(logger, serverConnector);
        this.debugResourceWriter = debugResourceWriter != null ? debugResourceWriter : new NullDebugResourceWriter();
        this.resourcesCacheMap = resourcesCacheMap;
    }

    public void setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.debugResourceWriter = debugResourceWriter != null ? debugResourceWriter : new NullDebugResourceWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<DomAnalyzer> domAnalyzers;
        Object frameData;
        while (!this.inputQueue.isEmpty()) {
            Pair nextInput = (Pair)this.inputQueue.remove(0);
            frameData = (FrameData)nextInput.getRight();
            try {
                DomAnalyzer domAnalyzer = new DomAnalyzer(this.logger, (UfgConnector)this.serverConnector, this.debugResourceWriter, (FrameData)frameData, this.resourcesCacheMap, (TaskListener)new TaskListener<Map<String, RGridResource>>((FrameData)frameData, nextInput){
                    final /* synthetic */ FrameData val$frameData;
                    final /* synthetic */ Pair val$nextInput;
                    {
                        this.val$frameData = frameData;
                        this.val$nextInput = pair;
                    }

                    public void onComplete(Map<String, RGridResource> resourceMap) {
                        RGridDom dom = new RGridDom(this.val$frameData.getCdt(), resourceMap, this.val$frameData.getUrl());
                        dom.setTestIds(this.val$frameData.getTestIds());
                        ResourceCollectionService.this.waitingForUploadQueue.add((Pair<String, Pair<RGridDom, Map<String, RGridResource>>>)Pair.of((Object)this.val$nextInput.getLeft(), (Object)Pair.of((Object)dom, resourceMap)));
                        ResourceCollectionService.this.tasksInDomAnalyzingProcess.remove(this.val$nextInput.getLeft());
                    }

                    public void onFail() {
                        ResourceCollectionService.this.errorQueue.add(Pair.of((Object)this.val$nextInput.getLeft(), (Object)new EyesException("Dom analyzer failed")));
                        ResourceCollectionService.this.tasksInDomAnalyzingProcess.remove(this.val$nextInput.getLeft());
                    }
                });
                this.tasksInDomAnalyzingProcess.put((String)nextInput.getLeft(), domAnalyzer);
            }
            catch (Throwable t) {
                this.errorQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)t));
            }
        }
        frameData = this.tasksInDomAnalyzingProcess;
        synchronized (frameData) {
            domAnalyzers = new ArrayList<DomAnalyzer>(this.tasksInDomAnalyzingProcess.values());
        }
        for (DomAnalyzer domAnalyzer : domAnalyzers) {
            domAnalyzer.run();
        }
        while (!this.waitingForUploadQueue.isEmpty()) {
            final Pair<String, Pair<RGridDom, Map<String, RGridResource>>> nextInput = this.waitingForUploadQueue.remove(0);
            final Pair pair = (Pair)nextInput.getRight();
            ServiceTaskListener<List<RGridResource>> checkResourceListener = new ServiceTaskListener<List<RGridResource>>(){

                @Override
                public void onComplete(List<RGridResource> resources) {
                    try {
                        ResourceCollectionService.this.uploadResources(((RGridDom)pair.getLeft()).getTestIds(), resources);
                    }
                    catch (Throwable t) {
                        this.onFail(t);
                        return;
                    }
                    ResourceCollectionService.this.outputQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)pair.getRight()));
                }

                @Override
                public void onFail(Throwable t) {
                    ResourceCollectionService.this.errorQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)t));
                }
            };
            try {
                this.checkResourcesStatus((RGridDom)pair.getLeft(), (Map)pair.getRight(), checkResourceListener);
            }
            catch (Throwable t) {
                checkResourceListener.onFail(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkResourcesStatus(final RGridDom dom, final Map<String, RGridResource> resourceMap, final ServiceTaskListener<List<RGridResource>> listener) throws JsonProcessingException {
        Object resource2;
        ArrayList<HashObject> hashesToCheck = new ArrayList<HashObject>();
        final HashMap<String, String> hashToResourceUrl = new HashMap<String, String>();
        for (Object resource2 : resourceMap.values()) {
            String url = resource2.getUrl();
            String hash = resource2.getSha256();
            String hashFormat = resource2.getHashFormat();
            Map<String, SyncTaskListener<Void>> map = this.uploadedResourcesCache;
            synchronized (map) {
                if (!this.uploadedResourcesCache.containsKey(hash)) {
                    hashesToCheck.add(new HashObject(hashFormat, hash));
                    hashToResourceUrl.put(hash, url);
                }
            }
        }
        final RGridResource domResource = dom.asResource();
        resource2 = this.uploadedResourcesCache;
        synchronized (resource2) {
            if (!this.uploadedResourcesCache.containsKey(domResource.getSha256())) {
                hashesToCheck.add(new HashObject(domResource.getHashFormat(), domResource.getSha256()));
                hashToResourceUrl.put(domResource.getSha256(), domResource.getUrl());
            }
        }
        if (hashesToCheck.isEmpty()) {
            listener.onComplete(new ArrayList());
            return;
        }
        final HashObject[] hashesArray = hashesToCheck.toArray(new HashObject[0]);
        this.serverConnector.checkResourceStatus(new TaskListener<Boolean[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Boolean[] result) {
                if (result == null) {
                    this.onFail();
                    return;
                }
                ResourceCollectionService.this.logger.log(TraceLevel.Info, dom.getTestIds(), Stage.RESOURCE_COLLECTION, Type.CHECK_RESOURCE, new Pair[]{Pair.of((Object)"result", (Object)result)});
                ArrayList<Object> missingResources = new ArrayList<Object>();
                for (int i = 0; i < result.length; ++i) {
                    String hash = hashesArray[i].getHash();
                    String resourceUrl = (String)hashToResourceUrl.get(hash);
                    if (result[i] != null && result[i].booleanValue()) {
                        Map<String, SyncTaskListener<Void>> map = ResourceCollectionService.this.uploadedResourcesCache;
                        synchronized (map) {
                            RGridResource resource = resourceUrl.equals(domResource.getUrl()) && hash.equals(domResource.getSha256()) ? domResource : (RGridResource)resourceMap.get(resourceUrl);
                            resource.resetContent();
                            ResourceCollectionService.this.uploadedResourcesCache.put(resource.getSha256(), null);
                            continue;
                        }
                    }
                    if (resourceUrl.equals(domResource.getUrl()) && hash.equals(domResource.getSha256())) {
                        missingResources.add(domResource);
                        continue;
                    }
                    missingResources.add(resourceMap.get(resourceUrl));
                }
                listener.onComplete(missingResources);
            }

            public void onFail() {
                listener.onFail((Throwable)new EyesException("Failed checking resources with the server"));
            }
        }, dom.getTestIds(), null, hashesArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uploadResources(Set<String> testIds, List<RGridResource> resources) {
        this.logger.log(TraceLevel.Info, testIds, Stage.RESOURCE_COLLECTION, Type.UPLOAD_RESOURCE, new Pair[]{Pair.of((Object)"resources", resources)});
        for (RGridResource resource : resources) {
            Map<String, SyncTaskListener<Void>> map = this.uploadedResourcesCache;
            synchronized (map) {
                if (this.uploadedResourcesCache.containsKey(resource.getSha256())) {
                    continue;
                }
                SyncTaskListener listener = new SyncTaskListener(this.logger, String.format("uploadResource %s %s", resource.getSha256(), resource.getUrl()));
                this.serverConnector.renderPutResource(testIds, "NONE", resource, (TaskListener)listener);
                this.uploadedResourcesCache.put(resource.getSha256(), (SyncTaskListener<Void>)listener);
            }
        }
        for (RGridResource resource : resources) {
            SyncTaskListener<Void> listener = this.uploadedResourcesCache.get(resource.getSha256());
            if (listener == null) continue;
            listener.get();
        }
        this.logger.log(TraceLevel.Info, testIds, Stage.RESOURCE_COLLECTION, Type.UPLOAD_RESOURCE, new Pair[]{Pair.of((Object)"completed", (Object)true)});
    }
}

