/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.services;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.services.EyesService;
import com.applitools.eyes.visualgrid.services.ServiceTaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class CheckService
extends EyesService<MatchWindowData, MatchResult> {
    private final List<Pair<String, MatchWindowData>> matchWindowQueue = Collections.synchronizedList(new ArrayList());
    private final Set<String> inUploadProcess = Collections.synchronizedSet(new HashSet());
    private final Set<String> inMatchWindowProcess = Collections.synchronizedSet(new HashSet());

    public CheckService(Logger logger, ServerConnector serverConnector) {
        super(logger, serverConnector);
    }

    @Override
    public void run() {
        MatchWindowData matchWindowData;
        Pair<String, MatchWindowData> nextInput;
        while (!this.inputQueue.isEmpty()) {
            nextInput = (Pair<String, MatchWindowData>)this.inputQueue.remove(0);
            matchWindowData = (MatchWindowData)nextInput.getRight();
            this.inUploadProcess.add((String)nextInput.getLeft());
            this.tryUploadImage((String)nextInput.getLeft(), matchWindowData, new ServiceTaskListener<Void>(){

                @Override
                public void onComplete(Void output) {
                    CheckService.this.inUploadProcess.remove(nextInput.getLeft());
                    CheckService.this.matchWindowQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)matchWindowData));
                }

                @Override
                public void onFail(Throwable t) {
                    CheckService.this.inUploadProcess.remove(nextInput.getLeft());
                    CheckService.this.errorQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)t));
                }
            });
        }
        while (!this.matchWindowQueue.isEmpty()) {
            nextInput = this.matchWindowQueue.remove(0);
            matchWindowData = (MatchWindowData)nextInput.getRight();
            this.inMatchWindowProcess.add((String)nextInput.getLeft());
            ServiceTaskListener<MatchResult> listener = new ServiceTaskListener<MatchResult>(){

                @Override
                public void onComplete(MatchResult taskResponse) {
                    CheckService.this.inMatchWindowProcess.remove(nextInput.getLeft());
                    CheckService.this.outputQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)taskResponse));
                }

                @Override
                public void onFail(Throwable t) {
                    CheckService.this.inMatchWindowProcess.remove(nextInput.getLeft());
                    CheckService.this.errorQueue.add(Pair.of((Object)nextInput.getLeft(), (Object)t));
                }
            };
            this.matchWindow((String)nextInput.getLeft(), matchWindowData, listener);
        }
    }

    public void tryUploadImage(final String testId, MatchWindowData data, final ServiceTaskListener<Void> taskListener) {
        final AppOutput appOutput = data.getAppOutput();
        if (appOutput.getScreenshotUrl() != null) {
            taskListener.onComplete(null);
            return;
        }
        TaskListener<String> uploadListener = new TaskListener<String>(){

            public void onComplete(String s) {
                if (s == null) {
                    this.onFail();
                    return;
                }
                CheckService.this.logger.log(TraceLevel.Info, Collections.singleton(testId), Stage.CHECK, Type.UPLOAD_COMPLETE, new Pair[]{Pair.of((Object)"url", (Object)s)});
                appOutput.setScreenshotUrl(s);
                taskListener.onComplete(null);
            }

            public void onFail() {
                appOutput.setScreenshotUrl(null);
                taskListener.onFail((Throwable)new EyesException("Failed uploading image"));
            }
        };
        try {
            this.logger.log(TraceLevel.Info, Collections.singleton(testId), Stage.CHECK, Type.UPLOAD_START, new Pair[]{Pair.of((Object)"matchWindowData", this.matchWindowQueue)});
            this.serverConnector.uploadImage(uploadListener, appOutput.getScreenshotBytes());
        }
        catch (Throwable t) {
            taskListener.onFail(t);
        }
    }

    public void matchWindow(final String testId, MatchWindowData data, final ServiceTaskListener<MatchResult> listener) {
        try {
            this.logger.log(TraceLevel.Info, Collections.singleton(testId), Stage.CHECK, Type.MATCH_START, new Pair[]{Pair.of((Object)"matchWindowData", (Object)data)});
            this.serverConnector.matchWindow(new TaskListener<MatchResult>(){

                public void onComplete(MatchResult taskResponse) {
                    CheckService.this.logger.log(testId, Stage.CHECK, Type.MATCH_COMPLETE, new Pair[]{Pair.of((Object)"matchResult", (Object)taskResponse)});
                    listener.onComplete(taskResponse);
                }

                public void onFail() {
                    listener.onFail((Throwable)new EyesException("Match window failed"));
                }
            }, data);
        }
        catch (Throwable t) {
            listener.onFail(t);
        }
    }
}

