/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.SubregionForStitching;
import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;

@JsonIgnoreProperties(value={"location", "empty", "middleOffset", "size", "sizeEmpty", "subRegions", "area", "negativeLocation", "right", "bottom"})
public class Region
implements IRegion {
    @JsonProperty(value="left")
    private int left;
    @JsonProperty(value="top")
    private int top;
    @JsonProperty(value="width")
    private int width;
    @JsonProperty(value="height")
    private int height;
    @JsonProperty(value="coordinatesType")
    private CoordinatesType coordinatesType;
    public static final Region EMPTY = new Region(0, 0, 0, 0, CoordinatesType.SCREENSHOT_AS_IS);

    protected void makeEmpty() {
        this.left = EMPTY.getLeft();
        this.top = EMPTY.getTop();
        this.width = EMPTY.getWidth();
        this.height = EMPTY.getHeight();
        this.coordinatesType = EMPTY.getCoordinatesType();
    }

    @JsonCreator
    public Region(@JsonProperty(value="left") int left, @JsonProperty(value="top") int top, @JsonProperty(value="width") int width, @JsonProperty(value="height") int height) {
        this(left, top, width, height, CoordinatesType.SCREENSHOT_AS_IS);
    }

    public Region(int left, int top, int width, int height, CoordinatesType coordinatesType) {
        ArgumentGuard.greaterThanOrEqualToZero((long)width, (String)"width");
        ArgumentGuard.greaterThanOrEqualToZero((long)height, (String)"height");
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.coordinatesType = coordinatesType;
    }

    public Region(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height, CoordinatesType.SCREENSHOT_AS_IS);
    }

    public boolean isEmpty() {
        return this.getLeft() == EMPTY.getLeft() && this.getTop() == EMPTY.getTop() && this.getWidth() == EMPTY.getWidth() && this.getHeight() == EMPTY.getHeight();
    }

    public boolean isSizeEmpty() {
        return this.getWidth() <= 0 || this.getHeight() <= 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Region)) {
            return false;
        }
        Region other = (Region)obj;
        return this.getLeft() == other.getLeft() && this.getTop() == other.getTop() && this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight();
    }

    public int hashCode() {
        return this.left + this.top + this.width + this.height;
    }

    public Region(Location location, RectangleSize size) {
        this(location, size, CoordinatesType.SCREENSHOT_AS_IS);
    }

    public Region(Location location, RectangleSize size, CoordinatesType coordinatesType) {
        ArgumentGuard.notNull((Object)size, (String)"size");
        this.left = location.getX();
        this.top = location.getY();
        this.width = size.getWidth();
        this.height = size.getHeight();
        this.coordinatesType = coordinatesType;
    }

    public Region(IRegion other) {
        ArgumentGuard.notNull((Object)other, (String)"other");
        this.left = other.getLeft();
        this.top = other.getTop();
        this.width = other.getWidth();
        this.height = other.getHeight();
        this.coordinatesType = other.getCoordinatesType();
    }

    @Override
    public Location getLocation() {
        return new Location(this.left, this.top);
    }

    public Location getNegativeLocation() {
        return new Location(-this.left, -this.top);
    }

    @Override
    public Region offset(int dx, int dy) {
        return new Region(this.getLocation().offset(dx, dy), this.getSize(), this.getCoordinatesType());
    }

    public Region offset(Location location) {
        return new Region(this.getLocation().offset(location), this.getSize(), this.getCoordinatesType());
    }

    public Region scale(double scaleRatio) {
        return new Region(this.getLocation().scale(scaleRatio), this.getSize().scale(scaleRatio), this.getCoordinatesType());
    }

    @Override
    public RectangleSize getSize() {
        return new RectangleSize(this.width, this.height);
    }

    @Override
    public CoordinatesType getCoordinatesType() {
        return this.coordinatesType;
    }

    public void setCoordinatesType(CoordinatesType value) {
        this.coordinatesType = value;
    }

    public void setSize(RectangleSize size) {
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    public void setLocation(Location location) {
        ArgumentGuard.notNull((Object)location, (String)"location");
        this.left = location.getX();
        this.top = location.getY();
    }

    private static Iterable<Region> getSubRegionsWithFixedSize(Region containerRegion, RectangleSize subRegionSize) {
        ArgumentGuard.notNull((Object)containerRegion, (String)"containerRegion");
        ArgumentGuard.notNull((Object)subRegionSize, (String)"subRegionSize");
        LinkedList<Region> subRegions = new LinkedList<Region>();
        int subRegionWidth = subRegionSize.getWidth();
        int subRegionHeight = subRegionSize.getHeight();
        ArgumentGuard.greaterThanZero((long)subRegionWidth, (String)"subRegionSize width");
        ArgumentGuard.greaterThanZero((long)subRegionHeight, (String)"subRegionSize height");
        if (subRegionWidth > containerRegion.width) {
            subRegionWidth = containerRegion.width;
        }
        if (subRegionHeight > containerRegion.height) {
            subRegionHeight = containerRegion.height;
        }
        if (subRegionWidth == containerRegion.width && subRegionHeight == containerRegion.height) {
            subRegions.add(new Region(containerRegion));
            return subRegions;
        }
        int bottom = containerRegion.top + containerRegion.height - 1;
        int right = containerRegion.left + containerRegion.width - 1;
        CoordinatesType currentType = containerRegion.getCoordinatesType();
        for (int currentTop = containerRegion.top; currentTop <= bottom; currentTop += subRegionHeight) {
            if (currentTop + subRegionHeight > bottom) {
                currentTop = bottom - subRegionHeight + 1;
            }
            for (int currentLeft = containerRegion.left; currentLeft <= right; currentLeft += subRegionWidth) {
                if (currentLeft + subRegionWidth > right) {
                    currentLeft = right - subRegionWidth + 1;
                }
                subRegions.add(new Region(currentLeft, currentTop, subRegionWidth, subRegionHeight, currentType));
            }
        }
        return subRegions;
    }

    private static Iterable<Region> getSubRegionsWithVaryingSize(Region containerRegion, RectangleSize maxSubRegionSize) {
        ArgumentGuard.notNull((Object)containerRegion, (String)"containerRegion");
        ArgumentGuard.notNull((Object)maxSubRegionSize, (String)"maxSubRegionSize");
        ArgumentGuard.greaterThanZero((long)maxSubRegionSize.getWidth(), (String)"maxSubRegionSize.getWidth()");
        ArgumentGuard.greaterThanZero((long)maxSubRegionSize.getHeight(), (String)"maxSubRegionSize.getHeight()");
        LinkedList<Region> subRegions = new LinkedList<Region>();
        int bottom = containerRegion.top + containerRegion.height;
        int right = containerRegion.left + containerRegion.width;
        CoordinatesType currentType = containerRegion.getCoordinatesType();
        for (int currentTop = containerRegion.top; currentTop < bottom; currentTop += maxSubRegionSize.getHeight()) {
            int currentBottom = currentTop + maxSubRegionSize.getHeight();
            if (currentBottom > bottom) {
                currentBottom = bottom;
            }
            for (int currentLeft = containerRegion.left; currentLeft < right; currentLeft += maxSubRegionSize.getWidth()) {
                int currentRight = currentLeft + maxSubRegionSize.getWidth();
                if (currentRight > right) {
                    currentRight = right;
                }
                int currentHeight = currentBottom - currentTop;
                int currentWidth = currentRight - currentLeft;
                subRegions.add(new Region(currentLeft, currentTop, currentWidth, currentHeight, currentType));
            }
        }
        return subRegions;
    }

    public Iterable<Region> getSubRegions(RectangleSize subRegionSize, boolean isFixedSize) {
        if (isFixedSize) {
            return Region.getSubRegionsWithFixedSize(this, subRegionSize);
        }
        return Region.getSubRegionsWithVaryingSize(this, subRegionSize);
    }

    public Iterable<Region> getSubRegions(RectangleSize subRegionSize) {
        return this.getSubRegions(subRegionSize, false);
    }

    public boolean contains(Region other) {
        int right = this.left + this.width;
        int otherRight = other.getLeft() + other.getWidth();
        int bottom = this.top + this.height;
        int otherBottom = other.getTop() + other.getHeight();
        return this.top <= other.getTop() && this.left <= other.getLeft() && bottom >= otherBottom && right >= otherRight;
    }

    public boolean contains(Location location) {
        return location.getX() >= this.left && location.getX() <= this.left + this.width && location.getY() >= this.top && location.getY() <= this.top + this.height;
    }

    public boolean isIntersected(Region other) {
        int right = this.left + this.width;
        int bottom = this.top + this.height;
        int otherLeft = other.getLeft();
        int otherTop = other.getTop();
        int otherRight = otherLeft + other.getWidth();
        int otherBottom = otherTop + other.getHeight();
        return (this.left <= otherLeft && otherLeft <= right || otherLeft <= this.left && this.left <= otherRight) && (this.top <= otherTop && otherTop <= bottom || otherTop <= this.top && this.top <= otherBottom);
    }

    public void intersect(Region other) {
        Region intersected = this.getIntersected(other);
        this.setLocation(intersected.getLocation());
        this.setSize(intersected.getSize());
    }

    public Region getIntersected(Region other) {
        if (!this.isIntersected(other)) {
            return EMPTY;
        }
        int otherLeft = other.getLeft();
        int otherTop = other.getTop();
        int intersectionLeft = this.left >= otherLeft ? this.left : otherLeft;
        int intersectionTop = this.top >= otherTop ? this.top : otherTop;
        int right = this.left + this.width;
        int otherRight = otherLeft + other.getWidth();
        int intersectionRight = right <= otherRight ? right : otherRight;
        int intersectionWidth = intersectionRight - intersectionLeft;
        int bottom = this.top + this.height;
        int otherBottom = otherTop + other.getHeight();
        int intersectionBottom = bottom <= otherBottom ? bottom : otherBottom;
        int intersectionHeight = intersectionBottom - intersectionTop;
        return new Region(intersectionLeft, intersectionTop, intersectionWidth, intersectionHeight, this.coordinatesType);
    }

    @Override
    public int getLeft() {
        return this.left;
    }

    @Override
    public int getTop() {
        return this.top;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setLeft(int value) {
        this.left = value;
    }

    public void setTop(int value) {
        this.top = value;
    }

    public int getBottom() {
        return this.top + this.height;
    }

    public int getRight() {
        return this.left + this.width;
    }

    public void setWidth(int value) {
        this.width = value;
    }

    public void setHeight(int value) {
        this.height = value;
    }

    public Location getMiddleOffset() {
        int middleX = this.width / 2;
        int middleY = this.height / 2;
        return new Location(middleX, middleY);
    }

    public Region expandToContain(Region region) {
        int left = Math.min(this.left, region.left);
        int top = Math.min(this.top, region.top);
        int thisRight = this.left + this.width;
        int otherRight = region.left + region.width;
        int maxRight = Math.max(thisRight, otherRight);
        int width = maxRight - left;
        int thisBottom = this.top + this.height;
        int otherBottom = region.top + region.height;
        int maxBottom = Math.max(thisBottom, otherBottom);
        int height = maxBottom - top;
        return new Region(left, top, width, height);
    }

    public String toString() {
        return "(" + this.left + ", " + this.top + ") " + this.width + "x" + this.height + ", " + (Object)((Object)this.coordinatesType);
    }

    @Override
    public int getArea() {
        return this.getWidth() * this.getHeight();
    }

    @JsonProperty(value="x")
    public void setX(int x) {
        this.left = x;
    }

    @JsonProperty(value="y")
    public void setY(int y) {
        this.top = y;
    }

    public SubregionForStitching[] getSubRegions(RectangleSize maxSubRegionSize, int logicalOverlap, double l2pScaleRatio, Rectangle physicalRectInScreenshot, Logger logger) {
        ArrayList<SubregionForStitching> subRegions = new ArrayList<SubregionForStitching>();
        int doubleLogicalOverlap = logicalOverlap * 2;
        int physicalOverlap = (int)Math.round((double)doubleLogicalOverlap * l2pScaleRatio);
        boolean needVScroll = (double)this.height * l2pScaleRatio > physicalRectInScreenshot.getHeight();
        boolean needHScroll = (double)this.width * l2pScaleRatio > physicalRectInScreenshot.getWidth();
        int scrollY = 0;
        int currentTop = 0;
        int currentLogicalHeight = maxSubRegionSize.getHeight();
        int deltaY = currentLogicalHeight - doubleLogicalOverlap;
        boolean isTopEdge = true;
        boolean isBottomEdge = false;
        while (!isBottomEdge) {
            int currentScrollTop = scrollY + maxSubRegionSize.getHeight();
            if (currentScrollTop >= this.height) {
                if (!isTopEdge) {
                    scrollY = this.height - currentLogicalHeight;
                    currentLogicalHeight = this.height - currentTop;
                    currentTop = this.height - currentLogicalHeight - doubleLogicalOverlap - logicalOverlap;
                } else {
                    currentLogicalHeight = this.height - currentTop;
                }
                isBottomEdge = true;
            }
            int scrollX = 0;
            int currentLeft = 0;
            int currentLogicalWidth = maxSubRegionSize.getWidth();
            int deltaX = currentLogicalWidth - doubleLogicalOverlap;
            boolean isLeftEdge = true;
            boolean isRightEdge = false;
            while (!isRightEdge) {
                int lDelta;
                int pDelta;
                int currentScrollRight = scrollX + maxSubRegionSize.getWidth();
                if (currentScrollRight >= this.width) {
                    if (!isLeftEdge) {
                        scrollX = this.width - currentLogicalWidth;
                        currentLogicalWidth = this.width - currentLeft;
                        currentLeft = this.width - currentLogicalWidth - doubleLogicalOverlap - logicalOverlap;
                    } else {
                        currentLogicalWidth = this.width - currentLeft;
                    }
                    isRightEdge = true;
                }
                Rectangle physicalCropArea = new Rectangle(physicalRectInScreenshot);
                Rectangle logicalCropArea = new Rectangle(0, 0, currentLogicalWidth, currentLogicalHeight);
                Point pastePoint = new Point(currentLeft, currentTop);
                if (isRightEdge) {
                    int physicalWidth = (int)Math.round((double)currentLogicalWidth * l2pScaleRatio);
                    physicalCropArea.x = physicalRectInScreenshot.x + physicalRectInScreenshot.width - physicalWidth;
                    physicalCropArea.width = physicalWidth;
                }
                if (!isLeftEdge) {
                    logicalCropArea.x += logicalOverlap;
                    logicalCropArea.width -= logicalOverlap;
                }
                if (isRightEdge && !isLeftEdge) {
                    int newX = physicalCropArea.x - physicalOverlap * 2;
                    if (newX >= physicalRectInScreenshot.x) {
                        physicalCropArea.x -= physicalOverlap * 2;
                        physicalCropArea.width += physicalOverlap * 2;
                        logicalCropArea.width += doubleLogicalOverlap * 2;
                    } else {
                        pDelta = physicalRectInScreenshot.x - newX;
                        lDelta = (int)Math.round((double)pDelta / l2pScaleRatio);
                        physicalCropArea.x = physicalRectInScreenshot.x;
                        physicalCropArea.width += physicalOverlap * 2 - pDelta;
                        logicalCropArea.width += doubleLogicalOverlap * 2 - lDelta;
                        pastePoint.x += lDelta;
                    }
                }
                if (isBottomEdge) {
                    int physicalHeight = (int)Math.round((double)currentLogicalHeight * l2pScaleRatio);
                    physicalCropArea.y = physicalRectInScreenshot.y + physicalRectInScreenshot.height - physicalHeight;
                    physicalCropArea.height = physicalHeight;
                }
                if (!isTopEdge) {
                    logicalCropArea.y += logicalOverlap;
                    logicalCropArea.height -= logicalOverlap;
                }
                if (isBottomEdge && !isTopEdge) {
                    int newY = physicalCropArea.y - physicalOverlap * 2;
                    if (newY >= physicalRectInScreenshot.y) {
                        physicalCropArea.y -= physicalOverlap * 2;
                        physicalCropArea.height += physicalOverlap * 2;
                        logicalCropArea.height += doubleLogicalOverlap * 2;
                    } else {
                        pDelta = physicalRectInScreenshot.y - newY;
                        lDelta = (int)Math.round((double)pDelta / l2pScaleRatio);
                        physicalCropArea.y = physicalRectInScreenshot.y;
                        physicalCropArea.height += physicalOverlap * 2 - pDelta;
                        logicalCropArea.height += doubleLogicalOverlap * 2 - lDelta;
                        pastePoint.y += lDelta;
                    }
                }
                SubregionForStitching subregion = new SubregionForStitching(new Point(scrollX, scrollY), new Point(pastePoint), new Rectangle(physicalCropArea), new Rectangle(logicalCropArea));
                subRegions.add(subregion);
                currentLeft += deltaX;
                scrollX += deltaX;
                if (needHScroll && isLeftEdge) {
                    currentLeft += logicalOverlap;
                }
                isLeftEdge = false;
            }
            currentTop += deltaY;
            scrollY += deltaY;
            if (needVScroll && isTopEdge) {
                currentTop += logicalOverlap;
            }
            isTopEdge = false;
        }
        return subRegions.toArray(new SubregionForStitching[0]);
    }
}

