/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.EyesException;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.Iso8610CalendarSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class BatchInfo {
    private static final String BATCH_TIMEZONE = "UTC";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="batchSequenceName")
    private String sequenceName;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="startedAt")
    private String startedAt;
    @JsonProperty(value="notifyOnCompletion")
    private boolean notifyOnCompletion;
    @JsonProperty(value="isCompleted")
    private boolean isCompleted = false;
    @JsonProperty(value="properties")
    private final List<Map<String, String>> properties = new ArrayList<Map<String, String>>();

    public BatchInfo(String name, Calendar startedAt) {
        ArgumentGuard.notNull((Object)startedAt, (String)"startedAt");
        String envVarBatchId = GeneralUtils.getEnvString((String)"APPLITOOLS_BATCH_ID");
        String envSequenceName = GeneralUtils.getEnvString((String)"APPLITOOLS_BATCH_SEQUENCE");
        this.id = envVarBatchId != null ? envVarBatchId : UUID.randomUUID().toString();
        this.name = name != null ? name : GeneralUtils.getEnvString((String)"APPLITOOLS_BATCH_NAME");
        String env_batch_notify = GeneralUtils.getEnvString((String)"APPLITOOLS_BATCH_NOTIFY");
        this.notifyOnCompletion = Boolean.parseBoolean(env_batch_notify);
        this.sequenceName = envSequenceName;
        this.startedAt = GeneralUtils.toISO8601DateTime((Calendar)startedAt);
    }

    public BatchInfo(String id, String batchSequenceName, String name, String startedAt) {
        this.id = id;
        this.sequenceName = batchSequenceName;
        this.name = name;
        this.startedAt = startedAt;
    }

    public BatchInfo() {
        this(null);
    }

    public BatchInfo(String name) {
        this(name, Calendar.getInstance(TimeZone.getTimeZone(BATCH_TIMEZONE)));
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        ArgumentGuard.notNullOrEmpty((String)id, (String)"id");
        this.id = id;
    }

    public BatchInfo withBatchId(String id) {
        ArgumentGuard.notNullOrEmpty((String)id, (String)"id");
        this.id = id;
        return this;
    }

    @JsonSerialize(using=Iso8610CalendarSerializer.class)
    public Calendar getStartedAt() {
        try {
            return GeneralUtils.fromISO8601DateTime((String)this.startedAt);
        }
        catch (ParseException ex) {
            throw new EyesException("Failed to parse batch start time", (Throwable)ex);
        }
    }

    @JsonProperty(value="startedAt")
    public void setStartedAt(String startedAt) {
        this.startedAt = startedAt;
    }

    public String toString() {
        return "'" + this.name + "' - " + this.startedAt;
    }

    @JsonProperty(value="batchSequenceName")
    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BatchInfo)) {
            return false;
        }
        BatchInfo other = (BatchInfo)obj;
        return this.id.equals(other.id) && this.name.equals(other.name) && this.sequenceName.equals(other.sequenceName) && this.startedAt.equals(other.startedAt);
    }

    @JsonProperty(value="notifyOnCompletion")
    public boolean isNotifyOnCompletion() {
        return this.notifyOnCompletion;
    }

    @JsonProperty(value="notifyOnCompletion")
    public void setNotifyOnCompletion(boolean notifyOnCompletion) {
        this.notifyOnCompletion = notifyOnCompletion;
    }

    @JsonIgnore
    public boolean isCompleted() {
        return this.isCompleted;
    }

    @JsonInclude
    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
    }

    public BatchInfo addProperty(final String name, final String value) {
        this.properties.add((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("name", name);
                this.put("value", value);
            }
        });
        return this;
    }

    @JsonIgnore
    public List<Map<String, String>> getProperties() {
        return this.properties;
    }
}

