/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.applitools.eyes.EyesException;
import com.applitools.utils.ArgumentGuard;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class GeneralUtils {
    private static final String DATE_FORMAT_ISO8601_FOR_OUTPUT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DATE_FORMAT_ISO8601_FOR_INPUT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final String DATE_FORMAT_RFC1123 = "E, dd MMM yyyy HH:mm:ss 'GMT'";

    private GeneralUtils() {
    }

    public static String readToEnd(InputStream inputStream) throws IOException {
        int length;
        ArgumentGuard.notNull(inputStream, "inputStream");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return new String(baos.toByteArray());
    }

    public static String toISO8601DateTime(Calendar calendar) {
        ArgumentGuard.notNull(calendar, "calendar");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_ISO8601_FOR_OUTPUT, Locale.ENGLISH);
        formatter.setTimeZone(calendar.getTimeZone());
        return formatter.format(calendar.getTime());
    }

    public static String toRfc1123(Calendar calendar) {
        ArgumentGuard.notNull(calendar, "calendar");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_RFC1123, Locale.ENGLISH);
        formatter.setTimeZone(calendar.getTimeZone());
        return formatter.format(calendar.getTime());
    }

    public static Calendar fromISO8601DateTime(String dateTime) throws ParseException {
        ArgumentGuard.notNull(dateTime, "dateTime");
        dateTime = dateTime.replaceAll("\\.(\\d+)\\+", "+");
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_ISO8601_FOR_INPUT);
        Calendar cal = Calendar.getInstance();
        cal.setTime(formatter.parse(dateTime));
        return cal;
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("sleep interrupted", ex);
        }
    }

    public static Date getDate(DateFormat format, String date) {
        try {
            return format.parse(date);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static long getFullSecondsElapsedTimeMillis(long start, long end) {
        return (long)Math.ceil((double)(end - start) / 1000.0) * 1000L;
    }

    public static String readTextFromResource(String resource) {
        InputStream is = GeneralUtils.class.getClassLoader().getResourceAsStream(resource);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EyesException("Failed to read text from resource: ", e);
        }
        return sb.toString();
    }
}

