/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.LogHandler;
import com.applitools.eyes.NullLogHandler;
import com.applitools.utils.ArgumentGuard;

public class Logger {
    private LogHandler logHandler = new NullLogHandler();

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    public void setLogHandler(LogHandler handler) {
        ArgumentGuard.notNull(handler, "handler");
        this.logHandler = handler;
    }

    private String getPrefix() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String prefix = "";
        if (stackTraceElements != null && stackTraceElements.length >= 4) {
            prefix = stackTraceElements[3].getMethodName() + "():";
        }
        return prefix;
    }

    public void verbose(String message) {
        this.logHandler.onMessage(true, this.getPrefix() + message);
    }

    public void log(String message) {
        this.logHandler.onMessage(false, this.getPrefix() + message);
    }
}

