/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.ExactMatchSettings;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Region;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;

public class ImageMatchSettings {
    private MatchLevel matchLevel;
    private ExactMatchSettings exact;
    private Boolean ignoreCaret;
    private Region[] ignoreRegions;
    private FloatingMatchSettings[] floatingMatchSettings;

    public ImageMatchSettings(MatchLevel matchLevel, ExactMatchSettings exact) {
        this.matchLevel = matchLevel;
        this.exact = exact;
        this.ignoreCaret = null;
    }

    public ImageMatchSettings() {
        this(MatchLevel.STRICT, null);
    }

    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.matchLevel = matchLevel;
    }

    public ExactMatchSettings getExact() {
        return this.exact;
    }

    public void setExact(ExactMatchSettings exact) {
        this.exact = exact;
    }

    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    @JsonSetter(value="Ignore")
    public void setIgnoreRegions(Region[] ignoreRegions) {
        this.ignoreRegions = ignoreRegions;
    }

    @JsonGetter(value="Ignore")
    public Region[] getIgnoreRegions() {
        return this.ignoreRegions;
    }

    @JsonSetter(value="Floating")
    public void setFloatingRegions(FloatingMatchSettings[] floatingRegions) {
        this.floatingMatchSettings = floatingRegions;
    }

    @JsonGetter(value="Floating")
    public FloatingMatchSettings[] getFloatingRegions() {
        return this.floatingMatchSettings;
    }

    public void setIgnoreCaret(Boolean ignoreCaret) {
        this.ignoreCaret = ignoreCaret;
    }

    public String toString() {
        return String.format("Match level: %s, Exact match settings: %s", new Object[]{this.matchLevel, this.exact});
    }
}

