/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.ICheckSettings;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.IPutFuture;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResultsSummary;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.visualgrid.model.CompletableTask;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.NullDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RateLimiter;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RenderingTask;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.EyesService;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.IRenderingEyes;
import com.applitools.eyes.visualgrid.services.IResourceFuture;
import com.applitools.eyes.visualgrid.services.OpenerService;
import com.applitools.eyes.visualgrid.services.RenderingGridService;
import com.applitools.eyes.visualgrid.services.RunningTest;
import com.applitools.eyes.visualgrid.services.ScoreTask;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class VisualGridRunner
extends EyesRunner {
    private int concurrentOpenSessions;
    private final Object openerServiceDebugLock;
    private final Object checkerServiceDebugLock;
    private final Object closerServiceDebugLock;
    private final Object renderServiceDebugLock;
    private OpenerService eyesOpenerService;
    private EyesService eyesCloserService;
    private EyesService eyesCheckerService;
    private RenderingGridService renderingGridService;
    private ThreadGroup servicesGroup = new ThreadGroup("Services Group");
    private final List<IRenderingEyes> eyesToOpenList = Collections.synchronizedList(new ArrayList(200));
    private final Set<IRenderingEyes> allEyes = Collections.synchronizedSet(new HashSet());
    private Map<String, IResourceFuture> cachedResources = Collections.synchronizedMap(new HashMap());
    private Map<String, IPutFuture> putResourceCache = Collections.synchronizedMap(new HashMap());
    private final Object openerServiceConcurrencyLock = new Object();
    private final Object openerServiceLock = new Object();
    private final Object checkerServiceLock = new Object();
    private final Object closerServiceLock = new Object();
    private final Object renderingServiceLock = new Object();
    private final List<RenderingTask> renderingTaskList = Collections.synchronizedList(new ArrayList());
    private RenderingInfo renderingInfo;
    private IDebugResourceWriter debugResourceWriter;
    private RateLimiter rateLimiter;
    private String serverUrl;
    private static final String DEFAULT_API_KEY = GeneralUtils.getEnvString("APPLITOOLS_API_KEY");
    private String apiKey = DEFAULT_API_KEY;
    private boolean isDisabled;
    private boolean isServicesOn = false;
    private IRenderingEyes.EyesListener eyesListener = new IRenderingEyes.EyesListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTaskComplete(VisualGridTask visualGridTask, IRenderingEyes eyes) {
            VisualGridRunner.this.logger.verbose("Enter with: " + (Object)((Object)visualGridTask.getType()));
            VisualGridTask.TaskType type = visualGridTask.getType();
            try {
                switch (type) {
                    case OPEN: {
                        VisualGridRunner.this.logger.verbose("locking eyesToOpenList");
                        List list = VisualGridRunner.this.eyesToOpenList;
                        synchronized (list) {
                            VisualGridRunner.this.logger.verbose("removing visualGridTask " + visualGridTask.toString());
                            VisualGridRunner.this.eyesToOpenList.remove(eyes);
                        }
                        VisualGridRunner.this.logger.verbose("releasing eyesToOpenList");
                        break;
                    }
                    case ABORT: {
                        VisualGridRunner.this.logger.verbose("VisualGridTask Abort.");
                    }
                    case CLOSE: {
                        VisualGridRunner.this.logger.verbose("VisualGridTask Close.");
                        VisualGridRunner.this.eyesOpenerService.decrementConcurrency();
                        Object object = VisualGridRunner.this.openerServiceConcurrencyLock;
                        synchronized (object) {
                            VisualGridRunner.this.openerServiceConcurrencyLock.notify();
                        }
                        VisualGridRunner.this.logger.verbose("releasing openerServiceConcurrencyLock");
                        VisualGridRunner.this.logger.verbose("VisualGridTask Close.");
                        break;
                    }
                    case CHECK: {
                        VisualGridRunner.this.logger.verbose("Check complete.");
                    }
                }
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace(VisualGridRunner.this.logger, e);
            }
            VisualGridRunner.this.notifyAllServices();
        }

        @Override
        public void onRenderComplete() {
            VisualGridRunner.this.notifyAllServices();
        }
    };

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey != null ? apiKey : DEFAULT_API_KEY;
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    public boolean isServicesOn() {
        return this.isServicesOn;
    }

    private void setServicesOn(boolean servicesOn) {
        this.isServicesOn = servicesOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureTask<TestResultContainer> getOrWaitForTask(Object lock, EyesService.Tasker tasker, String serviceName) {
        FutureTask<TestResultContainer> nextTestToOpen = tasker.getNextTask();
        if (nextTestToOpen == null) {
            try {
                Object object = lock;
                synchronized (object) {
                    lock.wait(500L);
                }
                nextTestToOpen = tasker.getNextTask();
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
        return nextTestToOpen;
    }

    public void pauseAllService() {
        this.eyesOpenerService.debugPauseService();
        this.eyesCloserService.debugPauseService();
        this.eyesCheckerService.debugPauseService();
        this.renderingGridService.debugPauseService();
    }

    public VisualGridRunner(int concurrentOpenSessions) {
        this(concurrentOpenSessions, null, null, null, null);
    }

    public VisualGridRunner(int concurrentOpenSessions, Object openerServiceDebugLock, Object checkerServiceDebugLock, Object closerServiceDebugLock, Object renderServiceDebugLock) {
        this.concurrentOpenSessions = concurrentOpenSessions;
        this.openerServiceDebugLock = openerServiceDebugLock;
        this.checkerServiceDebugLock = checkerServiceDebugLock;
        this.closerServiceDebugLock = closerServiceDebugLock;
        this.renderServiceDebugLock = renderServiceDebugLock;
        this.rateLimiter = new RateLimiter(this.logger, 20);
        this.init();
        this.startServices();
        this.logger.verbose("rendering grid manager is built");
    }

    public Map<String, IResourceFuture> getCachedResources() {
        return this.cachedResources;
    }

    public Map<String, IPutFuture> getPutResourceCache() {
        return this.putResourceCache;
    }

    public RenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    private void init() {
        this.eyesOpenerService = new OpenerService("eyesOpenerService", this.servicesGroup, this.logger, this.concurrentOpenSessions, this.openerServiceConcurrencyLock, new EyesService.EyesServiceListener(){

            @Override
            public FutureTask<TestResultContainer> getNextTask(EyesService.Tasker tasker) {
                return VisualGridRunner.this.getOrWaitForTask(VisualGridRunner.this.openerServiceLock, tasker, "eyesOpenerService");
            }
        }, this.openerServiceDebugLock, new EyesService.Tasker(){

            @Override
            public FutureTask<TestResultContainer> getNextTask() {
                return VisualGridRunner.this.getNextTestToOpen();
            }
        });
        this.eyesCloserService = new EyesService("eyesCloserService", this.servicesGroup, this.logger, this.concurrentOpenSessions, this.closerServiceDebugLock, new EyesService.EyesServiceListener(){

            @Override
            public FutureTask<TestResultContainer> getNextTask(EyesService.Tasker tasker) {
                return VisualGridRunner.this.getOrWaitForTask(VisualGridRunner.this.closerServiceLock, tasker, "eyesCloserService");
            }
        }, new EyesService.Tasker(){

            @Override
            public FutureTask<TestResultContainer> getNextTask() {
                return VisualGridRunner.this.getNextTestToClose();
            }
        });
        this.renderingGridService = new RenderingGridService("renderingGridService", this.servicesGroup, this.logger, this.concurrentOpenSessions, this.renderServiceDebugLock, new RenderingGridService.RGServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RenderingTask getNextTask() {
                RenderingTask nextTestToRender = VisualGridRunner.this.getNextRenderingTask();
                if (nextTestToRender == null) {
                    Object object = VisualGridRunner.this.renderingServiceLock;
                    synchronized (object) {
                        try {
                            nextTestToRender = VisualGridRunner.this.getNextRenderingTask();
                            if (nextTestToRender == null) {
                                VisualGridRunner.this.renderingServiceLock.wait(500L);
                                nextTestToRender = VisualGridRunner.this.getNextRenderingTask();
                            }
                        }
                        catch (Exception e) {
                            GeneralUtils.logExceptionStackTrace(VisualGridRunner.this.logger, e);
                        }
                    }
                }
                return nextTestToRender;
            }
        }, this.renderingServiceLock);
        this.eyesCheckerService = new EyesService("eyesCheckerService", this.servicesGroup, this.logger, this.concurrentOpenSessions, this.checkerServiceDebugLock, new EyesService.EyesServiceListener(){

            @Override
            public FutureTask<TestResultContainer> getNextTask(EyesService.Tasker tasker) {
                return VisualGridRunner.this.getOrWaitForTask(VisualGridRunner.this.checkerServiceLock, tasker, "eyesCheckerService");
            }
        }, new EyesService.Tasker(){

            @Override
            public FutureTask<TestResultContainer> getNextTask() {
                return VisualGridRunner.this.getNextCheckTask();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureTask<TestResultContainer> getNextCheckTask() {
        VisualGridTask visualGridTask = null;
        try {
            ScoreTask bestScoreTask = null;
            int bestScore = -1;
            Set<IRenderingEyes> set = this.allEyes;
            synchronized (set) {
                for (IRenderingEyes eyes : this.allEyes) {
                    int currentTestMark;
                    ScoreTask currentScoreTask = eyes.getBestScoreTaskForCheck();
                    if (currentScoreTask == null || bestScore >= (currentTestMark = currentScoreTask.getScore())) continue;
                    bestScoreTask = currentScoreTask;
                    bestScore = currentTestMark;
                }
            }
            if (bestScoreTask == null) {
                return null;
            }
            visualGridTask = bestScoreTask.getVisualGridTask();
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        return new FutureTask<TestResultContainer>(visualGridTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderingTask getNextRenderingTask() {
        if (this.renderingTaskList.isEmpty()) {
            return null;
        }
        RenderingTask renderingTask = null;
        List<RenderingTask> list = this.renderingTaskList;
        synchronized (list) {
            if (!this.renderingTaskList.isEmpty()) {
                renderingTask = this.renderingTaskList.get(0);
                this.renderingTaskList.remove(renderingTask);
            }
        }
        return renderingTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureTask<TestResultContainer> getNextTestToClose() {
        Set<IRenderingEyes> set = this.allEyes;
        synchronized (set) {
            for (IRenderingEyes eyes : this.allEyes) {
                RunningTest runningTest = eyes.getNextTestToClose();
                if (runningTest == null) continue;
                return runningTest.getNextCloseTask();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FutureTask<TestResultContainer> getNextTestToOpen() {
        ScoreTask bestScoreTask = null;
        int bestMark = -1;
        Set<IRenderingEyes> set = this.allEyes;
        synchronized (set) {
            for (IRenderingEyes eyes : this.allEyes) {
                int currentScore;
                ScoreTask currentTestMark = null;
                try {
                    currentTestMark = eyes.getBestScoreTaskForOpen();
                }
                catch (Exception e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
                if (currentTestMark == null || bestMark >= (currentScore = currentTestMark.getScore())) continue;
                bestMark = currentScore;
                bestScoreTask = currentTestMark;
            }
        }
        if (bestScoreTask == null) {
            return null;
        }
        this.logger.verbose("found test with mark " + bestMark);
        this.logger.verbose("calling getNextOpenTaskAndRemove on " + bestScoreTask.toString());
        VisualGridTask nextOpenVisualGridTask = bestScoreTask.getVisualGridTask();
        return new FutureTask<TestResultContainer>(nextOpenVisualGridTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(IRenderingEyes eyes, RenderingInfo renderingInfo) {
        this.logger.verbose("enter");
        if (this.renderingInfo == null) {
            this.renderingInfo = renderingInfo;
        }
        Collection<IRenderingEyes> collection = this.eyesToOpenList;
        synchronized (collection) {
            this.eyesToOpenList.add(eyes);
        }
        if (this.allEyes.isEmpty()) {
            this.setLogger(eyes.getLogger());
        }
        collection = this.allEyes;
        synchronized (collection) {
            this.allEyes.add(eyes);
        }
        this.logger.verbose("releasing allEyes");
        eyes.setListener(this.eyesListener);
        this.logger.verbose("concurrencyLock.notify()");
        this.addBatch(eyes.getBatchId(), eyes.getBatchCloser());
    }

    private void startServices() {
        this.logger.verbose("enter");
        this.setServicesOn(true);
        this.servicesGroup.setDaemon(true);
        this.eyesOpenerService.start();
        this.eyesCloserService.start();
        this.renderingGridService.start();
        this.eyesCheckerService.start();
        this.logger.verbose("exit");
    }

    private void stopServices() {
        this.logger.verbose("enter");
        this.setServicesOn(false);
        this.eyesOpenerService.stopService();
        this.eyesCloserService.stopService();
        this.renderingGridService.stopService();
        this.eyesCheckerService.stopService();
        this.logger.verbose("exit");
    }

    @Override
    public TestResultsSummary getAllTestResultsImpl() {
        return this.getAllTestResults(true);
    }

    @Override
    public TestResultsSummary getAllTestResultsImpl(boolean throwException) {
        this.logger.verbose("enter");
        HashMap<IRenderingEyes, Collection<Future<TestResultContainer>>> allFutures = new HashMap<IRenderingEyes, Collection<Future<TestResultContainer>>>();
        for (IRenderingEyes eyes : this.allEyes) {
            Collection<Future<TestResultContainer>> futureList = eyes.close();
            Collection futures = (Collection)allFutures.get(eyes);
            if (futures != null && !futures.isEmpty()) {
                futureList.addAll(futures);
            }
            allFutures.put(eyes, futureList);
        }
        Throwable exception = null;
        this.notifyAllServices();
        ArrayList<TestResultContainer> allResults = new ArrayList<TestResultContainer>();
        this.logger.verbose("trying to call future.get on " + allFutures.size() + " future lists.");
        for (Map.Entry entry : allFutures.entrySet()) {
            Collection value = (Collection)entry.getValue();
            IRenderingEyes key = (IRenderingEyes)entry.getKey();
            key.getAllTestResults().clear();
            this.logger.verbose("trying to call future.get on " + value.size() + " futures of " + key);
            for (Future future : value) {
                TestResultContainer obj;
                block8: {
                    this.logger.verbose("calling future.get on " + key);
                    obj = null;
                    try {
                        obj = (TestResultContainer)future.get(10L, TimeUnit.MINUTES);
                        if (obj.getException() != null && exception == null) {
                            exception = obj.getException();
                        }
                    }
                    catch (Throwable e) {
                        GeneralUtils.logExceptionStackTrace(this.logger, e);
                        if (exception != null) break block8;
                        exception = e;
                    }
                }
                this.logger.verbose("got TestResultContainer: " + obj);
                allResults.add(obj);
                key.getAllTestResults().add(obj);
            }
        }
        this.stopServices();
        this.notifyAllServices();
        this.logger.verbose("exit");
        if (throwException && exception != null) {
            throw new Error(exception);
        }
        return new TestResultsSummary(allResults);
    }

    public void close(IRenderingEyes eyes) {
        this.logger.verbose("adding eyes to close list: " + eyes);
        this.notifyAllServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void check(ICheckSettings settings, IDebugResourceWriter debugResourceWriter, FrameData script, IEyesConnector connector, List<VisualGridTask> visualGridTaskList, List<VisualGridTask> openVisualGridTasks, String resultAsString, final RenderListener listener, List<VisualGridSelector[]> selectors, UserAgent userAgent) {
        if (debugResourceWriter == null) {
            debugResourceWriter = this.debugResourceWriter;
        }
        if (debugResourceWriter == null) {
            debugResourceWriter = new NullDebugResourceWriter();
        }
        RenderingTask renderingTask = new RenderingTask(connector, script, settings, visualGridTaskList, openVisualGridTasks, this, debugResourceWriter, new RenderingTask.RenderTaskListener(){

            @Override
            public void onRenderSuccess() {
                VisualGridRunner.this.logger.verbose("enter");
                listener.onRenderSuccess();
                VisualGridRunner.this.notifyAllServices();
                VisualGridRunner.this.logger.verbose("exit");
            }

            @Override
            public void onRenderFailed(Exception e) {
                VisualGridRunner.this.notifyAllServices();
                listener.onRenderFailed(e);
            }
        }, userAgent, selectors);
        this.logger.verbose("locking renderingTaskList");
        List<RenderingTask> list = this.renderingTaskList;
        synchronized (list) {
            this.renderingTaskList.add(renderingTask);
        }
        debugResourceWriter.write(new RGridResource("http://THE_DOM_SNAPSHOT_RESULT.com", "DOM_SNAPSHOT", resultAsString.getBytes(), this.logger, ""));
        this.logger.verbose("releasing renderingTaskList");
        this.notifyAllServices();
    }

    private void notifyAllServices() {
        this.logger.verbose("enter");
        this.notifyOpenerService();
        this.notifyCloserService();
        this.notifyCheckerService();
        this.notifyRenderingService();
        this.logger.verbose("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRenderingService() {
        this.logger.verbose("trying to notify rendering service");
        Object object = this.renderingServiceLock;
        synchronized (object) {
            this.renderingServiceLock.notify();
        }
        this.logger.verbose("renderingLockFree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCloserService() {
        this.logger.verbose("trying to notify closer service");
        Object object = this.closerServiceLock;
        synchronized (object) {
            this.closerServiceLock.notifyAll();
        }
        this.logger.verbose("closerLockFree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOpenerService() {
        this.logger.verbose("trying to notify opener service");
        Object object = this.openerServiceLock;
        synchronized (object) {
            this.openerServiceLock.notifyAll();
            this.logger.verbose("openerLockFree");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCheckerService() {
        this.logger.verbose("trying to notify checker service");
        Object object = this.checkerServiceLock;
        synchronized (object) {
            this.checkerServiceLock.notifyAll();
            this.logger.verbose("checkerLockFree");
        }
    }

    public List<CompletableTask> getAllTasksByType(VisualGridTask.TaskType type) {
        ArrayList<CompletableTask> allTasks = new ArrayList<CompletableTask>();
        for (IRenderingEyes eyes : this.allEyes) {
            for (RunningTest runningTest : eyes.getAllRunningTests()) {
                for (VisualGridTask visualGridTask : runningTest.getVisualGridTaskList()) {
                    if (visualGridTask.getType() != type) continue;
                    allTasks.add(visualGridTask);
                }
            }
        }
        return allTasks;
    }

    public List<? extends CompletableTask> getAllRenderingTasks() {
        return this.renderingTaskList;
    }

    public void setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.debugResourceWriter = debugResourceWriter;
    }

    public IDebugResourceWriter getDebugResourceWriter() {
        return this.debugResourceWriter;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setLogger(Logger logger) {
        this.eyesCheckerService.setLogger(logger);
        this.eyesCloserService.setLogger(logger);
        this.eyesOpenerService.setLogger(logger);
        this.renderingGridService.setLogger(logger);
        this.logger = logger;
    }

    public static interface RenderListener {
        public void onRenderSuccess();

        public void onRenderFailed(Exception var1);
    }
}

