/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.ICheckSettings;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.selenium.Configuration;
import com.applitools.eyes.selenium.ISeleniumConfigurationProvider;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderingTask;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.ScoreTask;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class RunningTest {
    private final List<VisualGridTask> visualGridTaskList = Collections.synchronizedList(new ArrayList());
    private IEyesConnector eyes;
    private RenderBrowserInfo browserInfo;
    private AtomicBoolean isTestOpen = new AtomicBoolean(false);
    private AtomicBoolean isTestClose = new AtomicBoolean(false);
    private AtomicBoolean isTestInExceptionMode = new AtomicBoolean(false);
    private RunningTestListener listener;
    private ISeleniumConfigurationProvider configurationProvider;
    private HashMap<VisualGridTask, FutureTask<TestResultContainer>> taskToFutureMapping = new HashMap();
    private Logger logger;
    private AtomicBoolean isCloseTaskIssued = new AtomicBoolean(false);
    private VisualGridTask closeTask;
    private VisualGridTask openTask;
    private String appName;
    private String testName;
    private Throwable error;
    private VisualGridTask.TaskListener taskListener = new VisualGridTask.TaskListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTaskComplete(VisualGridTask visualGridTask) {
            RunningTest runningTest = RunningTest.this;
            RunningTest.this.logger.verbose("locking runningTest.visualGridTaskList");
            List list = runningTest.visualGridTaskList;
            synchronized (list) {
                runningTest.visualGridTaskList.remove(visualGridTask);
            }
            RunningTest.this.logger.verbose("releasing runningTest.visualGridTaskList");
            switch (visualGridTask.getType()) {
                case OPEN: {
                    runningTest.setTestOpen(true);
                    break;
                }
                case CLOSE: 
                case ABORT: {
                    RunningTest.this.isTestClose.set(true);
                }
            }
            if (runningTest.listener != null) {
                RunningTest.this.listener.onTaskComplete(visualGridTask, RunningTest.this);
            }
        }

        @Override
        public void onTaskFailed(Throwable e, VisualGridTask visualGridTask) {
            RunningTest.this.setTestInExceptionMode(e);
            RunningTest.this.listener.onTaskComplete(visualGridTask, RunningTest.this);
        }

        @Override
        public void onRenderComplete(RenderingTask renderingTask, Throwable error) {
            RunningTest.this.logger.verbose("enter");
            RunningTest.this.listener.onRenderComplete();
            RunningTest.this.logger.verbose("exit");
        }
    };

    public RunningTest(IEyesConnector eyes, ISeleniumConfigurationProvider configuration, RenderBrowserInfo browserInfo, Logger logger, RunningTestListener listener) {
        this.eyes = eyes;
        this.browserInfo = browserInfo;
        this.configurationProvider = configuration;
        this.listener = listener;
        this.logger = logger;
        this.appName = this.configurationProvider.get().getAppName();
        this.testName = this.configurationProvider.get().getTestName();
    }

    public Future<TestResultContainer> abort(Throwable e) {
        this.removeAllCheckTasks();
        if (this.isOpenTaskIssued()) {
            this.openTask.setException(e);
        }
        if (this.closeTask != null && this.closeTask.getType() == VisualGridTask.TaskType.CLOSE) {
            this.closeTask.setExceptionAndAbort(e);
        }
        if (this.closeTask == null) {
            VisualGridTask abortTask = new VisualGridTask(new Configuration(this.configurationProvider.get()), null, this.eyes, VisualGridTask.TaskType.ABORT, this.taskListener, null, this, null, null);
            this.visualGridTaskList.add(abortTask);
            this.closeTask = abortTask;
            FutureTask<TestResultContainer> futureTask = new FutureTask<TestResultContainer>(abortTask);
            this.taskToFutureMapping.put(abortTask, futureTask);
            this.isCloseTaskIssued.set(true);
        }
        return this.taskToFutureMapping.get(this.closeTask);
    }

    public IBatchCloser getBatchCloser() {
        return (IBatchCloser)((Object)this.eyes);
    }

    private void removeAllCheckTasks() {
        Iterator<VisualGridTask> iterator = this.visualGridTaskList.iterator();
        while (iterator.hasNext()) {
            VisualGridTask next = iterator.next();
            if (next.getType() != VisualGridTask.TaskType.CHECK) continue;
            iterator.remove();
        }
    }

    public Future<TestResultContainer> abortIfNotClosed() {
        if (this.isCloseTaskIssued.get() && this.closeTask.isSent()) {
            return null;
        }
        return this.abort(null);
    }

    public boolean isCloseTaskIssued() {
        return this.closeTask != null;
    }

    public boolean isTestOpen() {
        return this.isTestOpen.get();
    }

    private void setTestOpen(boolean testOpen) {
        this.isTestOpen.set(testOpen);
    }

    public List<VisualGridTask> getVisualGridTaskList() {
        return this.visualGridTaskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScoreTask getScoreTaskObjectByType(VisualGridTask.TaskType taskType) {
        VisualGridTask chosenVisualGridTask;
        if (!this.isTestOpen.get() && taskType == VisualGridTask.TaskType.CHECK) {
            return null;
        }
        int score = 0;
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            for (VisualGridTask visualGridTask : this.visualGridTaskList) {
                if (!visualGridTask.isTaskReadyToCheck() || visualGridTask.getType() != VisualGridTask.TaskType.CHECK) continue;
                ++score;
            }
            if (this.visualGridTaskList.isEmpty()) {
                return null;
            }
            chosenVisualGridTask = this.visualGridTaskList.get(0);
            if (chosenVisualGridTask.getType() != taskType || chosenVisualGridTask.isSent() || taskType == VisualGridTask.TaskType.OPEN && !chosenVisualGridTask.isTaskReadyToCheck()) {
                return null;
            }
        }
        return new ScoreTask(chosenVisualGridTask, score);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FutureTask<TestResultContainer> getNextCloseTask() {
        if (!this.visualGridTaskList.isEmpty() && this.isCloseTaskIssued.get()) {
            VisualGridTask visualGridTask = this.visualGridTaskList.get(0);
            VisualGridTask.TaskType type = visualGridTask.getType();
            if (type != VisualGridTask.TaskType.CLOSE && type != VisualGridTask.TaskType.ABORT) {
                return null;
            }
            List<VisualGridTask> list = this.visualGridTaskList;
            synchronized (list) {
                this.visualGridTaskList.remove(visualGridTask);
            }
            return this.taskToFutureMapping.get(visualGridTask);
        }
        return null;
    }

    public RenderBrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualGridTask open() {
        VisualGridTask visualGridTask;
        this.logger.verbose("adding Open visualGridTask...");
        this.openTask = visualGridTask = new VisualGridTask(new Configuration(this.configurationProvider.get()), null, this.eyes, VisualGridTask.TaskType.OPEN, this.taskListener, null, this, null, null);
        FutureTask<TestResultContainer> futureTask = new FutureTask<TestResultContainer>(visualGridTask);
        this.taskToFutureMapping.put(visualGridTask, futureTask);
        this.logger.verbose("locking visualGridTaskList");
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            this.visualGridTaskList.add(visualGridTask);
            this.logger.verbose("Open visualGridTask was added: " + visualGridTask.toString());
            this.logger.verbose("tasks in visualGridTaskList: " + this.visualGridTaskList.size());
        }
        this.logger.verbose("releasing visualGridTaskList");
        return visualGridTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureTask<TestResultContainer> close() {
        if (!this.visualGridTaskList.isEmpty()) {
            VisualGridTask lastVisualGridTask = this.visualGridTaskList.get(this.visualGridTaskList.size() - 1);
            VisualGridTask.TaskType type = lastVisualGridTask.getType();
            if (type == VisualGridTask.TaskType.CLOSE || type == VisualGridTask.TaskType.ABORT) {
                this.closeTask = lastVisualGridTask;
                return this.taskToFutureMapping.get(lastVisualGridTask);
            }
        } else if (this.closeTask != null) {
            return this.taskToFutureMapping.get(this.closeTask);
        }
        this.logger.verbose("adding close visualGridTask...");
        VisualGridTask visualGridTask = new VisualGridTask(new Configuration(this.configurationProvider.get()), null, this.eyes, VisualGridTask.TaskType.CLOSE, this.taskListener, null, this, null, null);
        FutureTask<TestResultContainer> futureTask = new FutureTask<TestResultContainer>(visualGridTask);
        this.closeTask = visualGridTask;
        this.isCloseTaskIssued.set(true);
        this.taskToFutureMapping.put(visualGridTask, futureTask);
        this.logger.verbose("locking visualGridTaskList");
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            this.visualGridTaskList.add(visualGridTask);
            this.logger.verbose("Close visualGridTask was added: " + visualGridTask.toString());
            this.logger.verbose("tasks in visualGridTaskList: " + this.visualGridTaskList.size());
        }
        this.logger.verbose("releasing visualGridTaskList");
        FutureTask<TestResultContainer> testResultContainerFutureTask = this.taskToFutureMapping.get(visualGridTask);
        return testResultContainerFutureTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualGridTask check(ICheckSettings checkSettings, List<VisualGridSelector[]> regionSelectors, String source) {
        this.logger.verbose("adding check visualGridTask...");
        VisualGridTask visualGridTask = new VisualGridTask(new Configuration(this.configurationProvider.get()), null, this.eyes, VisualGridTask.TaskType.CHECK, this.taskListener, checkSettings, this, regionSelectors, source);
        this.logger.verbose("locking visualGridTaskList");
        List<VisualGridTask> list = this.visualGridTaskList;
        synchronized (list) {
            this.visualGridTaskList.add(visualGridTask);
            this.logger.verbose("Check VisualGridTask was added: " + visualGridTask.toString());
            this.logger.verbose("tasks in visualGridTaskList: " + this.visualGridTaskList.size());
        }
        this.logger.verbose("releasing visualGridTaskList");
        this.taskToFutureMapping.get(visualGridTask);
        return visualGridTask;
    }

    public boolean isTestReadyToClose() {
        if (this.visualGridTaskList.size() != 1) {
            return false;
        }
        for (VisualGridTask visualGridTask : this.visualGridTaskList) {
            if (visualGridTask.getType() != VisualGridTask.TaskType.CLOSE && visualGridTask.getType() != VisualGridTask.TaskType.ABORT) continue;
            return true;
        }
        return false;
    }

    public boolean isTestClose() {
        return this.isTestClose.get();
    }

    public IEyesConnector getEyes() {
        return this.eyes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestInExceptionMode(Throwable e) {
        this.isTestInExceptionMode.set(true);
        this.error = e;
        if (this.closeTask != null) {
            this.logger.verbose("locking visualGridTaskList.");
            List<VisualGridTask> list = this.visualGridTaskList;
            synchronized (list) {
                this.removeAllCheckTasks();
                if (this.closeTask != null) {
                    if (!this.visualGridTaskList.contains(this.closeTask)) {
                        this.visualGridTaskList.add(this.closeTask);
                    }
                    this.closeTask.setExceptionAndAbort(e);
                }
            }
        }
        if (this.openTask != null) {
            this.openTask.setExceptionAndAbort(e);
        }
        this.logger.verbose("releasing visualGridTaskList.");
    }

    Logger getLogger() {
        return this.logger;
    }

    public boolean isOpenTaskIssued() {
        return this.openTask != null;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public static interface RunningTestListener {
        public void onTaskComplete(VisualGridTask var1, RunningTest var2);

        public void onRenderComplete();
    }
}

