/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import com.appland.appmap.AppmapPluginExtension;
import com.appland.appmap.AppmapTask;
import com.appland.appmap.CleanOutputDirectoryAction;
import com.appland.appmap.LoadAppmapAgentAction;
import com.appland.appmap.ValidateConfigAction;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.Provider;

public class AppmapPlugin
implements Plugin<Project> {
    public static final String DEFAULT_AGENT_VERSION = "latest.release";
    public static final String AGENT_CONFIGURATION_NAME = "appmapAgent";
    public static final String PLUGIN_EXTENSION_NAME = "appmap";
    private Project project;

    public void apply(Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        this.project = project;
        this.registerAgentConfiguration();
        Configuration config = project.getConfigurations().getAt(AGENT_CONFIGURATION_NAME);
        config.setVisible(false);
        config.setTransitive(true);
        config.setDescription("Appmap agent to generate app map data.");
        config.defaultDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)"com.appland:appmap-agent:latest.release")));
        AppmapPluginExtension extension = (AppmapPluginExtension)project.getExtensions().create(PLUGIN_EXTENSION_NAME, AppmapPluginExtension.class, new Object[]{project, config});
        this.addAppmapGradleTasks(extension);
    }

    private void registerAgentConfiguration() {
        Configuration agentConf = (Configuration)this.project.getConfigurations().create(AGENT_CONFIGURATION_NAME);
        agentConf.setVisible(false);
        agentConf.setTransitive(true);
        agentConf.setDescription("Appmap agent to generate app map data.");
    }

    private void addAppmapGradleTasks(AppmapPluginExtension extension) {
        this.project.getPlugins().withType(JavaPlugin.class, javaPlugin -> this.addAppmapTasks(extension));
    }

    private void addAppmapTasks(AppmapPluginExtension extension) {
        this.project.getTasks().register(PLUGIN_EXTENSION_NAME, AppmapTask.class, prepareAgentTask -> {
            prepareAgentTask.doFirst(new ValidateConfigAction((Provider<File>)extension.getConfigFile().getAsFile()));
            prepareAgentTask.doLast(new CleanOutputDirectoryAction((FileSystemOperations)((ProjectInternal)this.project).getServices().get(FileSystemOperations.class), (Provider<File>)extension.getOutputDirectory().getAsFile()));
            prepareAgentTask.doLast(new LoadAppmapAgentAction(this.project, extension));
            prepareAgentTask.setGroup("build");
            prepareAgentTask.setDescription(String.format("Attaches Appmap Agent to the Test task", new Object[0]));
        });
        this.project.getTasks().register("validate-config", validateConfigTask -> {
            validateConfigTask.doFirst((Action)new ValidateConfigAction((Provider<File>)extension.getConfigFile().getAsFile()));
            validateConfigTask.setGroup("build");
            validateConfigTask.setDescription(String.format("Searches Appmap Agent config file and validates it", new Object[0]));
        });
    }
}

