/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap;

import com.appland.appmap.AppmapPluginExtension;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Internal;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.RelativePathUtil;

public class AgentCommandLineLoader
implements CommandLineArgumentProvider,
Named {
    private static final Logger LOGGER = Logging.getLogger(CommandLineArgumentProvider.class);
    private static final List<String> DEBUG_FLAGS = Arrays.asList("hooks", "locals", "http");
    private final AppmapPluginExtension appmap;

    public AgentCommandLineLoader(AppmapPluginExtension appmap) {
        this.appmap = appmap;
    }

    public Iterable<String> asArguments() {
        return this.getAsJvmArg();
    }

    @Internal
    public String getName() {
        return "appmapAgent";
    }

    @Internal
    public List<String> getAsJvmArg() {
        if (!this.appmap.isConfigFileValid()) {
            this.appmap.setSkip(true);
            throw new GradleException("Configuration file must exist and be readable: " + ((RegularFile)this.appmap.getConfigFile().get()).getAsFile().getPath());
        }
        if (this.appmap.shouldSkip()) {
            LOGGER.warn("Appmap task was executed but but is disable, skip property set to " + this.appmap.shouldSkip());
            return new ArrayList<String>();
        }
        String javaAgentArg = "-javaagent:" + RelativePathUtil.relativePath((File)this.appmap.project.getProjectDir(), (File)this.appmap.getAgentConf().getSingleFile());
        ArrayList<String> argumentLn = new ArrayList<String>();
        argumentLn.add(javaAgentArg);
        argumentLn.add("-Dappmap.config.file=" + ((RegularFile)this.appmap.getConfigFile().get()).toString());
        argumentLn.add("-Dappmap.output.directory=" + ((Directory)this.appmap.getOutputDirectory().get()).toString());
        argumentLn.add("-Dappmap.event.valueSize=" + this.appmap.getEventValueSize());
        argumentLn.addAll(this.buildDebugParams());
        LOGGER.lifecycle("Arguments line set to " + Joiner.on((String)",").join(argumentLn));
        return argumentLn;
    }

    private List<String> buildDebugParams() {
        ArrayList<String> debugArgs = new ArrayList<String>();
        if (this.appmap.getDebug() != null && !this.appmap.getDebug().isEmpty()) {
            ArrayList<String> debugTokens = new ArrayList<String>(Arrays.asList(this.appmap.getDebug().split("[,|\\s]")));
            for (String token : debugTokens) {
                if (!DEBUG_FLAGS.contains(token)) continue;
                debugArgs.add("-Dappmap.debug." + token);
            }
            debugArgs.add(0, "-Dappmap.debug");
            debugArgs.add(0, "-Dappmap.debug.file=" + StringEscapeUtils.escapeJava((String)String.format("%s", this.appmap.getDebugFile())));
        }
        return debugArgs;
    }
}

