/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.Guideline;
import androidx.media2.widget.VideoView;
import com.appier.ads.Appier;
import com.appier.ads.AppierError;
import com.appier.ads.R;
import com.appier.ads.VideoController;
import com.appier.ads.common.BrowserUtil;
import com.appier.ads.common.NavigationBarHelper;
import com.appier.ads.common.ObjectWrapperForBinder;
import com.appier.ads.common.RepeatingHandlerRunnable;
import com.appier.ads.network.EventTracker;
import com.appier.ads.video.PlayerEndCardWebView;
import com.appier.ads.video.PlayerOverlayLayout;
import com.appier.ads.video.TrackingEventType;
import com.appier.ads.video.VastAdConfiguration;
import com.appier.ads.video.VideoActivityArgs;
import java.util.List;

public class VideoInterstitialActivity
extends Activity {
    private ConstraintLayout containerLayout;
    private VastAdConfiguration vastAdConfiguration;
    private PlayerOverlayLayout overlayLayout;
    private EventListener eventListener;
    private EventTracker eventTracker;
    private VideoController videoController;
    private boolean isSkippedByUser = false;
    private boolean isEngagedViewTracked = false;
    private long skipPosition;
    private BrowserUtil browserUtil;
    VideoView videoView;
    private RepeatingHandlerRunnable countDownTimerRunnable;
    private static final long COUNTDOWN_REPEAT_INTERVAL_MS = 500L;
    private static final long MIN_ENGAGED_VIEW_MS = 30000L;
    @Nullable
    private PlayerEndCardWebView endCardWebView;

    public static Intent getIntent(Context context) {
        Intent intent = new Intent(context, VideoInterstitialActivity.class);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        NavigationBarHelper.hideNavigationBar(this);
        this.setContentView(R.layout.appier_sdk_activity_vastvideo);
        Intent intent = this.getIntent();
        Bundle bundle = intent.getBundleExtra("VIDEO_INTENT_EXTRA_BUNDLE");
        ObjectWrapperForBinder binder = (ObjectWrapperForBinder)bundle.getBinder("VIDEO_BUNDLE_BINDER");
        if (binder == null) {
            this.finish();
        }
        VideoActivityArgs activityArgs = (VideoActivityArgs)binder.getData();
        this.vastAdConfiguration = activityArgs.vastAdConfiguration;
        this.skipPosition = this.vastAdConfiguration.linearCreative.skipPosition;
        this.overlayLayout = activityArgs.overlayLayout;
        this.overlayLayout.setActivity(this);
        this.videoController = activityArgs.videoController;
        this.eventListener = activityArgs.eventListener;
        this.eventTracker = new EventTracker((Context)this);
        if (activityArgs.orientation == 2) {
            this.setRequestedOrientation(6);
        } else {
            this.setRequestedOrientation(7);
        }
        this.browserUtil = new BrowserUtil((Context)this);
        if (Appier.getBrowserAgent() == Appier.BrowserAgent.NATIVE) {
            this.browserUtil.disableInternalBrowser();
        } else {
            this.browserUtil.enableInternalBrowser();
        }
        this.videoView = (VideoView)this.findViewById(R.id.videoView);
        this.setupMembers();
        this.setUpVideoViewLayout();
        this.containerLayout = (ConstraintLayout)this.findViewById(R.id.appier_sdk_video_container);
        this.containerLayout.addView((View)this.overlayLayout, -1, -1);
        String backgroundColor = this.vastAdConfiguration.playerLayout.backgroundColor;
        this.containerLayout.setBackgroundColor(Color.parseColor((String)backgroundColor));
        Handler handler = new Handler();
        this.countDownTimerRunnable = new RepeatingHandlerRunnable(handler){

            @Override
            public void doWork() {
                VideoInterstitialActivity.this.updateProgress();
                VideoInterstitialActivity.this.updateCountDownTimer();
                VideoInterstitialActivity.this.trackEngagedView();
            }
        };
        VastAdConfiguration.CompanionAd endCardCompanionAd = this.vastAdConfiguration.endCardCompanionAd;
        if (endCardCompanionAd != null) {
            String htmlContent = endCardCompanionAd.htmlResource;
            this.endCardWebView = new PlayerEndCardWebView((Context)this, htmlContent);
            this.endCardWebView.setActivity(this);
            this.containerLayout.addView((View)this.endCardWebView, -1, -1);
            this.endCardWebView.setVisibility(8);
        }
    }

    protected void onResume() {
        super.onResume();
        this.playVideoAndStartTrackPosition();
    }

    protected void onPause() {
        this.stopVideoAndStopTrackPosition();
        super.onPause();
    }

    public void onBackPressed() {
    }

    protected void onDestroy() {
        super.onDestroy();
        this.browserUtil = null;
        this.videoController.onDestroy();
    }

    private void setupMembers() {
        this.videoController.setStateListener(new VideoController.OnStateListener(){

            @Override
            public void onPlaybackCompleted() {
                VideoInterstitialActivity.this.trackLinearEvent(TrackingEventType.COMPLETE);
                VideoInterstitialActivity.this.trackEngagedView();
                VideoInterstitialActivity.this.overlayLayout.updateProgressBar(1.0);
                VideoInterstitialActivity.this.countDownTimerRunnable.stop();
                VideoInterstitialActivity.this.countDownTimerRunnable.dispose();
                VideoInterstitialActivity.this.eventListener.onVideoComplete();
                VideoInterstitialActivity.this.overlayLayout.showCloseButton();
                VideoInterstitialActivity.this.showEndCard();
            }

            @Override
            public void onError() {
                VideoInterstitialActivity.this.overlayLayout.showErrorMessage("An error occurred while playing video.");
                VideoInterstitialActivity.this.eventTracker.trackUri(((VideoInterstitialActivity)VideoInterstitialActivity.this).vastAdConfiguration.errorUri);
                VideoInterstitialActivity.this.eventListener.onShowFail(AppierError.VIDEO_PLAYBACK_ERROR);
            }

            @Override
            public void onBufferingRecovered() {
                VideoInterstitialActivity.this.overlayLayout.hideErrorMessage();
            }

            @Override
            public void onBufferingError() {
                VideoInterstitialActivity.this.overlayLayout.showErrorMessage("An error occurred. Please check your internet connection.");
                VideoInterstitialActivity.this.eventTracker.trackUri(((VideoInterstitialActivity)VideoInterstitialActivity.this).vastAdConfiguration.errorUri);
                VideoInterstitialActivity.this.eventListener.onShowFail(AppierError.NETWORK_ERROR);
            }
        });
        this.videoController.setVideoView(this.videoView);
        this.overlayLayout.setIsSkippable(this.vastAdConfiguration.linearCreative.skippable);
        this.overlayLayout.setIsRewarded(this.vastAdConfiguration.reward.isRewarded);
    }

    private void setUpVideoViewLayout() {
        Guideline topGuide = (Guideline)this.findViewById(R.id.video_top_guide);
        Guideline bottomGuide = (Guideline)this.findViewById(R.id.video_bottom_guide);
        Guideline leftGuide = (Guideline)this.findViewById(R.id.video_left_guide);
        Guideline rightGuide = (Guideline)this.findViewById(R.id.video_right_guide);
        topGuide.setGuidelinePercent(this.vastAdConfiguration.playerLayout.top);
        bottomGuide.setGuidelinePercent(this.vastAdConfiguration.playerLayout.bottom);
        leftGuide.setGuidelinePercent(this.vastAdConfiguration.playerLayout.left);
        rightGuide.setGuidelinePercent(this.vastAdConfiguration.playerLayout.right);
    }

    private void playVideoAndStartTrackPosition() {
        if (this.videoController.getCurrentPosition() == 0L) {
            this.trackLinearEvent(TrackingEventType.START);
            this.trackLinearEvent(TrackingEventType.CREATIVE_VIEW);
            this.eventTracker.trackUri(this.vastAdConfiguration.impressionUri);
            this.eventListener.onShown();
        } else {
            this.trackLinearEvent(TrackingEventType.RESUME);
        }
        this.videoController.onResume();
        if (this.videoController.isComplete) {
            return;
        }
        this.countDownTimerRunnable.startRepeating(500L);
    }

    private void stopVideoAndStopTrackPosition() {
        this.countDownTimerRunnable.stop();
        if (!this.isSkippedByUser) {
            this.trackLinearEvent(TrackingEventType.PAUSE);
        }
        this.videoController.onPause();
    }

    private void updateCountDownTimer() {
        int secondsToSkip = Math.round((float)(this.skipPosition - this.videoController.getCurrentPosition()) / 1000.0f);
        this.overlayLayout.updateCountDownTimer(String.valueOf(secondsToSkip));
    }

    private void updateProgress() {
        this.trackLinearEvent(this.videoController.getCurrentPosition());
        double progress = (double)this.videoController.getCurrentPosition() / (double)this.videoController.getDuration();
        this.overlayLayout.updateProgressBar(progress);
    }

    private void trackEngagedView() {
        if (!this.isEngagedViewTracked && this.videoController.getCurrentPosition() >= 30000L) {
            this.isEngagedViewTracked = true;
            this.trackLinearEvent(TrackingEventType.ENGAGED_VIEW);
        }
    }

    private void showEndCard() {
        if (this.endCardWebView != null) {
            this.overlayLayout.setVisibility(8);
            this.videoView.setVisibility(8);
            this.endCardWebView.setVisibility(0);
            this.trackEndCardEvent(TrackingEventType.CREATIVE_VIEW);
        }
    }

    private void trackLinearEvent(long currentPosition) {
        List<String> uriArray = this.vastAdConfiguration.linearCreative.trackingEvents.popTrackingUrlFromPosition(currentPosition);
        if (uriArray != null) {
            Appier.log("[Appier SDK]", "TrackPosition: ", currentPosition);
            this.eventTracker.trackUri(uriArray);
        }
    }

    private void trackLinearEvent(TrackingEventType trackingEventType) {
        List<String> uriArray = this.vastAdConfiguration.linearCreative.trackingEvents.getTrackingUrlFromEvent(trackingEventType);
        if (uriArray != null) {
            Appier.log("[Appier SDK]", "TrackEventType: ", trackingEventType.toString());
            this.eventTracker.trackUri(uriArray);
        }
    }

    private void trackEndCardEvent(TrackingEventType trackingEventType) {
        if (this.vastAdConfiguration.endCardCompanionAd == null) {
            return;
        }
        List<String> uriArray = this.vastAdConfiguration.endCardCompanionAd.trackingEvents.getTrackingUrlFromEvent(trackingEventType);
        if (uriArray != null) {
            Appier.log("[Appier SDK]", "TrackEventType: ", trackingEventType.toString());
            this.eventTracker.trackUri(uriArray);
        }
    }

    public void onMuteButtonClicked(boolean mute) {
        if (mute) {
            this.videoController.setPlayerVolume(0.0f);
            this.trackLinearEvent(TrackingEventType.MUTE);
        } else {
            this.videoController.setPlayerVolume(1.0f);
            this.trackLinearEvent(TrackingEventType.UNMUTE);
        }
    }

    public void onCloseButtonClicked() {
        this.trackLinearEvent(TrackingEventType.CLOSE);
        this.isSkippedByUser = true;
        this.eventListener.onDismiss();
        this.finish();
    }

    public void onErrorMessageCloseButtonClicked() {
        this.isSkippedByUser = true;
        this.eventListener.onDismiss();
        this.finish();
    }

    private boolean openUrl(@Nullable String url) {
        try {
            return this.browserUtil.tryToOpenUrl(url);
        }
        catch (Exception e) {
            Appier.log("[Appier SDK]", "Fail to open url:", e.getMessage());
            return false;
        }
    }

    public void openEndCardLandingUrl() {
        if (this.vastAdConfiguration.endCardCompanionAd == null) {
            return;
        }
        if (this.openUrl(this.vastAdConfiguration.endCardCompanionAd.clickThroughUri)) {
            this.eventListener.onClick();
            this.eventTracker.trackUri(this.vastAdConfiguration.endCardCompanionAd.clickTrackingUri);
        } else {
            Appier.log("[Appier SDK]", "Fail to open end card landing url");
            this.eventListener.onClickFail(AppierError.UNKNOWN_ERROR);
        }
    }

    public void openLinearLandingUrl() {
        if (this.openUrl(this.vastAdConfiguration.linearCreative.clickThroughUri)) {
            this.eventListener.onClick();
            this.eventTracker.trackUri(this.vastAdConfiguration.linearCreative.clickTrackingUri);
        } else {
            Appier.log("[Appier SDK]", "Fail to open linear landing url");
            this.eventListener.onClickFail(AppierError.UNKNOWN_ERROR);
        }
    }

    public void openCustomUrl(String url) {
        if (!this.openUrl(url)) {
            Appier.log("[Appier SDK]", "Fail to open custom url");
        }
    }

    public void trackCustomUrl(String url) {
        this.eventTracker.trackUri(url);
    }

    public static interface EventListener {
        public void onShown();

        public void onShowFail(AppierError var1);

        public void onClick();

        public void onClickFail(AppierError var1);

        public void onVideoComplete();

        public void onDismiss();
    }
}

