/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.media.AudioAttributesCompat;
import androidx.media2.common.MediaItem;
import androidx.media2.common.SessionPlayer;
import androidx.media2.common.UriMediaItem;
import androidx.media2.player.MediaPlayer;
import androidx.media2.player.PlaybackParams;
import androidx.media2.widget.VideoView;

public class VideoController {
    private static final long LAST_FRAME_DECREASE_INTERVAL_MS = 500L;
    private final MediaPlayer mediaPlayer;
    private final Context context;
    private OnStateListener stateListener = null;
    boolean isComplete = false;

    public VideoController(Context context) {
        this.mediaPlayer = new MediaPlayer(context);
        this.context = context;
    }

    public void prepare(final @Nullable OnPreparedListener preparedListener) {
        PlaybackParams playbackParams = new PlaybackParams.Builder().setAudioFallbackMode(0).setSpeed(1.0f).build();
        this.mediaPlayer.setPlaybackParams(playbackParams);
        AudioAttributesCompat audioAttrs = new AudioAttributesCompat.Builder().setUsage(1).setContentType(3).build();
        this.mediaPlayer.setAudioAttributes(audioAttrs);
        this.mediaPlayer.setPlayerVolume(1.0f);
        if (preparedListener == null) {
            this.mediaPlayer.prepare();
        } else {
            this.mediaPlayer.prepare().addListener(new Runnable(){

                @Override
                public void run() {
                    preparedListener.onPrepared();
                }
            }, ContextCompat.getMainExecutor((Context)this.context));
        }
    }

    public void setStateListener(final OnStateListener stateListener) {
        this.stateListener = stateListener;
        this.mediaPlayer.registerPlayerCallback(ContextCompat.getMainExecutor((Context)this.context), new MediaPlayer.PlayerCallback(){

            public void onPlaybackCompleted(@NonNull SessionPlayer player) {
                super.onPlaybackCompleted(player);
                VideoController.this.isComplete = true;
                stateListener.onPlaybackCompleted();
            }

            public void onError(@NonNull MediaPlayer mp, @NonNull MediaItem item, int what, int extra) {
                super.onError(mp, item, what, extra);
                if (VideoController.this.isComplete || stateListener == null) {
                    return;
                }
                stateListener.onError();
            }

            public void onBufferingStateChanged(@NonNull SessionPlayer player, @Nullable MediaItem item, int buffState) {
                super.onBufferingStateChanged(player, item, buffState);
                if (VideoController.this.isComplete || stateListener == null) {
                    return;
                }
                if (buffState == 0) {
                    stateListener.onBufferingError();
                } else {
                    stateListener.onBufferingRecovered();
                    VideoController.this.mediaPlayer.play();
                }
            }
        });
    }

    public void onResume() {
        if (this.isComplete) {
            this.mediaPlayer.seekTo(this.mediaPlayer.getDuration() - 500L, 3);
        } else if (this.mediaPlayer.getBufferingState() == 0 && this.stateListener != null) {
            this.stateListener.onBufferingError();
        } else {
            this.mediaPlayer.play();
        }
    }

    public void onPause() {
        this.mediaPlayer.pause();
    }

    public void onDestroy() {
        this.mediaPlayer.close();
    }

    public void setVideoView(VideoView videoView) {
        videoView.setPlayer((SessionPlayer)this.mediaPlayer);
    }

    public void setVideoUrl(String Url) {
        Uri uri = Uri.parse((String)Url);
        UriMediaItem mediaItem = new UriMediaItem.Builder(uri).build();
        this.mediaPlayer.setMediaItem((MediaItem)mediaItem);
    }

    public void setPlayerVolume(float vol) {
        this.mediaPlayer.setPlayerVolume(vol);
    }

    public long getCurrentPosition() {
        return this.mediaPlayer.getCurrentPosition();
    }

    public long getDuration() {
        return this.mediaPlayer.getDuration();
    }

    static interface OnStateListener {
        public void onPlaybackCompleted();

        public void onBufferingRecovered();

        public void onBufferingError();

        public void onError();
    }

    static interface OnPreparedListener {
        public void onPrepared();
    }
}

