/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.video;

import androidx.annotation.NonNull;
import org.json.JSONObject;

public class PlayerLayout {
    public final float top;
    public final float bottom;
    public final float left;
    public final float right;
    @NonNull
    public final String backgroundColor;
    @NonNull
    public final String progressBarColor;

    public PlayerLayout(JSONObject layoutObj) {
        float top = (float)layoutObj.optDouble("top", 0.0);
        float bottom = (float)layoutObj.optDouble("bottom", 1.0);
        float left = (float)layoutObj.optDouble("left", 0.0);
        float right = (float)layoutObj.optDouble("right", 1.0);
        this.backgroundColor = layoutObj.optString("bgColor", "#000000");
        this.progressBarColor = layoutObj.optString("progressBarColor", "#75C5FF");
        if (this.layoutValueIsIrrational()) {
            top = 0.0f;
            bottom = 1.0f;
            left = 0.0f;
            right = 1.0f;
        }
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
    }

    private boolean layoutValueIsIrrational() {
        if (this.top < 0.0f || this.top > 1.0f) {
            return true;
        }
        if (this.bottom < 0.0f || this.bottom > 1.0f) {
            return true;
        }
        if (this.left < 0.0f || this.left > 1.0f) {
            return true;
        }
        if (this.right < 0.0f || this.right > 1.0f) {
            return true;
        }
        if (this.top >= this.left) {
            return true;
        }
        return this.left >= this.right;
    }
}

