/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.appier.ads.Appier;

public abstract class RepeatingHandlerRunnable
implements Runnable {
    @NonNull
    protected final Handler handler;
    private boolean isRunning;
    protected long updateIntervalMillis;

    public RepeatingHandlerRunnable(@NonNull Handler handler) {
        this.handler = handler;
    }

    @Override
    public void run() {
        if (!this.isRunning) {
            return;
        }
        this.doWork();
        this.handler.postDelayed((Runnable)this, this.updateIntervalMillis);
    }

    public abstract void doWork();

    public void startRepeating(long intervalMillis) {
        if (this.isRunning) {
            return;
        }
        if (intervalMillis <= 0L) {
            Appier.log("intervalMillis must be greater than 0. ", "Saw: %d" + intervalMillis);
            return;
        }
        this.updateIntervalMillis = intervalMillis;
        this.isRunning = true;
        this.handler.removeCallbacks((Runnable)this);
        this.handler.post((Runnable)this);
    }

    public void stop() {
        this.isRunning = false;
    }

    public void dispose() {
        this.handler.removeCallbacks((Runnable)this);
    }
}

