/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.content.Context;
import android.graphics.Point;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.appier.ads.Appier;
import com.appier.ads.common.ConsentStatus;
import com.appier.ads.common.Identifier;
import com.appier.ads.network.Network;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.Date;
import java.util.Locale;

public class AppierUrlGenerator {
    public Uri.Builder mUriBuilder;
    private static final String KEY_CACHE_BUSTER = "cb";
    private static final String KEY_BUNDLE = "bundle";
    private static final String KEY_IDFA = "ia";
    private static final String KEY_IDFA_TYPE = "type";
    private static final String KEY_LIMIT_AD_TRACKING = "lat";
    private static final String KEY_LOCALE = "locale";
    private static final String KEY_SDK_VERSION = "sdk_version";
    private static final String KEY_TEST_MODE = "test_mode";
    private static final String KEY_CONNECTION_TYPE = "conntype";
    private static final String KEY_COUNTRY = "country";
    private static final String KEY_OPERATOR_ID = "operator";
    private static final String KEY_OPERATOR_NAME = "operator_name";
    private static final String KEY_GDPR_APPLIES = "gdpr_applies";
    private static final String KEY_FORCE_GDPR_APPLIES = "force_gdpr_applies";
    private static final String KEY_CONSENT_STATUS = "current_consent_status";
    private static final String KEY_COPPA_STATUS = "coppa_applies";
    private static final String KEY_SCREEN_WIDTH = "sw";
    private static final String KEY_SCREEN_HEIGHT = "sh";
    protected static final String KEY_SCREEN_ORIENTATION = "so";

    public AppierUrlGenerator(Context context, String host, String path) {
        this.mUriBuilder = Uri.parse((String)(host + path)).buildUpon();
        Identifier identifier = Appier.getIdentifier(context);
        AdvertisingIdClient.Info adInfo = identifier.getCachedAdInfo();
        boolean isLATEnabled = adInfo == null || adInfo.isLimitAdTrackingEnabled();
        this.mUriBuilder.appendQueryParameter(KEY_CACHE_BUSTER, Long.toString(new Date().getTime()));
        this.mUriBuilder.appendQueryParameter(KEY_SDK_VERSION, "2.0.0-beta.4");
        this.mUriBuilder.appendQueryParameter(KEY_LOCALE, Locale.getDefault().toString());
        this.mUriBuilder.appendQueryParameter(KEY_IDFA_TYPE, "adid");
        this.mUriBuilder.appendQueryParameter(KEY_BUNDLE, context.getPackageName());
        this.mUriBuilder.appendQueryParameter(KEY_LIMIT_AD_TRACKING, isLATEnabled ? "1" : "0");
        this.setScreenData(context);
        this.mUriBuilder.appendQueryParameter(KEY_CONNECTION_TYPE, Network.getType(context).toString());
        this.mUriBuilder.appendQueryParameter(KEY_COUNTRY, identifier.getTelCountry());
        this.mUriBuilder.appendQueryParameter(KEY_OPERATOR_ID, identifier.getTelNetworkOperator());
        this.mUriBuilder.appendQueryParameter(KEY_OPERATOR_NAME, identifier.getTelNetworkOperatorName());
        this.mUriBuilder.appendQueryParameter(KEY_GDPR_APPLIES, Appier.getGDPRApplies() ? "1" : "0");
        this.mUriBuilder.appendQueryParameter(KEY_FORCE_GDPR_APPLIES, Appier.getForceGDPRApplies() ? "1" : "0");
        this.mUriBuilder.appendQueryParameter(KEY_CONSENT_STATUS, Appier.getConsentStatus().getValue());
        this.mUriBuilder.appendQueryParameter(KEY_COPPA_STATUS, Appier.getCoppaApplies() ? "1" : "0");
        this.setPersonalData(adInfo, isLATEnabled);
        if (Appier.getTestMode() != Appier.TestMode.FALSE) {
            this.mUriBuilder.appendQueryParameter(KEY_TEST_MODE, Integer.toString(Appier.getTestMode().getValue()));
        }
    }

    private void setScreenData(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager != null) {
            Point size = new Point();
            windowManager.getDefaultDisplay().getRealSize(size);
            this.mUriBuilder.appendQueryParameter(KEY_SCREEN_WIDTH, Integer.toString(size.x));
            this.mUriBuilder.appendQueryParameter(KEY_SCREEN_HEIGHT, Integer.toString(size.y));
        } else {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            this.mUriBuilder.appendQueryParameter(KEY_SCREEN_WIDTH, Integer.toString(displayMetrics.widthPixels));
            this.mUriBuilder.appendQueryParameter(KEY_SCREEN_HEIGHT, Integer.toString(displayMetrics.heightPixels));
        }
    }

    private void setPersonalData(AdvertisingIdClient.Info adInfo, boolean isLATEnabled) {
        boolean canCollectPersonalData = Appier.getConsentStatus() == ConsentStatus.UNKNOWN ? !isLATEnabled : Appier.getGDPRApplies();
        if (canCollectPersonalData && adInfo != null && adInfo.getId() != null) {
            this.mUriBuilder.appendQueryParameter(KEY_IDFA, adInfo.getId());
        } else {
            this.mUriBuilder.appendQueryParameter(KEY_IDFA, "");
        }
    }

    public String generateUrlString() {
        return this.mUriBuilder.build().toString();
    }
}

