/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.appier.ads.Appier;
import com.appier.ads.AppierBaseAd;
import com.appier.ads.AppierError;
import com.appier.ads.AppierPredictCache;
import com.appier.ads.VideoController;
import com.appier.ads.VideoInterstitialActivity;
import com.appier.ads.common.AdUnitIdentifier;
import com.appier.ads.common.AdUrlGenerator;
import com.appier.ads.common.ObjectWrapperForBinder;
import com.appier.ads.video.PlayerOverlay;
import com.appier.ads.video.PlayerOverlayLayout;
import com.appier.ads.video.VastAdConfiguration;
import com.appier.ads.video.VideoActivityArgs;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoAd
extends AppierBaseAd
implements AppierBaseAd.BaseAdEventListener {
    private final EventListener eventListener;
    private VastAdConfiguration vastAdConfiguration;
    private PlayerOverlayLayout playerOverlayLayout;
    private VideoController videoController;
    private boolean isPlayerOverlayLayoutReady = false;
    private boolean isVideoReady = false;
    private int orientation = 0;

    public VideoAd(Context context, @NonNull AdUnitIdentifier adUnitId, EventListener eventListener) {
        super(context, adUnitId);
        this.setBaseAdEventListener(this);
        this.eventListener = eventListener;
    }

    private JSONObject getAd() throws JSONException {
        return this.getAdJSON().getJSONArray("adUnits").getJSONObject(0).getJSONObject("ad");
    }

    private void loadVastAdConfiguration() throws JSONException {
        this.vastAdConfiguration = new VastAdConfiguration(this.getAd());
    }

    private VastAdConfiguration getVastAdConfiguration() {
        return this.vastAdConfiguration;
    }

    @Override
    public void loadAd() {
        if (this.orientation == 0) {
            this.orientation = this.getContext().getResources().getConfiguration().orientation;
        }
        super.loadAd();
    }

    public void showAd() {
        if (!this.isLoaded()) {
            Appier.log("[Appier SDK]", "You are trying to show video ad before it is ready");
            return;
        }
        Intent intent = VideoInterstitialActivity.getIntent(this.getContext());
        Bundle bundle = new Bundle();
        VideoActivityArgs args = new VideoActivityArgs(this.getVastAdConfiguration(), this.orientation, this.playerOverlayLayout, this.videoController, new VastVideoInterstitialActivityListener());
        bundle.putBinder("VIDEO_BUNDLE_BINDER", (IBinder)new ObjectWrapperForBinder(args));
        intent.putExtra("VIDEO_INTENT_EXTRA_BUNDLE", bundle);
        this.getContext().startActivity(intent);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public String getAdUri() {
        String predictId = AppierPredictCache.getInstance().getActivatedPredictId(this.getAdUnitId());
        AdUrlGenerator adUrlGenerator = new AdUrlGenerator(this.getContext(), this.getNetworkHost(), this.getAdPath()).withZoneId(this.getZoneId()).withOrientation(this.orientation).withPredictId(predictId);
        return adUrlGenerator.generateUrlString();
    }

    @Override
    public void onBaseAdLoaded(AppierBaseAd ad, boolean isNoBid) {
        Appier.log("[Appier SDK]", "AppierVastVideoAd.onBaseAdLoaded()", "isNoBid =", isNoBid);
        if (isNoBid) {
            this.eventListener.onAdNoBid(this);
            return;
        }
        try {
            this.loadVastAdConfiguration();
            this.setupVideoController();
            this.setupOverlayLayout();
        }
        catch (JSONException e) {
            this.eventListener.onAdLoadFail(AppierError.INVALID_JSON, this);
        }
        catch (Exception e) {
            this.eventListener.onAdLoadFail(AppierError.UNKNOWN_ERROR, this);
        }
    }

    @Override
    public void onBaseAdLoadFail(AppierError appierError) {
        Appier.log("[Appier SDK]", "AppierVastVideoAd.onBaseAdLoadFail():", appierError.toString());
        this.eventListener.onAdLoadFail(appierError, this);
    }

    private void setupVideoController() {
        this.videoController = new VideoController(this.getContext());
        this.videoController.setVideoUrl(this.vastAdConfiguration.linearCreative.mediaFile.uri);
        this.videoController.prepare(() -> {
            this.isVideoReady = true;
            this.contentReady();
        });
    }

    private void setupOverlayLayout() {
        this.vastAdConfiguration.playerOverlay.getOverlayContent(this.getContext(), new PlayerOverlay.CompletionHandler(){

            @Override
            public void onComplete(String htmlContent) {
                String progressBarColor = ((VideoAd)VideoAd.this).vastAdConfiguration.playerLayout.progressBarColor;
                VideoAd.this.playerOverlayLayout = new PlayerOverlayLayout(VideoAd.this.getContext(), htmlContent, progressBarColor);
                VideoAd.this.isPlayerOverlayLayoutReady = true;
                VideoAd.this.contentReady();
            }
        });
    }

    private void contentReady() {
        if (this.isPlayerOverlayLayoutReady && this.isVideoReady) {
            this.eventListener.onAdLoaded(this);
        }
    }

    public static interface EventListener {
        public void onAdLoaded(VideoAd var1);

        public void onAdNoBid(VideoAd var1);

        public void onAdLoadFail(AppierError var1, VideoAd var2);

        public void onViewClick(VideoAd var1);

        public void onViewClickFail(AppierError var1, VideoAd var2);

        public void onShown(VideoAd var1);

        public void onAdVideoComplete(VideoAd var1);

        public void onShowFail(AppierError var1, VideoAd var2);

        public void onDismiss(VideoAd var1);
    }

    private class VastVideoInterstitialActivityListener
    implements VideoInterstitialActivity.EventListener {
        private VastVideoInterstitialActivityListener() {
        }

        @Override
        public void onShown() {
            VideoAd.this.eventListener.onShown(VideoAd.this);
        }

        @Override
        public void onShowFail(AppierError appierError) {
            VideoAd.this.eventListener.onShowFail(appierError, VideoAd.this);
        }

        @Override
        public void onClick() {
            VideoAd.this.eventListener.onViewClick(VideoAd.this);
        }

        @Override
        public void onClickFail(AppierError appierError) {
            VideoAd.this.eventListener.onViewClickFail(appierError, VideoAd.this);
        }

        @Override
        public void onVideoComplete() {
            VideoAd.this.eventListener.onAdVideoComplete(VideoAd.this);
        }

        @Override
        public void onDismiss() {
            VideoAd.this.eventListener.onDismiss(VideoAd.this);
        }
    }
}

