/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import com.appier.ads.AppierBannerAd;
import com.appier.ads.AppierNativeAd;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class AppierAdPlacer {
    private static final int AD_TYPE_COUNT = 2;
    public static final int VIEW_TYPE_ORIGINAL_CONTENT = 0;
    public static final int VIEW_TYPE_AD_NATIVE = 1;
    public static final int VIEW_TYPE_AD_BANNER = 2;
    private int mOriginalAdapterItemCount;
    private Map<Integer, Object> mAdMap = new WeakHashMap<Integer, Object>();
    private List<Integer> mAdaptedPositions = new ArrayList<Integer>();

    public AppierAdPlacer(int initialCount) {
        for (int position = 0; position < initialCount; ++position) {
            this.mAdaptedPositions.add(position);
        }
        this.mOriginalAdapterItemCount = initialCount;
    }

    public void destroy() {
        for (Map.Entry<Integer, Object> entry : this.mAdMap.entrySet()) {
            Object ad = entry.getValue();
            if (ad instanceof AppierNativeAd) {
                ((AppierNativeAd)ad).destroy();
                continue;
            }
            if (!(ad instanceof AppierBannerAd)) continue;
            ((AppierBannerAd)ad).destroy();
        }
        this.mAdMap.clear();
        this.mAdaptedPositions.clear();
    }

    private int getPositionPlaceholder(int viewType) {
        return -viewType;
    }

    public int getItemViewType(int position) {
        int positionPlaceholder = this.getOriginalPosition(position);
        if (positionPlaceholder >= 0) {
            return 0;
        }
        return -positionPlaceholder;
    }

    public int getAdTypeCount() {
        return 2;
    }

    public int getOriginalPosition(int position) {
        return this.mAdaptedPositions.get(position);
    }

    public int getItemCount() {
        return this.mAdaptedPositions.size();
    }

    public Object getAdAtOriginalPosition(int originalPosition) {
        return this.mAdMap.get(originalPosition);
    }

    public boolean isAd(int position) {
        return this.isAdViewType(this.getItemViewType(position));
    }

    public boolean isAdViewType(int viewType) {
        return viewType != 0;
    }

    public boolean isNativeAd(int position) {
        return this.getItemViewType(position) == 1;
    }

    public boolean isBannerAd(int position) {
        return this.getItemViewType(position) == 2;
    }

    public Object getAd(int position) {
        int originalPosition = position;
        for (int i = 0; i < position; ++i) {
            if (!this.isAd(i)) continue;
            --originalPosition;
        }
        return this.getAdAtOriginalPosition(originalPosition);
    }

    public boolean isAdAtOriginalPosition(int originalPosition) {
        return this.mAdMap.get(originalPosition) != null;
    }

    public int insertAdAtOriginalPosition(int originalPosition, Object ad) {
        int iteratedOriginalPosition;
        if (this.isAdAtOriginalPosition(originalPosition)) {
            throw new UnsupportedOperationException("An ad is already inserted to this position");
        }
        if (originalPosition < 0 || this.mOriginalAdapterItemCount <= originalPosition) {
            throw new IndexOutOfBoundsException("The insert position is out of bound");
        }
        int insertViewType = 0;
        if (ad instanceof AppierNativeAd) {
            insertViewType = 1;
        } else if (ad instanceof AppierBannerAd) {
            insertViewType = 2;
        }
        if (insertViewType == 0) {
            throw new UnsupportedOperationException("The ad format is not supported");
        }
        int insertPosition = originalPosition;
        int count = this.getItemCount();
        for (int i = 0; i < count && (iteratedOriginalPosition = this.getOriginalPosition(i)) < originalPosition; ++i) {
            if (!this.isAdAtOriginalPosition(iteratedOriginalPosition)) continue;
            ++insertPosition;
        }
        this.mAdaptedPositions.add(insertPosition, this.getPositionPlaceholder(insertViewType));
        this.mAdMap.put(originalPosition, ad);
        return insertPosition;
    }
}

