/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.content.Context;
import com.appier.ads.Appier;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class FileUtil {
    private static final String LOG_TAG = "FileUtil";

    public static String readFileFromResource(Context context, int resId) {
        String ret = "";
        InputStream inputStream = context.getResources().openRawResource(resId);
        if (inputStream == null) {
            return ret;
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            String receiveString = bufferedReader.readLine();
            if (receiveString != null) {
                stringBuilder.append(receiveString);
            }
            while ((receiveString = bufferedReader.readLine()) != null) {
                stringBuilder.append("\n").append(receiveString);
            }
            inputStream.close();
            ret = stringBuilder.toString();
            Appier.log(LOG_TAG, "Read file: " + ret);
        }
        catch (FileNotFoundException e) {
            Appier.log(LOG_TAG, "File not found: " + e.toString());
        }
        catch (IOException e) {
            Appier.log(LOG_TAG, "File read failed: " + e.toString());
        }
        return ret;
    }

    public static String readFile(Context context, String fileName) {
        String ret = "";
        try {
            FileInputStream fileInputStream = context.openFileInput(fileName);
            if (fileInputStream == null) {
                return ret;
            }
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder stringBuilder = new StringBuilder();
            String receiveString = bufferedReader.readLine();
            if (receiveString != null) {
                stringBuilder.append(receiveString);
            }
            while ((receiveString = bufferedReader.readLine()) != null) {
                stringBuilder.append("\n").append(receiveString);
            }
            fileInputStream.close();
            ret = stringBuilder.toString();
            Appier.log(LOG_TAG, "Read file: " + ret);
        }
        catch (FileNotFoundException e) {
            Appier.log(LOG_TAG, "File not found: " + e.toString());
        }
        catch (IOException e) {
            Appier.log(LOG_TAG, "File read failed: " + e.toString());
        }
        return ret;
    }

    public static void writeFile(Context context, String fileName, String data) {
        try {
            FileOutputStream outputStream = context.openFileOutput(fileName, 0);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write(data);
            outputStreamWriter.close();
            Appier.log(LOG_TAG, "Write file: " + data);
        }
        catch (IOException e) {
            Appier.log(LOG_TAG, "File write failed: " + e.toString());
        }
    }
}

