/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.video;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.appier.ads.R;
import com.appier.ads.VideoInterstitialActivity;
import com.appier.ads.common.BaseWebView;
import com.appier.ads.video.PlayerOverlayJsInterface;

@SuppressLint(value={"ViewConstructor"})
public class PlayerOverlayLayout
extends LinearLayout {
    private BaseWebView webView;
    private final ProgressBar progressBar;
    private final PlayerOverlayJsInterface jsInterface;
    private final String htmlContent;
    private static final int PROGRESS_BAR_MAX = 10000;
    private static final long PROGRESS_BAR_UPDATE_INTERVAL_MS = 500L;

    public PlayerOverlayLayout(Context context, String htmlContent) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.appier_sdk_layout_playeroverlay, (ViewGroup)this);
        this.jsInterface = new PlayerOverlayJsInterface();
        this.htmlContent = htmlContent;
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.progressBar.setMax(10000);
        this.initWebView();
    }

    public void setActivity(VideoInterstitialActivity activity) {
        this.jsInterface.setActivity(activity);
    }

    @SuppressLint(value={"AddJavascriptInterface"})
    private void initWebView() {
        this.webView = (BaseWebView)this.findViewById(R.id.webView);
        this.webView.addJavascriptInterface(this.jsInterface, "Android");
        this.webView.loadDataWithBaseURL(null, this.htmlContent, "text/html", "utf-8", null);
        this.webView.setBackgroundColor(0);
    }

    public void updateCountDownTimer(String second) {
        this.webView.loadUrl("javascript:setCountDownTimer(\"" + second + "\")");
    }

    public void updateProgressBar(double progress) {
        if (Build.VERSION.SDK_INT >= 24) {
            ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)this.progressBar, (String)"progress", (int[])new int[]{(int)(progress * 10000.0)});
            objectAnimator.setDuration(500L);
            objectAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            objectAnimator.start();
        }
    }
}

