/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.app.Activity;
import android.view.View;
import android.view.Window;
import androidx.annotation.NonNull;

public class NavigationBarHelper {
    public static void hideNavigationBar(@NonNull Activity activity) {
        Window window = activity.getWindow();
        if (window != null) {
            View view = window.getDecorView();
            NavigationBarHelper.hideNavigation(view);
            view.setOnSystemUiVisibilityChangeListener(NavigationBarHelper.createHideNavigationListener(view));
        }
    }

    private static View.OnSystemUiVisibilityChangeListener createHideNavigationListener(final @NonNull View view) {
        return new View.OnSystemUiVisibilityChangeListener(){

            public void onSystemUiVisibilityChange(int visibility) {
                if ((visibility & 2) == 0) {
                    NavigationBarHelper.hideNavigation(view);
                }
            }
        };
    }

    private static void hideNavigation(@NonNull View view) {
        view.setSystemUiVisibility(4866);
    }
}

