/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.appier.ads.common.Dimension;

public class BaseWebView
extends WebView {
    private static boolean sDeadlockCleared = false;
    private Context mContext;
    private Handler mHandler;

    public BaseWebView(Context context) {
        super(context.getApplicationContext());
        this.mContext = context;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.enablePlugins(true);
        this.restrictDeviceContentAccess();
        BaseWebView.setDisableJSChromeClient(this);
        if (!sDeadlockCleared) {
            this.clearWebViewDeadlock(this.getContext());
            sDeadlockCleared = true;
        }
        this.disableScrollingAndZoom();
        this.getSettings().setJavaScriptEnabled(true);
        this.setBackgroundColor(0);
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public void enablePlugins(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 18) {
            return;
        }
        if (enabled) {
            this.getSettings().setPluginState(WebSettings.PluginState.ON);
        } else {
            this.getSettings().setPluginState(WebSettings.PluginState.OFF);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void enableJavascriptCaching() {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setAppCachePath(this.getContext().getCacheDir().getAbsolutePath());
    }

    private void restrictDeviceContentAccess() {
        this.getSettings().setAllowFileAccess(false);
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setAllowFileAccessFromFileURLs(false);
        this.getSettings().setAllowUniversalAccessFromFileURLs(false);
    }

    private void clearWebViewDeadlock(@NonNull Context context) {
        if (Build.VERSION.SDK_INT == 19) {
            WebView webView = new WebView(context.getApplicationContext());
            webView.setBackgroundColor(0);
            webView.loadDataWithBaseURL(null, "", "text/html", "UTF-8", null);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.width = 1;
            params.height = 1;
            params.type = 2005;
            params.flags = 0x1000018;
            params.format = -2;
            params.gravity = 0x800033;
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.addView((View)webView, (ViewGroup.LayoutParams)params);
        }
    }

    private void disableScrollingAndZoom() {
        this.setHorizontalScrollBarEnabled(false);
        this.setHorizontalScrollbarOverlay(false);
        this.setVerticalScrollBarEnabled(false);
        this.setVerticalScrollbarOverlay(false);
        this.getSettings().setSupportZoom(false);
    }

    public static void setDisableJSChromeClient(@NonNull WebView webView) {
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(@NonNull WebView view, @NonNull String url, @NonNull String message, @NonNull JsResult result) {
                result.confirm();
                return true;
            }

            public boolean onJsConfirm(@NonNull WebView view, @NonNull String url, @NonNull String message, @NonNull JsResult result) {
                result.confirm();
                return true;
            }

            public boolean onJsPrompt(@NonNull WebView view, @NonNull String url, @NonNull String message, @NonNull String defaultValue, @NonNull JsPromptResult result) {
                result.confirm();
                return true;
            }

            public boolean onJsBeforeUnload(@NonNull WebView view, @NonNull String url, @NonNull String message, @NonNull JsResult result) {
                result.confirm();
                return true;
            }
        });
    }

    public void setCenterInParent() {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.addRule(13, -1);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setDpDimension(int dpWidth, int dpHeight) {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.width = Dimension.dipsToIntPixels(dpWidth, this.mContext);
        layoutParams.height = Dimension.dipsToIntPixels(dpHeight, this.mContext);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

