/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import androidx.annotation.NonNull;
import com.appier.ads.Appier;
import com.appier.ads.AppierBannerWebView;
import com.appier.ads.AppierBaseAd;
import com.appier.ads.AppierError;
import com.appier.ads.AppierPredictCache;
import com.appier.ads.common.AdUnitIdentifier;
import com.appier.ads.common.AdUrlGenerator;
import com.appier.ads.common.BaseWebView;
import com.appier.ads.common.HtmlWebViewClient;
import org.json.JSONException;
import org.json.JSONObject;

public class AppierBannerAd
extends AppierBaseAd
implements AppierBaseAd.BaseAdEventListener {
    private EventListener mEventListener;
    private AppierBannerWebView mAppierBannerWebView;
    private int mAdWidth;
    private int mAdHeight;
    private String mFailingUrl;

    public AppierBannerAd(Context context, @NonNull AdUnitIdentifier adUitId, EventListener eventListener) {
        super(context, adUitId);
        this.setBaseAdEventListener(this);
        this.mEventListener = eventListener;
        this.mAppierBannerWebView = new AppierBannerWebView(context, new AppierBannerViewListener());
        HtmlWebViewClient htmlWebViewClient = new HtmlWebViewClient(new HtmlWebViewListener(), this.mAppierBannerWebView);
        this.mAppierBannerWebView.setWebViewClient(htmlWebViewClient);
    }

    @Override
    public String getAdUri() {
        String predictId = AppierPredictCache.getInstance().getActivatedPredictId(this.getAdUnitId());
        AdUrlGenerator adUrlGenerator = new AdUrlGenerator(this.getContext(), this.getNetworkHost(), this.getAdPath()).withZoneId(this.getZoneId()).withAdUnitWidth(Integer.toString(this.mAdWidth)).withAdUnitHeight(Integer.toString(this.mAdHeight)).withPredictId(predictId);
        return adUrlGenerator.generateUrlString();
    }

    public void setAdDimension(int adWidth, int adHeight) {
        this.mAdWidth = adWidth;
        this.mAdHeight = adHeight;
        this.mAppierBannerWebView.setDpDimension(adWidth, adHeight);
    }

    public AppierBannerWebView getView() {
        return this.mAppierBannerWebView;
    }

    private JSONObject getAd() throws JSONException {
        return this.getAdJSON().getJSONArray("adUnits").getJSONObject(0).getJSONObject("ad");
    }

    public String getCreative() throws JSONException {
        return this.getAd().getString("content");
    }

    public String getFailingUrl() {
        return this.mFailingUrl;
    }

    @Override
    public void destroy() {
        this.setIsLoaded(false);
        if (this.mAppierBannerWebView != null) {
            this.mAppierBannerWebView.destroy();
            this.mAppierBannerWebView = null;
        }
        super.destroy();
    }

    @Override
    public void onBaseAdLoaded(AppierBaseAd ad, boolean isNoBid) {
        Appier.log("[Appier SDK]", "AppierBannerAd.onBaseAdLoaded():", "isNoBid =", isNoBid);
        if (isNoBid) {
            this.mEventListener.onAdNoBid(this);
        } else {
            try {
                this.mAppierBannerWebView.loadCreative(this.getCreative());
            }
            catch (JSONException e) {
                this.mEventListener.onAdLoadFail(AppierError.INVALID_JSON, this);
            }
            catch (Exception e) {
                this.mEventListener.onAdLoadFail(AppierError.UNKNOWN_ERROR, this);
            }
        }
    }

    @Override
    public void onBaseAdLoadFail(AppierError appierError) {
        Appier.log("[Appier SDK]", "AppierBannerAd.onBaseAdLoadFail():", appierError.toString());
        this.mEventListener.onAdLoadFail(appierError, this);
    }

    public static interface EventListener {
        public void onAdLoaded(AppierBannerAd var1);

        public void onAdNoBid(AppierBannerAd var1);

        public void onAdLoadFail(AppierError var1, AppierBannerAd var2);

        public void onViewClick(AppierBannerAd var1);
    }

    private class AppierBannerViewListener
    implements AppierBannerWebView.EventListener {
        private AppierBannerViewListener() {
        }

        @Override
        public void onClick() {
            AppierBannerAd.this.mEventListener.onViewClick(AppierBannerAd.this);
        }
    }

    private class HtmlWebViewListener
    implements HtmlWebViewClient.EventListener {
        private HtmlWebViewListener() {
        }

        @Override
        public void onLoaded(BaseWebView mHtmlWebView) {
            AppierBannerAd.this.mEventListener.onAdLoaded(AppierBannerAd.this);
        }

        @Override
        public void onFailed(AppierError appierError, String failingUrl) {
            AppierBannerAd.this.mFailingUrl = failingUrl;
            AppierBannerAd.this.mEventListener.onAdLoadFail(appierError, AppierBannerAd.this);
        }
    }
}

