/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.util.Pair;
import com.appier.ads.common.AdUnitIdentifier;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AppierPredictCache {
    private static AppierPredictCache instance;
    private static long CACHE_EXPIRED_MS;
    private static int PREDICT_RESULT_CAPACITY;
    private Map<String, AdUnitCache> mPredictCache = new HashMap<String, AdUnitCache>();

    public static AppierPredictCache getInstance() {
        if (instance == null) {
            instance = new AppierPredictCache();
        }
        return instance;
    }

    private AdUnitCache getAdUnitCache(AdUnitIdentifier adUnitId) {
        if (!this.mPredictCache.containsKey(adUnitId.build())) {
            AdUnitCache adUnitCache = new AdUnitCache();
            this.mPredictCache.put(adUnitId.build(), adUnitCache);
            return adUnitCache;
        }
        return this.mPredictCache.get(adUnitId.build());
    }

    boolean sizeExceedCapacity(AdUnitIdentifier adUnitId) {
        AdUnitCache adUnitCache = this.getAdUnitCache(adUnitId);
        return adUnitCache.sizeExceedCapacity();
    }

    void setPredictStatus(AdUnitIdentifier adUnitId, String predictId, List<String> items) {
        AdUnitCache adUnitCache = this.getAdUnitCache(adUnitId);
        adUnitCache.setPredictStatus(predictId, items);
    }

    public List<String> getPredictResult(AdUnitIdentifier adUnitId) {
        AdUnitCache adUnitCache = this.getAdUnitCache(adUnitId);
        return adUnitCache.getPredictResult();
    }

    public String getActivatedPredictId(AdUnitIdentifier adUnitId) {
        AdUnitCache adUnitCache = this.getAdUnitCache(adUnitId);
        return adUnitCache.getActivatedPredictId();
    }

    static {
        CACHE_EXPIRED_MS = 1080000L;
        PREDICT_RESULT_CAPACITY = 3;
    }

    private static class AdUnitCache {
        private Map<String, Pair<Date, List<String>>> mPredictCache = new HashMap<String, Pair<Date, List<String>>>();
        private String mActivatedPredictId = null;

        private AdUnitCache() {
        }

        String getActivatedPredictId() {
            return this.mActivatedPredictId;
        }

        private void removeExpiredPredictStatus() {
            Date currentDate = new Date();
            LinkedList<String> expiredList = new LinkedList<String>();
            for (Map.Entry<String, Pair<Date, List<String>>> entry : this.mPredictCache.entrySet()) {
                long diff = currentDate.getTime() - ((Date)entry.getValue().first).getTime();
                if (diff <= CACHE_EXPIRED_MS) continue;
                expiredList.add(entry.getKey());
            }
            for (String key : expiredList) {
                this.mPredictCache.remove(key);
            }
        }

        boolean sizeExceedCapacity() {
            this.removeExpiredPredictStatus();
            return this.mPredictCache.size() >= PREDICT_RESULT_CAPACITY;
        }

        void setPredictStatus(String predictId, List<String> keys) {
            this.removeExpiredPredictStatus();
            if (this.mPredictCache.containsKey(predictId) || !this.sizeExceedCapacity()) {
                this.mPredictCache.put(predictId, (Pair<Date, List<String>>)new Pair((Object)new Date(), keys));
            }
        }

        private Map.Entry<String, Pair<Date, List<String>>> getOldestPredictResult() {
            Map.Entry<String, Pair<Date, List<String>>> result = null;
            long oldestTime = new Date().getTime();
            for (Map.Entry<String, Pair<Date, List<String>>> entry : this.mPredictCache.entrySet()) {
                long diff = oldestTime - ((Date)entry.getValue().first).getTime();
                if (0L >= diff || diff >= CACHE_EXPIRED_MS) continue;
                oldestTime = ((Date)entry.getValue().first).getTime();
                result = entry;
            }
            return result;
        }

        List<String> getPredictResult() {
            Map.Entry<String, Pair<Date, List<String>>> result = this.getOldestPredictResult();
            if (result == null) {
                this.mActivatedPredictId = null;
                return null;
            }
            this.mActivatedPredictId = result.getKey();
            this.mPredictCache.remove(result.getKey());
            return (List)result.getValue().second;
        }
    }
}

