/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.appier.ads.Appier;
import com.appier.ads.R;
import com.appier.ads.common.BaseWebView;
import com.appier.ads.common.BrowserUtil;
import com.appier.ads.common.NavigationBarHelper;

public class AppierBrowserActivity
extends Activity {
    public static String EXTRA_URL = "URL";
    private BrowserUtil mBrowserUtil;
    private ImageButton imgBtnClose;
    private WebView mWebView;
    private TextView mTextViewUrl;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        NavigationBarHelper.hideNavigationBar(this);
        this.setContentView(R.layout.appier_sdk_activity_browser);
        this.mBrowserUtil = new BrowserUtil((Context)this);
        this.initializeButtons();
        this.initializeWebView();
        this.loadUrl();
    }

    public void finish() {
        ViewGroup decorView = (ViewGroup)this.getWindow().getDecorView();
        decorView.removeAllViews();
        super.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mWebView.destroy();
        this.mWebView = null;
    }

    private void initializeButtons() {
        this.imgBtnClose = (ImageButton)this.findViewById(R.id.img_btn_close);
        this.imgBtnClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppierBrowserActivity.this.finish();
            }
        });
        this.mTextViewUrl = (TextView)this.findViewById(R.id.text_view_url);
    }

    private void initializeWebView() {
        this.mWebView = new BaseWebView((Context)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        RelativeLayout layout2 = (RelativeLayout)this.findViewById(R.id.browser);
        layout2.addView((View)this.mWebView, 0);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                Appier.log("[Appier SDK]", "In-app browser loads url:", url);
                AppierBrowserActivity.this.mTextViewUrl.setText((CharSequence)url);
                if (BrowserUtil.isValidGooglePlayWebPage(url)) {
                    String appPackageName = Uri.parse((String)url).getQueryParameter("id");
                    boolean isOpened = AppierBrowserActivity.this.mBrowserUtil.tryToOpenUrlWithExternalApp("market://details?id=" + appPackageName);
                    if (isOpened) {
                        AppierBrowserActivity.this.finish();
                        return true;
                    }
                }
                if (BrowserUtil.isWebPage(url)) {
                    view.loadUrl(url);
                    return true;
                }
                AppierBrowserActivity.this.mBrowserUtil.disableInternalBrowser();
                boolean isOpened = AppierBrowserActivity.this.mBrowserUtil.tryToOpenUrl(url);
                if (isOpened) {
                    AppierBrowserActivity.this.finish();
                    return true;
                }
                return false;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
            }
        });
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(true);
    }

    private void loadUrl() {
        Intent intent = this.getIntent();
        String url = intent.getStringExtra(EXTRA_URL);
        this.mTextViewUrl.setText((CharSequence)url);
        Appier.log("[Appier SDK]", "In-app browser initial loads url:", url);
        if (BrowserUtil.isWebPage(url)) {
            this.mWebView.loadUrl(url);
            return;
        }
        this.mBrowserUtil.disableInternalBrowser();
        boolean isOpened = this.mBrowserUtil.tryToOpenUrl(url);
        if (!isOpened) {
            Appier.log("[Appier SDK]", "In-app browser fail to load url:", url);
        }
        this.finish();
    }
}

