/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.common;

import android.content.Context;
import com.appier.ads.Appier;
import com.appier.ads.common.ConsentStatus;
import com.appier.ads.common.Identifier;
import com.appier.ads.common.UrlGenerator;
import com.appier.ads.network.Network;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.Date;
import java.util.Locale;

public class AdUrlGenerator
extends UrlGenerator<AdUrlGenerator> {
    private static final String KEY_CACHE_BUSTER = "cb";
    private static final String KEY_AD_UNIT_ID = "zoneid";
    private static final String KEY_BUNDLE = "bundle";
    private static final String KEY_IDFA = "ia";
    private static final String KEY_IDFA_TYPE = "type";
    private static final String KEY_LIMIT_AD_TRACKING = "lat";
    private static final String KEY_LOCALE = "locale";
    private static final String KEY_SDK_VERSION = "sdk_version";
    private static final String KEY_TEST_MODE = "test_mode";
    private static final String KEY_CONNECTION_TYPE = "conntype";
    private static final String KEY_COUNTRY = "country";
    private static final String KEY_OPERATOR_ID = "operator";
    private static final String KEY_OPERATOR_NAME = "operator_name";
    private static final String KEY_AD_UNIT_WIDTH = "w";
    private static final String KEY_AD_UNIT_HEIGHT = "h";
    private static final String KEY_GDPR_APPLIES = "gdpr_applies";
    private static final String KEY_FORCE_GDPR_APPLIES = "force_gdpr_applies";
    private static final String KEY_CONSENT_STATUS = "current_consent_status";
    private static final String KEY_COPPA_STATUS = "coppa_applies";

    public AdUrlGenerator(Context context, String host, String path) {
        super(host, path);
        Identifier identifier = Appier.getIdentifier(context);
        AdvertisingIdClient.Info adInfo = identifier.getCachedAdInfo();
        boolean isLATEnabled = adInfo == null || adInfo.isLimitAdTrackingEnabled();
        this.addParam(KEY_CACHE_BUSTER, Long.toString(new Date().getTime()));
        this.addParam(KEY_SDK_VERSION, "1.0.0-rc5");
        this.addParam(KEY_LOCALE, Locale.getDefault().toString());
        this.addParam(KEY_IDFA_TYPE, "adid");
        this.addParam(KEY_BUNDLE, context.getPackageName());
        this.addParam(KEY_LIMIT_AD_TRACKING, isLATEnabled ? "1" : "0");
        this.addParam(KEY_CONNECTION_TYPE, Network.getType(context).toString());
        this.addParam(KEY_COUNTRY, identifier.getTelCountry());
        this.addParam(KEY_OPERATOR_ID, identifier.getTelNetworkOperator());
        this.addParam(KEY_OPERATOR_NAME, identifier.getTelNetworkOperatorName());
        this.addParam(KEY_GDPR_APPLIES, Appier.getGDPRApplies() ? "1" : "0");
        this.addParam(KEY_FORCE_GDPR_APPLIES, Appier.getForceGDPRApplies() ? "1" : "0");
        this.addParam(KEY_CONSENT_STATUS, Appier.getConsentStatus().getValue());
        this.addParam(KEY_COPPA_STATUS, Appier.getCoppaApplies() ? "1" : "0");
        this.setPersonalData(adInfo, isLATEnabled);
        if (Appier.getTestMode() != Appier.TestMode.FALSE) {
            this.addParam(KEY_TEST_MODE, Integer.toString(Appier.getTestMode().getValue()));
        }
    }

    private void setPersonalData(AdvertisingIdClient.Info adInfo, boolean isLATEnabled) {
        boolean canCollectPersonalData = Appier.getConsentStatus() == ConsentStatus.UNKNOWN ? !isLATEnabled : Appier.getGDPRApplies();
        if (canCollectPersonalData) {
            this.addParam(KEY_IDFA, adInfo.getId());
        } else {
            this.addParam(KEY_IDFA, "");
        }
    }

    public AdUrlGenerator withAdUnitId(String adUnitId) {
        this.addParam(KEY_AD_UNIT_ID, adUnitId);
        return this;
    }

    public AdUrlGenerator withAdUnitWidth(String adUnitWidth) {
        this.addParam(KEY_AD_UNIT_WIDTH, adUnitWidth);
        return this;
    }

    public AdUrlGenerator withAdUnitHeight(String adUnitHeight) {
        this.addParam(KEY_AD_UNIT_HEIGHT, adUnitHeight);
        return this;
    }
}

