/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.view.View;
import android.view.ViewGroup;
import com.appier.ads.Appier;
import com.appier.ads.AppierBaseAd;
import com.appier.ads.AppierError;
import com.appier.ads.AppierInterstitialActivity;
import com.appier.ads.AppierInterstitialWebView;
import com.appier.ads.common.AdUrlGenerator;
import com.appier.ads.common.BaseWebView;
import com.appier.ads.common.HtmlWebViewClient;
import com.appier.ads.common.ObjectWrapperForBinder;
import org.json.JSONException;
import org.json.JSONObject;

public class AppierInterstitialAd
extends AppierBaseAd
implements AppierBaseAd.BaseAdEventListener {
    private EventListener mEventListener;
    private AppierInterstitialWebView mAppierInterstitialWebView;
    private int mAdWidth;
    private int mAdHeight;
    private String mFailingUrl;

    public AppierInterstitialAd(Context context, EventListener eventListener) {
        super(context);
        this.setBaseAdEventListener(this);
        this.mEventListener = eventListener;
        this.mAppierInterstitialWebView = new AppierInterstitialWebView(context, new AppierInterstitialViewListener());
        HtmlWebViewClient htmlWebViewClient = new HtmlWebViewClient(new HtmlWebViewListener(), this.mAppierInterstitialWebView);
        this.mAppierInterstitialWebView.setWebViewClient(htmlWebViewClient);
    }

    @Override
    public void destroy() {
        this.setIsLoaded(false);
        if (this.mAppierInterstitialWebView != null) {
            ViewGroup parent = (ViewGroup)this.mAppierInterstitialWebView.getParent();
            if (parent != null) {
                parent.removeView((View)this.mAppierInterstitialWebView);
            }
            this.mAppierInterstitialWebView.destroy();
            this.mAppierInterstitialWebView = null;
        }
        super.destroy();
    }

    public void showAd() {
        if (!this.isLoaded()) {
            Appier.log("[Appier SDK]", "You are trying to show interstitial before it is ready");
            return;
        }
        try {
            this.mAppierInterstitialWebView.loadCreative(this.getCreative());
        }
        catch (JSONException e) {
            this.setIsLoaded(false);
            this.mEventListener.onShowFail(AppierError.INVALID_JSON);
            return;
        }
        catch (Exception e) {
            this.setIsLoaded(false);
            this.mEventListener.onShowFail(AppierError.UNKNOWN_ERROR);
        }
        Bundle bundle = new Bundle();
        bundle.putBinder("INTERSTITIAL_BUNDLE_BINDER", (IBinder)new ObjectWrapperForBinder((Object)this.mAppierInterstitialWebView));
        Intent intent = new Intent(this.getContext(), AppierInterstitialActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra("INTERSTITIAL_INTENT_EXTRA_BUNDLE", bundle);
        this.getContext().startActivity(intent);
    }

    @Override
    public String getAdUri() {
        AdUrlGenerator adUrlGenerator = new AdUrlGenerator(this.getContext(), this.getNetworkHost(), this.getAdPath()).withAdUnitId(this.getZoneId()).withAdUnitWidth(Integer.toString(this.mAdWidth)).withAdUnitHeight(Integer.toString(this.mAdHeight));
        return adUrlGenerator.generateUrlString();
    }

    public void setAdDimension(int adWidth, int adHeight) {
        this.mAdWidth = adWidth;
        this.mAdHeight = adHeight;
        this.mAppierInterstitialWebView.setDpDimension(adWidth, adHeight);
    }

    private JSONObject getAd() throws JSONException {
        return this.getAdJSON().getJSONArray("adUnits").getJSONObject(0).getJSONObject("ad");
    }

    public String getCreative() throws JSONException {
        return this.getAd().getString("content");
    }

    public String getFailingUrl() {
        return this.mFailingUrl;
    }

    @Override
    public void onBaseAdLoaded(AppierBaseAd ad, boolean isNoBid) {
        Appier.log("[Appier SDK]", "AppierInterstitialAd.onBaseAdLoaded()", "isNoBid =", isNoBid);
        if (isNoBid) {
            this.mEventListener.onAdNoBid();
        } else {
            this.mEventListener.onAdLoaded();
        }
    }

    @Override
    public void onBaseAdLoadFail(AppierError appierError) {
        Appier.log("[Appier SDK]", "AppierInterstitialAd.onBaseAdLoadFail():", appierError.toString());
        this.mEventListener.onAdLoadFail(appierError);
    }

    public static interface EventListener {
        public void onAdLoaded();

        public void onAdNoBid();

        public void onAdLoadFail(AppierError var1);

        public void onShown();

        public void onShowFail(AppierError var1);

        public void onDismiss();
    }

    private class AppierInterstitialViewListener
    implements AppierInterstitialWebView.EventListener {
        private AppierInterstitialViewListener() {
        }

        @Override
        public void onDismiss() {
            AppierInterstitialAd.this.mEventListener.onDismiss();
        }
    }

    private class HtmlWebViewListener
    implements HtmlWebViewClient.EventListener {
        private HtmlWebViewListener() {
        }

        @Override
        public void onLoaded(BaseWebView mHtmlWebView) {
            AppierInterstitialAd.this.mEventListener.onShown();
        }

        @Override
        public void onFailed(AppierError appierError, String failingUrl) {
            AppierInterstitialAd.this.mFailingUrl = failingUrl;
            AppierInterstitialAd.this.mEventListener.onShowFail(appierError);
        }
    }
}

