/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.net.Uri;
import com.appier.ads.AppierBannerView;
import com.appier.ads.AppierBaseAd;
import com.appier.ads.AppierError;
import com.appier.ads.common.Identifier;
import com.appier.ads.network.Network;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AppierBannerAd
extends AppierBaseAd
implements AppierBaseAd.BaseAdEventListener {
    private EventListener mEventListener;
    private AppierBannerView mAppierBannerView;
    private String mZoneId;
    private int mAdWidth;
    private int mAdHeight;

    public AppierBannerAd(Context context, EventListener eventListener) {
        super(context);
        this.setBaseAdEventListener(this);
        this.mEventListener = eventListener;
        this.mAppierBannerView = new AppierBannerView(context);
    }

    public void loadAd(String zoneId) {
        this.mZoneId = zoneId;
        super.loadAd();
    }

    @Override
    public String getAdUri() {
        String networkHost = this.getNetworkHost();
        String adPath = this.getAdPath();
        Identifier identifier = this.getIdentifier();
        AdvertisingIdClient.Info adInfo = this.getAdInfo();
        boolean isLATEnabled = adInfo == null || adInfo.isLimitAdTrackingEnabled();
        Uri adUri = Uri.parse((String)(networkHost + adPath)).buildUpon().appendQueryParameter("zoneid", this.mZoneId).appendQueryParameter("bundle", this.getContext().getPackageName()).appendQueryParameter("ia", isLATEnabled ? "" : adInfo.getId()).appendQueryParameter("type", "adid").appendQueryParameter("lat", isLATEnabled ? "1" : "0").appendQueryParameter("locale", Locale.getDefault().toString()).appendQueryParameter("sdk_version", "1.0.0-beta1").appendQueryParameter("conntype", Network.getType(this.getContext()).toString()).appendQueryParameter("country", identifier.getTelCountry()).appendQueryParameter("operator", identifier.getTelNetworkOperator()).appendQueryParameter("operator_name", identifier.getTelNetworkOperatorName()).appendQueryParameter("w", Integer.toString(this.mAdWidth)).appendQueryParameter("h", Integer.toString(this.mAdHeight)).build();
        return adUri.toString();
    }

    public void setAdDimension(int adWidth, int adHeight) {
        this.mAdWidth = adWidth;
        this.mAdHeight = adHeight;
    }

    public AppierBannerView getView() {
        return this.mAppierBannerView;
    }

    private JSONObject getAd() throws JSONException {
        return this.getAdJSON().getJSONArray("adUnits").getJSONObject(0).getJSONObject("ad");
    }

    public String getCreative() throws JSONException {
        return this.getAd().getString("content");
    }

    public void destroy() {
        if (this.mAppierBannerView != null) {
            this.mAppierBannerView.destroy();
            this.mAppierBannerView = null;
        }
    }

    @Override
    public void onBaseAdLoaded(AppierBaseAd ad, boolean isNoBid) {
        if (isNoBid) {
            this.mEventListener.onAdNoBid(this);
        } else {
            try {
                this.mAppierBannerView.loadCreative(this.getCreative());
                this.mEventListener.onAdLoaded(this);
            }
            catch (JSONException e) {
                this.mEventListener.onAdLoadFail(AppierError.INVALID_JSON, this);
            }
        }
    }

    @Override
    public void onBaseAdLoadFail(AppierError appierError) {
        this.mEventListener.onAdLoadFail(appierError, this);
    }

    public static interface EventListener {
        public void onAdLoaded(AppierBannerAd var1);

        public void onAdNoBid(AppierBannerAd var1);

        public void onAdLoadFail(AppierError var1, AppierBannerAd var2);
    }
}

