/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.net.Uri;
import com.appier.ads.NativeResponseCode;
import com.appier.ads.common.Identifier;
import com.appier.ads.network.Network;
import com.appier.ads.network.Request;
import com.appier.ads.network.Response;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AppierNativeAd {
    private static final String LOG_TAG = "AppierMediation";
    private String mNetworkHost = "https://ad3.apx.appier.net";
    private String mAdPath = "/v1/sdk/ad";
    private Context mContext;
    private EventListener mEventListener;
    private Identifier mIdentifier;
    private Request mReqAd;
    private Response mResAd;
    private Request mReqImpTrack;
    private Response mResImpTrack;
    private JSONObject mAdJSON;

    public AppierNativeAd(Context context, EventListener eventListener) {
        this.mContext = context;
        this.mEventListener = eventListener;
        this.mIdentifier = new Identifier(context);
    }

    public void loadAd(final String zoneId) {
        AdvertisingIdClient.Info adInfo = this.mIdentifier.getCachedAdInfo();
        if (adInfo != null) {
            this.loadAd(zoneId, adInfo);
        } else {
            this.mIdentifier.getAdInfo(new Identifier.EventListener(){

                @Override
                public void onAdInfoFetched(AdvertisingIdClient.Info adInfo) {
                    AppierNativeAd.this.loadAd(zoneId, adInfo);
                }
            });
        }
    }

    private void loadAd(String zoneId, AdvertisingIdClient.Info adInfo) {
        boolean isLATEnabled = adInfo == null || adInfo.isLimitAdTrackingEnabled();
        Uri adUri = Uri.parse((String)(this.mNetworkHost + this.mAdPath)).buildUpon().appendQueryParameter("zoneid", zoneId).appendQueryParameter("bundle", this.mContext.getPackageName()).appendQueryParameter("ia", isLATEnabled ? "" : adInfo.getId()).appendQueryParameter("type", "adid").appendQueryParameter("lat", isLATEnabled ? "1" : "0").appendQueryParameter("locale", Locale.getDefault().toString()).appendQueryParameter("sdk_version", "1.0.0-alpha").appendQueryParameter("conntype", Network.getType(this.mContext).toString()).appendQueryParameter("country", this.mIdentifier.getTelCountry()).appendQueryParameter("operator", this.mIdentifier.getTelNetworkOperator()).appendQueryParameter("operator_name", this.mIdentifier.getTelNetworkOperatorName()).build();
        this.mReqAd = Request.newRequest(adUri.toString());
        this.mReqAd.setCallback(new Request.Callback(){

            @Override
            public void onCompleted(Response response) {
                AppierNativeAd.this.mResAd = response;
                int adResCode = AppierNativeAd.this.mResAd.getResponseCode();
                if (adResCode == -1) {
                    AppierNativeAd.this.mEventListener.onAdLoadFail(NativeResponseCode.NETWORK_ERROR, AppierNativeAd.this);
                } else if (adResCode == 200) {
                    String ad = AppierNativeAd.this.mResAd.getResponseText();
                    try {
                        AppierNativeAd.this.mAdJSON = new JSONObject(ad);
                        AppierNativeAd.this.mEventListener.onAdLoaded(AppierNativeAd.this);
                    }
                    catch (JSONException e) {
                        AppierNativeAd.this.mEventListener.onAdLoadFail(NativeResponseCode.INVALID_JSON, AppierNativeAd.this);
                    }
                } else if (adResCode == 204) {
                    AppierNativeAd.this.mEventListener.onAdNoBid(AppierNativeAd.this);
                } else if (400 <= adResCode && adResCode <= 499) {
                    AppierNativeAd.this.mEventListener.onAdLoadFail(NativeResponseCode.BAD_REQUEST, AppierNativeAd.this);
                } else if (500 <= adResCode && adResCode <= 599) {
                    AppierNativeAd.this.mEventListener.onAdLoadFail(NativeResponseCode.INTERNAL_SERVER_ERROR, AppierNativeAd.this);
                } else {
                    AppierNativeAd.this.mEventListener.onAdLoadFail(NativeResponseCode.UNKNOWN_ERROR, AppierNativeAd.this);
                }
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Response res = AppierNativeAd.this.mReqAd.executeAndWait();
                Request.Callback requestCallback = AppierNativeAd.this.mReqAd.getCallback();
                requestCallback.onCompleted(res);
            }
        };
        new Thread(runnable).start();
    }

    public void makeImpressionTrackingRequest() throws JSONException {
        String impTracker = this.getImpressionTrackerUrl();
        this.mReqImpTrack = Request.newRequest(impTracker);
        this.mReqImpTrack.setCallback(new Request.Callback(){

            @Override
            public void onCompleted(Response response) {
                AppierNativeAd.this.mResImpTrack = response;
                if (AppierNativeAd.this.mResImpTrack.getResponseCode() == 200) {
                    AppierNativeAd.this.mEventListener.onImpressionRecorded(AppierNativeAd.this);
                } else {
                    AppierNativeAd.this.mEventListener.onImpressionRecordFail(NativeResponseCode.UNKNOWN_ERROR, AppierNativeAd.this);
                }
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Response res = AppierNativeAd.this.mReqImpTrack.executeAndWait();
                Request.Callback requestCallback = AppierNativeAd.this.mReqImpTrack.getCallback();
                requestCallback.onCompleted(res);
            }
        };
        new Thread(runnable).start();
    }

    public void setNetworkHost(String networkHost) {
        this.mNetworkHost = networkHost;
    }

    public void setAdPath(String adPath) {
        this.mAdPath = adPath;
    }

    public String getRawAd() {
        return this.mResAd.getResponseText();
    }

    public JSONObject getAdJSON() {
        return this.mAdJSON;
    }

    private JSONObject getAd() throws JSONException {
        return this.getAdJSON().getJSONArray("adUnits").getJSONObject(0).getJSONObject("ad");
    }

    public String getTitle() throws JSONException {
        return this.getAd().getJSONObject("native").getString("title");
    }

    public String getText() throws JSONException {
        return this.getAd().getJSONObject("native").getString("text");
    }

    public String getIconImageUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("iconImage").getString("url");
    }

    public String getMainImageUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("mainImage").getString("url");
    }

    public String getCallToActionText() throws JSONException {
        return this.getAd().getJSONObject("native").getString("ctaText");
    }

    public String getImpressionTrackerUrl() throws JSONException {
        return this.getAd().getJSONArray("impTracker").getString(0);
    }

    public String getClickDestinationUrl() throws JSONException {
        return this.getAd().getString("clk");
    }

    public String getPrivacyInformationIconImageUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("privacyInformationIcon").getString("url");
    }

    public String getPrivacyInformationIconClickThroughUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("privacyInformationLink").getString("url");
    }

    public List<String> getCacheableImageUrls() {
        ArrayList<String> imageUrls = new ArrayList<String>();
        try {
            imageUrls.add(this.getIconImageUrl());
            imageUrls.add(this.getMainImageUrl());
            imageUrls.add(this.getPrivacyInformationIconImageUrl());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            return imageUrls;
        }
    }

    public String getImpressionTrackingResponse() {
        return this.mResImpTrack.getResponseText();
    }

    public static interface EventListener {
        public void onAdLoaded(AppierNativeAd var1);

        public void onAdNoBid(AppierNativeAd var1);

        public void onAdLoadFail(NativeResponseCode var1, AppierNativeAd var2);

        public void onImpressionRecorded(AppierNativeAd var1);

        public void onImpressionRecordFail(NativeResponseCode var1, AppierNativeAd var2);
    }
}

