/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.presentation.figma;

import android.webkit.WebView;
import com.apphud.sdk.ApphudLog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/apphud/sdk/internal/presentation/figma/WebViewWrapper;", "", "webView", "Landroid/webkit/WebView;", "<init>", "(Landroid/webkit/WebView;)V", "currentUrl", "", "isLoading", "", "loadUrl", "", "url", "onPageStarted", "onPageFinished", "onLoadError", "reset", "sdk_release"})
final class WebViewWrapper {
    @NotNull
    private final WebView webView;
    @Nullable
    private String currentUrl;
    private boolean isLoading;

    public WebViewWrapper(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        this.webView = webView;
    }

    public final void loadUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ApphudLog.INSTANCE.log("[WebViewWrapper] Attempting to load URL: " + url);
        ApphudLog.INSTANCE.log("[WebViewWrapper] Current URL: " + this.currentUrl + ", isLoading: " + this.isLoading);
        if (Intrinsics.areEqual((Object)this.currentUrl, (Object)url) && !this.isLoading) {
            ApphudLog.INSTANCE.log("[WebViewWrapper] URL already loaded, skipping: " + url);
            return;
        }
        if (this.isLoading && Intrinsics.areEqual((Object)this.currentUrl, (Object)url)) {
            ApphudLog.INSTANCE.log("[WebViewWrapper] Same URL is already loading, skipping: " + url);
            return;
        }
        this.currentUrl = url;
        this.isLoading = true;
        ApphudLog.INSTANCE.log("[WebViewWrapper] Loading URL: " + url);
        this.webView.loadUrl(url);
    }

    public final void onPageStarted(@Nullable String url) {
        ApphudLog.INSTANCE.log("[WebViewWrapper] onPageStarted: " + url);
        this.isLoading = true;
        this.currentUrl = url;
    }

    public final void onPageFinished(@Nullable String url) {
        ApphudLog.INSTANCE.log("[WebViewWrapper] onPageFinished: " + url);
        this.isLoading = false;
        this.currentUrl = url;
    }

    public final void onLoadError() {
        ApphudLog.INSTANCE.log("[WebViewWrapper] onLoadError");
        this.isLoading = false;
    }

    public final void reset() {
        ApphudLog.INSTANCE.log("[WebViewWrapper] reset");
        this.currentUrl = null;
        this.isLoading = false;
    }
}

