/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.data.mapper;

import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.internal.data.serializer.RenderItemsSerializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J6\u0010\u0006\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b0\u0007j\u0002`\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b0\u0007J*\u0010\f\u001a\u0004\u0018\u00010\t2 \u0010\r\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u0018\u00010\u0007j\u0004\u0018\u0001`\nJ*\u0010\u000e\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u0018\u00010\u0007j\u0004\u0018\u0001`\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/apphud/sdk/internal/data/mapper/RenderResultMapper;", "", "serializer", "Lcom/apphud/sdk/internal/data/serializer/RenderItemsSerializer;", "<init>", "(Lcom/apphud/sdk/internal/data/serializer/RenderItemsSerializer;)V", "toDomain", "", "", "", "Lcom/apphud/sdk/domain/RenderResult;", "resultsDto", "toJson", "renderItems", "fromJson", "json", "sdk_release"})
public final class RenderResultMapper {
    @Nullable
    private final RenderItemsSerializer serializer;

    public RenderResultMapper(@Nullable RenderItemsSerializer serializer) {
        this.serializer = serializer;
    }

    public /* synthetic */ RenderResultMapper(RenderItemsSerializer renderItemsSerializer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            renderItemsSerializer = null;
        }
        this(renderItemsSerializer);
    }

    @NotNull
    public final List<Map<String, Object>> toDomain(@NotNull List<? extends Map<String, ? extends Object>> resultsDto) {
        Intrinsics.checkNotNullParameter(resultsDto, (String)"resultsDto");
        return resultsDto;
    }

    @Nullable
    public final String toJson(@Nullable List<? extends Map<String, ? extends Object>> renderItems) {
        ApphudLog.INSTANCE.log("[RenderResultMapper] Starting serialization to JSON");
        Collection collection = renderItems;
        if (collection == null || collection.isEmpty()) {
            ApphudLog.INSTANCE.log("[RenderResultMapper] Render items list is null or empty, returning null");
            return null;
        }
        try {
            RenderItemsSerializer renderItemsSerializer = this.serializer;
            String result = renderItemsSerializer != null ? renderItemsSerializer.serialize(renderItems) : null;
            ApphudLog.INSTANCE.log("[RenderResultMapper] Successfully serialized " + renderItems.size() + " render items");
        }
        catch (Exception e) {
            ApphudLog.INSTANCE.logE("[RenderResultMapper] Failed to serialize render items: " + e.getMessage());
            collection = null;
        }
        return collection;
    }

    @Nullable
    public final List<Map<String, Object>> fromJson(@Nullable String json) {
        ApphudLog.INSTANCE.log("[RenderResultMapper] Starting deserialization from JSON");
        CharSequence charSequence = json;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            ApphudLog.INSTANCE.log("[RenderResultMapper] JSON is null or blank, returning null");
            return null;
        }
        try {
            List<Map<String, Object>> result;
            RenderItemsSerializer renderItemsSerializer = this.serializer;
            List<Map<String, Object>> list = result = renderItemsSerializer != null ? renderItemsSerializer.deserialize(json) : null;
            ApphudLog.INSTANCE.log("[RenderResultMapper] Successfully deserialized " + (list != null ? list.size() : 0) + " render items");
        }
        catch (Exception e) {
            ApphudLog.INSTANCE.logE("[RenderResultMapper] Failed to deserialize render items: " + e.getMessage());
            charSequence = null;
        }
        return charSequence;
    }

    public RenderResultMapper() {
        this(null, 1, null);
    }
}

