/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal;

import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.domain.PaywallEvent;
import com.apphud.sdk.internal.PaywallEventBus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.SharedFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/apphud/sdk/internal/PaywallEventManager;", "", "<init>", "()V", "eventBus", "Lcom/apphud/sdk/internal/PaywallEventBus;", "events", "Lkotlinx/coroutines/flow/SharedFlow;", "Lcom/apphud/sdk/domain/PaywallEvent;", "getEvents", "()Lkotlinx/coroutines/flow/SharedFlow;", "activate", "", "deactivate", "emitEvent", "event", "isActive", "", "sdk_release"})
public final class PaywallEventManager {
    @NotNull
    private final PaywallEventBus eventBus = new PaywallEventBus();
    @NotNull
    private final SharedFlow<PaywallEvent> events = this.eventBus.getEvents();

    @NotNull
    public final SharedFlow<PaywallEvent> getEvents() {
        return this.events;
    }

    public final void activate() {
        ApphudLog.INSTANCE.logI("[PaywallEventManager] Activating event bus");
        this.eventBus.activate();
    }

    public final void deactivate() {
        ApphudLog.INSTANCE.logI("[PaywallEventManager] Deactivating event bus");
        this.eventBus.deactivate();
    }

    public final void emitEvent(@NotNull PaywallEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.eventBus.emit(event);
    }

    public final boolean isActive() {
        return this.eventBus.isActive();
    }
}

