/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.data.serializer;

import com.apphud.sdk.ApphudLog;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072 \u0010\b\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\n\u0018\u00010\tj\u0004\u0018\u0001`\u000bJ*\u0010\f\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\n\u0018\u00010\tj\u0004\u0018\u0001`\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/apphud/sdk/internal/data/serializer/RenderItemsSerializer;", "", "gson", "Lcom/google/gson/Gson;", "<init>", "(Lcom/google/gson/Gson;)V", "serialize", "", "renderItems", "", "", "Lcom/apphud/sdk/domain/RenderResult;", "deserialize", "json", "isValidJson", "", "sdk_release"})
public final class RenderItemsSerializer {
    @NotNull
    private final Gson gson;

    public RenderItemsSerializer(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.gson = gson;
    }

    @Nullable
    public final String serialize(@Nullable List<? extends Map<String, ? extends Object>> renderItems) {
        Collection collection;
        try {
            Collection collection2;
            collection = renderItems;
            if (collection == null || collection.isEmpty()) {
                ApphudLog.INSTANCE.log("[RenderItemsSerializer] Empty or null render items, returning null");
                collection2 = null;
            } else {
                String json = this.gson.toJson(renderItems);
                ApphudLog.INSTANCE.log("[RenderItemsSerializer] Serialized " + renderItems.size() + " render items");
                collection2 = collection;
            }
            collection = collection2;
        }
        catch (Exception e) {
            ApphudLog.INSTANCE.logE("[RenderItemsSerializer] Failed to serialize render items: " + e.getMessage());
            collection = null;
        }
        return collection;
    }

    @Nullable
    public final List<Map<String, Object>> deserialize(@Nullable String json) {
        CharSequence charSequence;
        try {
            List list;
            charSequence = json;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                ApphudLog.INSTANCE.log("[RenderItemsSerializer] Empty or null JSON, returning null");
                list = null;
            } else {
                List renderItems;
                Type listType2 = new TypeToken<List<? extends Map<String, ? extends Object>>>(){}.getType();
                List list2 = renderItems = (List)this.gson.fromJson(json, listType2);
                ApphudLog.INSTANCE.log("[RenderItemsSerializer] Deserialized " + (list2 != null ? list2.size() : 0) + " render items");
                list = renderItems;
            }
            charSequence = list;
        }
        catch (Exception e) {
            ApphudLog.INSTANCE.logE("[RenderItemsSerializer] Failed to deserialize render items: " + e.getMessage());
            charSequence = null;
        }
        return charSequence;
    }

    public final boolean isValidJson(@Nullable String json) {
        boolean bl;
        try {
            CharSequence charSequence = json;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return false;
            }
            Type listType2 = new TypeToken<List<? extends Map<String, ? extends Object>>>(){}.getType();
            this.gson.fromJson(json, listType2);
            bl = true;
        }
        catch (Exception e) {
            ApphudLog.INSTANCE.logE("[RenderItemsSerializer] Invalid JSON: " + e.getMessage());
            bl = false;
        }
        return bl;
    }
}

