/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.data;

import com.android.billingclient.api.ProductDetails;
import com.apphud.sdk.internal.data.ProductLoadingState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ%\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010\u0019\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/apphud/sdk/internal/data/ProductRepository;", "", "<init>", "()V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/apphud/sdk/internal/data/ProductLoadingState;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "transitionToLoading", "", "transitionToSuccess", "products", "", "Lcom/android/billingclient/api/ProductDetails;", "loadTimeMs", "", "(Ljava/util/List;Ljava/lang/Long;)V", "transitionToFailed", "responseCode", "", "markAsResponded", "rollbackRetryCounters", "reset", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nProductRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductRepository.kt\ncom/apphud/sdk/internal/data/ProductRepository\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n230#2,5:152\n230#2,3:157\n233#2,2:168\n230#2,5:170\n230#2,5:175\n230#2,5:180\n230#2,5:185\n1655#3,8:160\n*S KotlinDebug\n*F\n+ 1 ProductRepository.kt\ncom/apphud/sdk/internal/data/ProductRepository\n*L\n34#1:152,5\n66#1:157,3\n66#1:168,2\n83#1:170,5\n116#1:175,5\n131#1:180,5\n148#1:185,5\n68#1:160,8\n*E\n"})
public final class ProductRepository {
    @NotNull
    private final MutableStateFlow<ProductLoadingState> _state = StateFlowKt.MutableStateFlow((Object)ProductLoadingState.Idle.INSTANCE);
    @NotNull
    private final StateFlow<ProductLoadingState> state = FlowKt.asStateFlow(this._state);

    @NotNull
    public final StateFlow<ProductLoadingState> getState() {
        return this.state;
    }

    public final void transitionToLoading() {
        List<ProductDetails> previousProducts;
        int totalRetry;
        int currentRetry;
        ProductLoadingState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<ProductLoadingState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            ProductLoadingState current = (ProductLoadingState)prevValue$iv;
            boolean bl = false;
            previousProducts = current.getProducts();
            Pair pair = current instanceof ProductLoadingState.Failed ? TuplesKt.to((Object)(((ProductLoadingState.Failed)current).getCurrentRetryCount() + 1), (Object)(((ProductLoadingState.Failed)current).getTotalRetryCount() + 1)) : TuplesKt.to((Object)0, (Object)0);
            currentRetry = ((Number)pair.component1()).intValue();
            totalRetry = ((Number)pair.component2()).intValue();
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (ProductLoadingState)new ProductLoadingState.Loading(currentRetry, totalRetry, previousProducts))));
    }

    public final void transitionToSuccess(@NotNull List<ProductDetails> products, @Nullable Long loadTimeMs) {
        List mergedProducts;
        ProductLoadingState nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(products, (String)"products");
        MutableStateFlow<ProductLoadingState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            ProductLoadingState current = (ProductLoadingState)prevValue$iv;
            boolean bl = false;
            Iterable $this$distinctBy$iv = CollectionsKt.plus((Collection)products, (Iterable)current.getProducts());
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                ProductDetails it = (ProductDetails)e$iv;
                boolean bl2 = false;
                String key$iv = it.getProductId();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            mergedProducts = list$iv;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (ProductLoadingState)new ProductLoadingState.Success(mergedProducts, loadTimeMs, false))));
    }

    public static /* synthetic */ void transitionToSuccess$default(ProductRepository productRepository, List list, Long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = null;
        }
        productRepository.transitionToSuccess(list, l);
    }

    public final void transitionToFailed(int responseCode) {
        int totalRetry;
        int currentRetry;
        List<ProductDetails> cachedProducts;
        ProductLoadingState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<ProductLoadingState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            ProductLoadingState current = (ProductLoadingState)prevValue$iv;
            boolean bl = false;
            cachedProducts = current.getProducts();
            ProductLoadingState productLoadingState = current;
            Pair pair = productLoadingState instanceof ProductLoadingState.Loading ? TuplesKt.to((Object)((ProductLoadingState.Loading)current).getCurrentRetryCount(), (Object)((ProductLoadingState.Loading)current).getTotalRetryCount()) : (productLoadingState instanceof ProductLoadingState.Failed ? TuplesKt.to((Object)((ProductLoadingState.Failed)current).getCurrentRetryCount(), (Object)((ProductLoadingState.Failed)current).getTotalRetryCount()) : TuplesKt.to((Object)0, (Object)0));
            currentRetry = ((Number)pair.component1()).intValue();
            totalRetry = ((Number)pair.component2()).intValue();
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (ProductLoadingState)new ProductLoadingState.Failed(responseCode, cachedProducts, currentRetry, totalRetry, false))));
    }

    public final void markAsResponded() {
        ProductLoadingState productLoadingState;
        ProductLoadingState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<ProductLoadingState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            ProductLoadingState current = (ProductLoadingState)prevValue$iv;
            boolean bl = false;
            ProductLoadingState productLoadingState2 = current;
            if (productLoadingState2 instanceof ProductLoadingState.Success) {
                productLoadingState = ProductLoadingState.Success.copy$default((ProductLoadingState.Success)current, null, null, true, 3, null);
                continue;
            }
            if (productLoadingState2 instanceof ProductLoadingState.Failed) {
                productLoadingState = ProductLoadingState.Failed.copy$default((ProductLoadingState.Failed)current, 0, null, 0, 0, true, 15, null);
                continue;
            }
            productLoadingState = current;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = productLoadingState)));
    }

    public final void rollbackRetryCounters() {
        ProductLoadingState productLoadingState;
        ProductLoadingState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<ProductLoadingState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            ProductLoadingState current = (ProductLoadingState)prevValue$iv;
            boolean bl = false;
            if (current instanceof ProductLoadingState.Loading) {
                productLoadingState = ProductLoadingState.Loading.copy$default((ProductLoadingState.Loading)current, Math.max(0, ((ProductLoadingState.Loading)current).getCurrentRetryCount() - 1), Math.max(0, ((ProductLoadingState.Loading)current).getTotalRetryCount() - 1), null, 4, null);
                continue;
            }
            productLoadingState = current;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = productLoadingState)));
    }

    public final void reset() {
        ProductLoadingState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<ProductLoadingState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            ProductLoadingState it = (ProductLoadingState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (ProductLoadingState)ProductLoadingState.Idle.INSTANCE)));
    }
}

