/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.storage;

import android.content.Context;
import android.content.SharedPreferences;
import com.apphud.sdk.ApphudExtensionsKt;
import com.apphud.sdk.ApphudInternal;
import com.apphud.sdk.ApphudListener;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudUserProperty;
import com.apphud.sdk.domain.AdjustInfo;
import com.apphud.sdk.domain.ApphudGroup;
import com.apphud.sdk.domain.ApphudPaywall;
import com.apphud.sdk.domain.AppsflyerInfo;
import com.apphud.sdk.domain.Customer;
import com.apphud.sdk.domain.FacebookInfo;
import com.apphud.sdk.parser.GsonParser;
import com.apphud.sdk.parser.Parser;
import com.apphud.sdk.storage.Storage;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010l\u001a\u00020mJ\b\u0010n\u001a\u00020GH\u0002J\u000e\u0010o\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u0006\u0010p\u001a\u00020GJ\u0006\u0010q\u001a\u00020GJ\u000e\u0010r\u001a\u00020G2\u0006\u0010s\u001a\u00020bJ\u0006\u0010t\u001a\u00020GJ\u0018\u0010u\u001a\u00020m2\u0006\u00103\u001a\u0002022\b\u0010v\u001a\u0004\u0018\u00010wR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00198V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR(\u0010\u001f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000R(\u0010'\u001a\u0004\u0018\u00010&2\b\u0010\u0018\u001a\u0004\u0018\u00010&8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R(\u00103\u001a\u0004\u0018\u0001022\b\u0010\u0018\u001a\u0004\u0018\u0001028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u00107R(\u00108\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010!\"\u0004\b:\u0010#R(\u0010<\u001a\u0004\u0018\u00010;2\b\u0010\u0018\u001a\u0004\u0018\u00010;8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R(\u0010A\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010!\"\u0004\bC\u0010#R\u0016\u0010D\u001a\n F*\u0004\u0018\u00010E0EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010H\u001a\u00020G2\u0006\u0010\u0018\u001a\u00020G8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR$\u0010L\u001a\u00020-2\u0006\u0010\u0018\u001a\u00020-8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010/\"\u0004\bN\u00101R\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010S\u001a\n\u0012\u0004\u0012\u00020R\u0018\u00010Q2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020R\u0018\u00010Q8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u000e\u0010X\u001a\u00020YX\u0082.\u00a2\u0006\u0002\n\u0000R4\u0010Z\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010Q2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010Q8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b[\u0010U\"\u0004\b\\\u0010WR4\u0010^\u001a\n\u0012\u0004\u0012\u00020]\u0018\u00010Q2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020]\u0018\u00010Q8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b_\u0010U\"\u0004\b`\u0010WRd\u0010d\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020b\u0018\u00010aj\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020b\u0018\u0001`c2&\u0010\u0018\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020b\u0018\u00010aj\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020b\u0018\u0001`c8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\be\u0010f\"\u0004\bg\u0010hR(\u0010i\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bj\u0010!\"\u0004\bk\u0010#\u00a8\u0006x"}, d2={"Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "Lcom/apphud/sdk/storage/Storage;", "()V", "ADJUST_KEY", "", "ADVERTISING_DI_KEY", "APPSFLYER_KEY", "CUSTOMER_KEY", "DEVICE_ID_KEY", "FACEBOOK_KEY", "FIREBASE_KEY", "GROUP_KEY", "GROUP_TIMESTAMP_KEY", "LAST_REGISTRATION_KEY", "NAME", "NEED_RESTART_KEY", "PAYWALLS_KEY", "PAYWALLS_TIMESTAMP_KEY", "PROPERTIES_KEY", "SKU_KEY", "SKU_TIMESTAMP_KEY", "TEMP_PURCHASES", "TEMP_SUBSCRIPTIONS", "USER_ID_KEY", "value", "Lcom/apphud/sdk/domain/AdjustInfo;", "adjust", "getAdjust", "()Lcom/apphud/sdk/domain/AdjustInfo;", "setAdjust", "(Lcom/apphud/sdk/domain/AdjustInfo;)V", "advertisingId", "getAdvertisingId", "()Ljava/lang/String;", "setAdvertisingId", "(Ljava/lang/String;)V", "applicationContext", "Landroid/content/Context;", "Lcom/apphud/sdk/domain/AppsflyerInfo;", "appsflyer", "getAppsflyer", "()Lcom/apphud/sdk/domain/AppsflyerInfo;", "setAppsflyer", "(Lcom/apphud/sdk/domain/AppsflyerInfo;)V", "cacheTimeout", "", "getCacheTimeout", "()J", "setCacheTimeout", "(J)V", "Lcom/apphud/sdk/domain/Customer;", "customer", "getCustomer", "()Lcom/apphud/sdk/domain/Customer;", "setCustomer", "(Lcom/apphud/sdk/domain/Customer;)V", "deviceId", "getDeviceId", "setDeviceId", "Lcom/apphud/sdk/domain/FacebookInfo;", "facebook", "getFacebook", "()Lcom/apphud/sdk/domain/FacebookInfo;", "setFacebook", "(Lcom/apphud/sdk/domain/FacebookInfo;)V", "firebase", "getFirebase", "setFirebase", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "", "isNeedSync", "()Z", "setNeedSync", "(Z)V", "lastRegistration", "getLastRegistration", "setLastRegistration", "parser", "Lcom/apphud/sdk/parser/Parser;", "", "Lcom/apphud/sdk/domain/ApphudPaywall;", "paywalls", "getPaywalls", "()Ljava/util/List;", "setPaywalls", "(Ljava/util/List;)V", "preferences", "Landroid/content/SharedPreferences;", "productDetails", "getProductDetails", "setProductDetails", "Lcom/apphud/sdk/domain/ApphudGroup;", "productGroups", "getProductGroups", "setProductGroups", "Ljava/util/HashMap;", "Lcom/apphud/sdk/ApphudUserProperty;", "Lkotlin/collections/HashMap;", "properties", "getProperties", "()Ljava/util/HashMap;", "setProperties", "(Ljava/util/HashMap;)V", "userId", "getUserId", "setUserId", "clean", "", "customerWithPurchases", "getInstance", "needProcessFallback", "needRegistration", "needSendProperty", "property", "needUpdateProductGroups", "updateCustomer", "apphudListener", "Lcom/apphud/sdk/ApphudListener;", "sdk_release"})
public final class SharedPreferencesStorage
implements Storage {
    @NotNull
    public static final SharedPreferencesStorage INSTANCE = new SharedPreferencesStorage();
    private static long cacheTimeout = 90000L;
    private static Context applicationContext;
    private static SharedPreferences preferences;
    @NotNull
    private static final String NAME = "apphud_storage";
    @NotNull
    private static final String USER_ID_KEY = "userIdKey";
    @NotNull
    private static final String CUSTOMER_KEY = "customerKey";
    @NotNull
    private static final String DEVICE_ID_KEY = "deviceIdKey";
    @NotNull
    private static final String ADVERTISING_DI_KEY = "advertisingIdKey";
    @NotNull
    private static final String NEED_RESTART_KEY = "needRestartKey";
    @NotNull
    private static final String PROPERTIES_KEY = "propertiesKey";
    @NotNull
    private static final String FACEBOOK_KEY = "facebookKey";
    @NotNull
    private static final String FIREBASE_KEY = "firebaseKey";
    @NotNull
    private static final String APPSFLYER_KEY = "appsflyerKey";
    @NotNull
    private static final String ADJUST_KEY = "adjustKey";
    @NotNull
    private static final String PAYWALLS_KEY = "payWallsKey";
    @NotNull
    private static final String PAYWALLS_TIMESTAMP_KEY = "payWallsTimestampKey";
    @NotNull
    private static final String GROUP_KEY = "apphudGroupKey";
    @NotNull
    private static final String GROUP_TIMESTAMP_KEY = "apphudGroupTimestampKey";
    @NotNull
    private static final String SKU_KEY = "skuKey";
    @NotNull
    private static final String SKU_TIMESTAMP_KEY = "skuTimestampKey";
    @NotNull
    private static final String LAST_REGISTRATION_KEY = "lastRegistrationKey";
    @NotNull
    private static final String TEMP_SUBSCRIPTIONS = "temp_subscriptions";
    @NotNull
    private static final String TEMP_PURCHASES = "temp_purchases";
    private static final Gson gson;
    @NotNull
    private static final Parser parser;

    private SharedPreferencesStorage() {
    }

    public final long getCacheTimeout() {
        return cacheTimeout;
    }

    public final void setCacheTimeout(long l) {
        cacheTimeout = l;
    }

    @NotNull
    public final SharedPreferencesStorage getInstance(@NotNull Context applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        SharedPreferencesStorage.applicationContext = applicationContext;
        Context context = SharedPreferencesStorage.applicationContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
            context = null;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences(NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"applicationContext.getSh\u2026ME, Context.MODE_PRIVATE)");
        preferences = sharedPreferences;
        Context context2 = SharedPreferencesStorage.applicationContext;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
            context2 = null;
        }
        cacheTimeout = ApphudExtensionsKt.isDebuggable(context2) ? 30L : 90000L;
        return this;
    }

    @Override
    @Nullable
    public String getUserId() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getString(USER_ID_KEY, null);
    }

    @Override
    public void setUserId(@Nullable String value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(USER_ID_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public Customer getCustomer() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(CUSTOMER_KEY, null);
        Type type2 = new TypeToken<Customer>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (Customer)parser.fromJson(source, type2);
    }

    @Override
    public void setCustomer(@Nullable Customer value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(CUSTOMER_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public String getDeviceId() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getString(DEVICE_ID_KEY, null);
    }

    @Override
    public void setDeviceId(@Nullable String value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(DEVICE_ID_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public String getAdvertisingId() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getString(ADVERTISING_DI_KEY, null);
    }

    @Override
    public void setAdvertisingId(@Nullable String value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(ADVERTISING_DI_KEY, value);
        editor.apply();
    }

    @Override
    public boolean isNeedSync() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getBoolean(NEED_RESTART_KEY, false);
    }

    @Override
    public void setNeedSync(boolean value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(NEED_RESTART_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public FacebookInfo getFacebook() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(FACEBOOK_KEY, null);
        Type type2 = new TypeToken<FacebookInfo>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (FacebookInfo)parser.fromJson(source, type2);
    }

    @Override
    public void setFacebook(@Nullable FacebookInfo value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(FACEBOOK_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public String getFirebase() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getString(FIREBASE_KEY, null);
    }

    @Override
    public void setFirebase(@Nullable String value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(FIREBASE_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public AppsflyerInfo getAppsflyer() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(APPSFLYER_KEY, null);
        Type type2 = new TypeToken<AppsflyerInfo>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (AppsflyerInfo)parser.fromJson(source, type2);
    }

    @Override
    public void setAppsflyer(@Nullable AppsflyerInfo value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(APPSFLYER_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public AdjustInfo getAdjust() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(ADJUST_KEY, null);
        Type type2 = new TypeToken<AdjustInfo>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (AdjustInfo)parser.fromJson(source, type2);
    }

    @Override
    public void setAdjust(@Nullable AdjustInfo value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(ADJUST_KEY, source);
        editor.apply();
    }

    public final boolean needUpdateProductGroups() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        long timestamp = sharedPreferences.getLong(GROUP_TIMESTAMP_KEY, -1L) + cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        return currentTime >= timestamp;
    }

    @Override
    @Nullable
    public List<ApphudGroup> getProductGroups() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(GROUP_KEY, null);
        Type type2 = new TypeToken<List<? extends ApphudGroup>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (List)parser.fromJson(source, type2);
    }

    @Override
    public void setProductGroups(@Nullable List<ApphudGroup> value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(GROUP_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(GROUP_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public List<ApphudPaywall> getPaywalls() {
        List list;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        long timestamp = sharedPreferences.getLong(PAYWALLS_TIMESTAMP_KEY, -1L) + cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp || ApphudInternal.INSTANCE.getFallbackMode$sdk_release()) {
            SharedPreferences sharedPreferences2 = preferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
                sharedPreferences2 = null;
            }
            String source = sharedPreferences2.getString(PAYWALLS_KEY, null);
            Type type2 = new TypeToken<List<? extends ApphudPaywall>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
            list = (List)parser.fromJson(source, type2);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    public void setPaywalls(@Nullable List<ApphudPaywall> value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(PAYWALLS_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(PAYWALLS_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public List<String> getProductDetails() {
        List list;
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        long timestamp = sharedPreferences.getLong(SKU_TIMESTAMP_KEY, -1L) + cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp) {
            SharedPreferences sharedPreferences2 = preferences;
            if (sharedPreferences2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
                sharedPreferences2 = null;
            }
            String source = sharedPreferences2.getString(SKU_KEY, null);
            Type type2 = new TypeToken<List<? extends String>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
            list = (List)parser.fromJson(source, type2);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    public void setProductDetails(@Nullable List<String> value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(SKU_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(SKU_KEY, source);
        editor.apply();
    }

    @Override
    public long getLastRegistration() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        return sharedPreferences.getLong(LAST_REGISTRATION_KEY, 0L);
    }

    @Override
    public void setLastRegistration(long value) {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(LAST_REGISTRATION_KEY, value);
        editor.apply();
    }

    public final void updateCustomer(@NotNull Customer customer2, @Nullable ApphudListener apphudListener) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)customer2, (String)"customer");
        boolean userIdChanged = false;
        Customer customer3 = this.getCustomer();
        if (customer3 != null) {
            it = customer3;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Customer)it).getUser().getUserId(), (Object)customer2.getUser().getUserId())) {
                userIdChanged = true;
            }
        }
        this.setCustomer(customer2);
        this.setUserId(customer2.getUser().getUserId());
        if (userIdChanged) {
            ApphudListener apphudListener2 = apphudListener;
            if (apphudListener2 != null) {
                it = apphudListener2;
                boolean bl = false;
                apphudListener.apphudDidChangeUserID(customer2.getUser().getUserId());
            }
        }
    }

    public final void clean() {
        this.setLastRegistration(0L);
        this.setCustomer(null);
        this.setUserId(null);
        this.setDeviceId(null);
        this.setAdvertisingId(null);
        this.setNeedSync(false);
        this.setFacebook(null);
        this.setFirebase(null);
        this.setAppsflyer(null);
        this.setProductGroups(null);
        this.setPaywalls(null);
        this.setProductDetails(null);
        this.setProperties(null);
        this.setAdjust(null);
    }

    public final boolean needRegistration() {
        long timestamp = this.getLastRegistration() + cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (!this.customerWithPurchases()) {
            boolean result;
            boolean bl = result = currentTime > timestamp;
            if (result) {
                ApphudLog.logI$default(ApphudLog.INSTANCE, "User without purchases: perform registration", false, 2, null);
            } else {
                long minutes = (timestamp - currentTime) / 60000L;
                long seconds = (timestamp - currentTime - minutes * 60000L) / 1000L;
                ApphudLog.logI$default(ApphudLog.INSTANCE, "User without purchases: registration will available after " + minutes + "min. " + seconds + "sec.", false, 2, null);
            }
            return result;
        }
        ApphudLog.logI$default(ApphudLog.INSTANCE, "User with purchases: perform registration", false, 2, null);
        return true;
    }

    private final boolean customerWithPurchases() {
        boolean bl;
        Customer customer2 = this.getCustomer();
        if (customer2 == null) {
            bl = false;
        } else {
            boolean bl2;
            Customer it = customer2;
            boolean bl3 = false;
            bl = bl2 = !it.getPurchases().isEmpty() || !it.getSubscriptions().isEmpty();
        }
        return bl;
    }

    public final boolean needProcessFallback() {
        boolean bl;
        Customer customer2 = this.getCustomer();
        if (customer2 == null) {
            bl = true;
        } else {
            boolean bl2;
            Customer it = customer2;
            boolean bl3 = false;
            bl = bl2 = it.getPurchases().isEmpty() && it.getSubscriptions().isEmpty();
        }
        return bl;
    }

    @Override
    @Nullable
    public HashMap<String, ApphudUserProperty> getProperties() {
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        String source = sharedPreferences.getString(PROPERTIES_KEY, null);
        Type type2 = new TypeToken<HashMap<String, ApphudUserProperty>>(){}.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        return (HashMap)parser.fromJson(source, type2);
    }

    @Override
    public void setProperties(@Nullable HashMap<String, ApphudUserProperty> value) {
        String source = parser.toJson(value);
        SharedPreferences sharedPreferences = preferences;
        if (sharedPreferences == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preferences");
            sharedPreferences = null;
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(PROPERTIES_KEY, source);
        editor.apply();
    }

    public final boolean needSendProperty(@NotNull ApphudUserProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, ApphudUserProperty>());
        }
        HashMap<String, ApphudUserProperty> hashMap = this.getProperties();
        if (hashMap != null) {
            HashMap<String, ApphudUserProperty> it = hashMap;
            boolean bl = false;
            if (property.getValue() == null) {
                if (it.containsKey(property.getKey())) {
                    it.remove(property.getKey());
                    INSTANCE.setProperties(it);
                }
                return true;
            }
            if (it.containsKey(property.getKey())) {
                ApphudUserProperty apphudUserProperty = it.get(property.getKey());
                if (apphudUserProperty == null ? false : apphudUserProperty.getSetOnce()) {
                    String message = "Sending a property with key '" + property.getKey() + "' is skipped. The property was previously specified as not updatable";
                    ApphudLog.logI$default(ApphudLog.INSTANCE, message, false, 2, null);
                    return false;
                }
                if (property.getIncrement()) {
                    if (it.containsKey(property.getKey())) {
                        it.remove(property.getKey());
                        INSTANCE.setProperties(it);
                    }
                    return true;
                }
                ApphudUserProperty apphudUserProperty2 = it.get(property.getKey());
                if (Intrinsics.areEqual((Object)(apphudUserProperty2 == null ? null : apphudUserProperty2.getValue$sdk_release()), (Object)property.getValue$sdk_release()) && !property.getSetOnce()) {
                    String message = "Sending a property with key '" + property.getKey() + "' is skipped. Property value was not changed";
                    ApphudLog.logI$default(ApphudLog.INSTANCE, message, false, 2, null);
                    return false;
                }
            }
        }
        return true;
    }

    static {
        Gson gson = SharedPreferencesStorage.gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"gson");
        parser = new GsonParser(gson);
    }
}

