/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.storage;

import android.content.Context;
import android.content.SharedPreferences;
import com.apphud.sdk.ApphudExtensionsKt;
import com.apphud.sdk.ApphudListener;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudUserProperty;
import com.apphud.sdk.domain.AdjustInfo;
import com.apphud.sdk.domain.ApphudGroup;
import com.apphud.sdk.domain.ApphudPaywall;
import com.apphud.sdk.domain.AppsflyerInfo;
import com.apphud.sdk.domain.Customer;
import com.apphud.sdk.domain.FacebookInfo;
import com.apphud.sdk.parser.Parser;
import com.apphud.sdk.storage.Storage;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ^2\u00020\u0001:\u0001^B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010U\u001a\u00020VJ\u0006\u0010W\u001a\u000200J\u000e\u0010X\u001a\u0002002\u0006\u0010Y\u001a\u00020HJ\u0006\u0010Z\u001a\u000200J\u0018\u0010[\u001a\u00020V2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010\\\u001a\u0004\u0018\u00010]R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR(\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\u00148V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR(\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R(\u0010$\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\u0011\"\u0004\b&\u0010\u0013R(\u0010(\u001a\u0004\u0018\u00010'2\b\u0010\u0007\u001a\u0004\u0018\u00010'8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R(\u0010-\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0011\"\u0004\b/\u0010\u0013R$\u00101\u001a\u0002002\u0006\u0010\u0007\u001a\u0002008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00105\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u001b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\u001d\"\u0004\b7\u00108R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010;\u001a\n\u0012\u0004\u0012\u00020:\u0018\u0001092\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020:\u0018\u0001098V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0016\u0010@\u001a\n B*\u0004\u0018\u00010A0AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010D\u001a\n\u0012\u0004\u0012\u00020C\u0018\u0001092\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020C\u0018\u0001098V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010=\"\u0004\bF\u0010?Rd\u0010J\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020H\u0018\u00010Gj\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020H\u0018\u0001`I2&\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020H\u0018\u00010Gj\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020H\u0018\u0001`I8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR4\u0010O\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u0001092\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u0001098V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010=\"\u0004\bQ\u0010?R(\u0010R\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bS\u0010\u0011\"\u0004\bT\u0010\u0013\u00a8\u0006_"}, d2={"Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "Lcom/apphud/sdk/storage/Storage;", "context", "Landroid/content/Context;", "parser", "Lcom/apphud/sdk/parser/Parser;", "(Landroid/content/Context;Lcom/apphud/sdk/parser/Parser;)V", "value", "Lcom/apphud/sdk/domain/AdjustInfo;", "adjust", "getAdjust", "()Lcom/apphud/sdk/domain/AdjustInfo;", "setAdjust", "(Lcom/apphud/sdk/domain/AdjustInfo;)V", "", "advertisingId", "getAdvertisingId", "()Ljava/lang/String;", "setAdvertisingId", "(Ljava/lang/String;)V", "Lcom/apphud/sdk/domain/AppsflyerInfo;", "appsflyer", "getAppsflyer", "()Lcom/apphud/sdk/domain/AppsflyerInfo;", "setAppsflyer", "(Lcom/apphud/sdk/domain/AppsflyerInfo;)V", "cacheTimeout", "", "getCacheTimeout", "()J", "Lcom/apphud/sdk/domain/Customer;", "customer", "getCustomer", "()Lcom/apphud/sdk/domain/Customer;", "setCustomer", "(Lcom/apphud/sdk/domain/Customer;)V", "deviceId", "getDeviceId", "setDeviceId", "Lcom/apphud/sdk/domain/FacebookInfo;", "facebook", "getFacebook", "()Lcom/apphud/sdk/domain/FacebookInfo;", "setFacebook", "(Lcom/apphud/sdk/domain/FacebookInfo;)V", "firebase", "getFirebase", "setFirebase", "", "isNeedSync", "()Z", "setNeedSync", "(Z)V", "lastRegistration", "getLastRegistration", "setLastRegistration", "(J)V", "", "Lcom/apphud/sdk/domain/ApphudPaywall;", "paywalls", "getPaywalls", "()Ljava/util/List;", "setPaywalls", "(Ljava/util/List;)V", "preferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "Lcom/apphud/sdk/domain/ApphudGroup;", "productGroups", "getProductGroups", "setProductGroups", "Ljava/util/HashMap;", "Lcom/apphud/sdk/ApphudUserProperty;", "Lkotlin/collections/HashMap;", "properties", "getProperties", "()Ljava/util/HashMap;", "setProperties", "(Ljava/util/HashMap;)V", "skuDetails", "getSkuDetails", "setSkuDetails", "userId", "getUserId", "setUserId", "clean", "", "needRegistration", "needSendProperty", "property", "needUpdateProductGroups", "updateCustomer", "apphudListener", "Lcom/apphud/sdk/ApphudListener;", "Companion", "sdk_release"})
public final class SharedPreferencesStorage
implements Storage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Parser parser;
    private final SharedPreferences preferences;
    private final long cacheTimeout;
    @NotNull
    private static final String NAME = "apphud_storage";
    private static final int MODE = 0;
    @NotNull
    private static final String USER_ID_KEY = "userIdKey";
    @NotNull
    private static final String CUSTOMER_KEY = "customerKey";
    @NotNull
    private static final String DEVICE_ID_KEY = "deviceIdKey";
    @NotNull
    private static final String ADVERTISING_DI_KEY = "advertisingIdKey";
    @NotNull
    private static final String NEED_RESTART_KEY = "needRestartKey";
    @NotNull
    private static final String PROPERTIES_KEY = "propertiesKey";
    @NotNull
    private static final String FACEBOOK_KEY = "facebookKey";
    @NotNull
    private static final String FIREBASE_KEY = "firebaseKey";
    @NotNull
    private static final String APPSFLYER_KEY = "appsflyerKey";
    @NotNull
    private static final String ADJUST_KEY = "adjustKey";
    @NotNull
    private static final String PAYWALLS_KEY = "payWallsKey";
    @NotNull
    private static final String PAYWALLS_TIMESTAMP_KEY = "payWallsTimestampKey";
    @NotNull
    private static final String GROUP_KEY = "apphudGroupKey";
    @NotNull
    private static final String GROUP_TIMESTAMP_KEY = "apphudGroupTimestampKey";
    @NotNull
    private static final String SKU_KEY = "skuKey";
    @NotNull
    private static final String SKU_TIMESTAMP_KEY = "skuTimestampKey";
    @NotNull
    private static final String LAST_REGISTRATION_KEY = "lastRegistrationKey";

    public SharedPreferencesStorage(@NotNull Context context, @NotNull Parser parser) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.parser = parser;
        this.preferences = context.getSharedPreferences(NAME, 0);
        this.cacheTimeout = ApphudExtensionsKt.isDebuggable(context) ? 30L : 90000L;
    }

    public final long getCacheTimeout() {
        return this.cacheTimeout;
    }

    @Override
    @Nullable
    public String getUserId() {
        return this.preferences.getString(USER_ID_KEY, null);
    }

    @Override
    public void setUserId(@Nullable String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(USER_ID_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public Customer getCustomer() {
        String source = this.preferences.getString(CUSTOMER_KEY, null);
        return (Customer)this.parser.fromJson(source, (Type)((Object)Customer.class));
    }

    @Override
    public void setCustomer(@Nullable Customer value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(CUSTOMER_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public String getDeviceId() {
        return this.preferences.getString(DEVICE_ID_KEY, null);
    }

    @Override
    public void setDeviceId(@Nullable String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(DEVICE_ID_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public String getAdvertisingId() {
        return this.preferences.getString(ADVERTISING_DI_KEY, null);
    }

    @Override
    public void setAdvertisingId(@Nullable String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(ADVERTISING_DI_KEY, value);
        editor.apply();
    }

    @Override
    public boolean isNeedSync() {
        return this.preferences.getBoolean(NEED_RESTART_KEY, false);
    }

    @Override
    public void setNeedSync(boolean value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putBoolean(NEED_RESTART_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public FacebookInfo getFacebook() {
        String source = this.preferences.getString(FACEBOOK_KEY, null);
        return (FacebookInfo)this.parser.fromJson(source, (Type)((Object)FacebookInfo.class));
    }

    @Override
    public void setFacebook(@Nullable FacebookInfo value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(FACEBOOK_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public String getFirebase() {
        return this.preferences.getString(FIREBASE_KEY, null);
    }

    @Override
    public void setFirebase(@Nullable String value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(FIREBASE_KEY, value);
        editor.apply();
    }

    @Override
    @Nullable
    public AppsflyerInfo getAppsflyer() {
        String source = this.preferences.getString(APPSFLYER_KEY, null);
        return (AppsflyerInfo)this.parser.fromJson(source, (Type)((Object)AppsflyerInfo.class));
    }

    @Override
    public void setAppsflyer(@Nullable AppsflyerInfo value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(APPSFLYER_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public AdjustInfo getAdjust() {
        String source = this.preferences.getString(ADJUST_KEY, null);
        return (AdjustInfo)this.parser.fromJson(source, (Type)((Object)AdjustInfo.class));
    }

    @Override
    public void setAdjust(@Nullable AdjustInfo value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(ADJUST_KEY, source);
        editor.apply();
    }

    public final boolean needUpdateProductGroups() {
        long timestamp = this.preferences.getLong(GROUP_TIMESTAMP_KEY, -1L) + this.cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        return currentTime >= timestamp;
    }

    @Override
    @Nullable
    public List<ApphudGroup> getProductGroups() {
        String source = this.preferences.getString(GROUP_KEY, null);
        Type[] typeArray = new Type[]{(Type)((Object)ApphudGroup.class)};
        Type type = TypeToken.getParameterized((Type)((Type)((Object)List.class)), (Type[])typeArray).getType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
        return (List)this.parser.fromJson(source, type);
    }

    @Override
    public void setProductGroups(@Nullable List<ApphudGroup> value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putLong(GROUP_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(GROUP_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public List<ApphudPaywall> getPaywalls() {
        List list;
        long timestamp = this.preferences.getLong(PAYWALLS_TIMESTAMP_KEY, -1L) + this.cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp) {
            String source = this.preferences.getString(PAYWALLS_KEY, null);
            Type[] typeArray = new Type[]{(Type)((Object)ApphudPaywall.class)};
            Type type = TypeToken.getParameterized((Type)((Type)((Object)List.class)), (Type[])typeArray).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            list = (List)this.parser.fromJson(source, type);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    public void setPaywalls(@Nullable List<ApphudPaywall> value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putLong(PAYWALLS_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(PAYWALLS_KEY, source);
        editor.apply();
    }

    @Override
    @Nullable
    public List<String> getSkuDetails() {
        List list;
        long timestamp = this.preferences.getLong(SKU_TIMESTAMP_KEY, -1L) + this.cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        if (currentTime < timestamp) {
            String source = this.preferences.getString(SKU_KEY, null);
            Type[] typeArray = new Type[]{(Type)((Object)String.class)};
            Type type = TypeToken.getParameterized((Type)((Type)((Object)List.class)), (Type[])typeArray).getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            list = (List)this.parser.fromJson(source, type);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    public void setSkuDetails(@Nullable List<String> value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putLong(SKU_TIMESTAMP_KEY, System.currentTimeMillis());
        editor.putString(SKU_KEY, source);
        editor.apply();
    }

    @Override
    public long getLastRegistration() {
        return this.preferences.getLong(LAST_REGISTRATION_KEY, 0L);
    }

    @Override
    public void setLastRegistration(long value) {
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putLong(LAST_REGISTRATION_KEY, value);
        editor.apply();
    }

    public final void updateCustomer(@NotNull Customer customer, @Nullable ApphudListener apphudListener) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)customer, (String)"customer");
        boolean userIdChanged = false;
        Customer customer2 = this.getCustomer();
        if (customer2 != null) {
            it = customer2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Customer)it).getUser().getUserId(), (Object)customer.getUser().getUserId())) {
                userIdChanged = true;
            }
        }
        this.setCustomer(customer);
        this.setUserId(customer.getUser().getUserId());
        if (userIdChanged) {
            ApphudListener apphudListener2 = apphudListener;
            if (apphudListener2 != null) {
                it = apphudListener2;
                boolean bl = false;
                apphudListener.apphudDidChangeUserID(customer.getUser().getUserId());
            }
        }
    }

    public final void clean() {
        this.setLastRegistration(0L);
        this.setCustomer(null);
        this.setUserId(null);
        this.setDeviceId(null);
        this.setAdvertisingId(null);
        this.setNeedSync(false);
        this.setFacebook(null);
        this.setFirebase(null);
        this.setAppsflyer(null);
        this.setProductGroups(null);
        this.setPaywalls(null);
        this.setSkuDetails(null);
        this.setProperties(null);
        this.setAdjust(null);
    }

    public final boolean needRegistration() {
        boolean customerWithPurchases;
        boolean bl;
        long timestamp = this.getLastRegistration() + this.cacheTimeout * (long)1000;
        long currentTime = System.currentTimeMillis();
        Customer customer = this.getCustomer();
        if (customer == null) {
            bl = false;
        } else {
            boolean bl2;
            Customer it = customer;
            boolean bl3 = false;
            bl = customerWithPurchases = (bl2 = !it.getPurchases().isEmpty() || !it.getSubscriptions().isEmpty());
        }
        if (!customerWithPurchases) {
            boolean result;
            boolean bl4 = result = currentTime > timestamp;
            if (result) {
                ApphudLog.logI$default(ApphudLog.INSTANCE, "User without purchases: perform registration", false, 2, null);
            } else {
                long minutes = (timestamp - currentTime) / 60000L;
                long seconds = (timestamp - currentTime - minutes * 60000L) / 1000L;
                ApphudLog.logI$default(ApphudLog.INSTANCE, "User without purchases: registration will available after " + minutes + "min. " + seconds + "sec.", false, 2, null);
            }
            return result;
        }
        ApphudLog.logI$default(ApphudLog.INSTANCE, "User with purchases: perform registration", false, 2, null);
        return true;
    }

    @Override
    @Nullable
    public HashMap<String, ApphudUserProperty> getProperties() {
        String source = this.preferences.getString(PROPERTIES_KEY, null);
        Type[] typeArray = new Type[]{(Type)((Object)String.class), (Type)((Object)ApphudUserProperty.class)};
        Type type = TypeToken.getParameterized((Type)((Type)((Object)HashMap.class)), (Type[])typeArray).getType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
        return (HashMap)this.parser.fromJson(source, type);
    }

    @Override
    public void setProperties(@Nullable HashMap<String, ApphudUserProperty> value) {
        String source = this.parser.toJson(value);
        SharedPreferences.Editor editor = this.preferences.edit();
        editor.putString(PROPERTIES_KEY, source);
        editor.apply();
    }

    public final boolean needSendProperty(@NotNull ApphudUserProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, ApphudUserProperty>());
        }
        HashMap<String, ApphudUserProperty> hashMap = this.getProperties();
        if (hashMap != null) {
            HashMap<String, ApphudUserProperty> it = hashMap;
            boolean bl = false;
            if (property.getValue() == null) {
                if (it.containsKey(property.getKey())) {
                    it.remove(property.getKey());
                    this.setProperties(it);
                }
                return true;
            }
            if (it.containsKey(property.getKey())) {
                ApphudUserProperty apphudUserProperty = it.get(property.getKey());
                if (apphudUserProperty == null ? false : apphudUserProperty.getSetOnce()) {
                    String message = "Sending a property with key '" + property.getKey() + "' is skipped. The property was previously specified as not updatable";
                    ApphudLog.logI$default(ApphudLog.INSTANCE, message, false, 2, null);
                    return false;
                }
                if (property.getIncrement()) {
                    if (it.containsKey(property.getKey())) {
                        it.remove(property.getKey());
                        this.setProperties(it);
                    }
                    return true;
                }
                ApphudUserProperty apphudUserProperty2 = it.get(property.getKey());
                if (Intrinsics.areEqual((Object)(apphudUserProperty2 == null ? null : apphudUserProperty2.getValue$sdk_release()), (Object)property.getValue$sdk_release()) && !property.getSetOnce()) {
                    String message = "Sending a property with key '" + property.getKey() + "' is skipped. Property value was not changed";
                    ApphudLog.logI$default(ApphudLog.INSTANCE, message, false, 2, null);
                    return false;
                }
            }
        }
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/apphud/sdk/storage/SharedPreferencesStorage$Companion;", "", "()V", "ADJUST_KEY", "", "ADVERTISING_DI_KEY", "APPSFLYER_KEY", "CUSTOMER_KEY", "DEVICE_ID_KEY", "FACEBOOK_KEY", "FIREBASE_KEY", "GROUP_KEY", "GROUP_TIMESTAMP_KEY", "LAST_REGISTRATION_KEY", "MODE", "", "NAME", "NEED_RESTART_KEY", "PAYWALLS_KEY", "PAYWALLS_TIMESTAMP_KEY", "PROPERTIES_KEY", "SKU_KEY", "SKU_TIMESTAMP_KEY", "USER_ID_KEY", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

