/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.managers;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import androidx.core.os.ConfigurationCompat;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.SkuDetails;
import com.apphud.sdk.ApphudError;
import com.apphud.sdk.ApphudExtensionsKt;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudUtils;
import com.apphud.sdk.ContextKt;
import com.apphud.sdk.body.AttributionBody;
import com.apphud.sdk.body.BenchmarkBody;
import com.apphud.sdk.body.ErrorLogsBody;
import com.apphud.sdk.body.GrantPromotionalBody;
import com.apphud.sdk.body.PaywallEventBody;
import com.apphud.sdk.body.PurchaseBody;
import com.apphud.sdk.body.PurchaseItemBody;
import com.apphud.sdk.body.PurchaseItemObserverBody;
import com.apphud.sdk.body.RegistrationBody;
import com.apphud.sdk.body.UserPropertiesBody;
import com.apphud.sdk.client.ApphudUrl;
import com.apphud.sdk.client.dto.ApphudGroupDto;
import com.apphud.sdk.client.dto.AttributionDto;
import com.apphud.sdk.client.dto.CustomerDto;
import com.apphud.sdk.client.dto.ResponseDto;
import com.apphud.sdk.domain.ApphudGroup;
import com.apphud.sdk.domain.ApphudPaywall;
import com.apphud.sdk.domain.ApphudProduct;
import com.apphud.sdk.domain.Attribution;
import com.apphud.sdk.domain.Customer;
import com.apphud.sdk.domain.PurchaseRecordDetails;
import com.apphud.sdk.managers.HeadersInterceptor;
import com.apphud.sdk.managers.HttpRetryInterceptor;
import com.apphud.sdk.managers.RequestManager;
import com.apphud.sdk.mappers.AttributionMapper;
import com.apphud.sdk.mappers.CustomerMapper;
import com.apphud.sdk.mappers.PaywallsMapper;
import com.apphud.sdk.mappers.ProductMapper;
import com.apphud.sdk.mappers.SubscriptionMapper;
import com.apphud.sdk.parser.GsonParser;
import com.apphud.sdk.parser.Parser;
import com.apphud.sdk.storage.SharedPreferencesStorage;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u00107\u001a\n\u0012\u0004\u0012\u000209\u0018\u000108H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0018\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010@\u001a\u00020\u0001H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010\u00042\u0006\u0010B\u001a\u00020\u0004H\u0002J\b\u0010C\u001a\u00020DH\u0002J\u0018\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020<2\u0006\u0010H\u001a\u00020IH\u0002J\u0006\u0010J\u001a\u00020FJ\u0013\u0010K\u001a\u0004\u0018\u00010\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\u0012\u0010L\u001a\u00020M2\b\b\u0002\u0010N\u001a\u00020DH\u0002J@\u0010O\u001a\u00020F2\u0006\u0010P\u001a\u00020Q2\b\u0010R\u001a\u0004\u0018\u00010\u00042\b\u0010S\u001a\u0004\u0018\u0001092\u001c\u0010T\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010V\u0012\u0004\u0012\u00020F0UJ-\u0010W\u001a\u00020X2\u0006\u0010P\u001a\u00020Q2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010S\u001a\u0004\u0018\u000109H\u0000\u00a2\u0006\u0002\bYJ\b\u0010Z\u001a\u00020DH\u0002J\u0018\u0010[\u001a\u00020F2\u0006\u0010G\u001a\u00020<2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010\\\u001a\u00020F2\u0006\u0010G\u001a\u00020<H\u0002J!\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u00042\n\b\u0002\u0010`\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\baJ(\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020\u00042\n\b\u0002\u0010e\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010f\u001a\u0004\u0018\u00010\u0004H\u0002J.\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\b\u0010k\u001a\u0004\u0018\u00010l2\b\u0010e\u001a\u0004\u0018\u00010\u00042\b\u0010`\u001a\u0004\u0018\u00010\u0004H\u0002J8\u0010m\u001a\u00020F2\u0006\u0010G\u001a\u00020<2\b\b\u0002\u0010N\u001a\u00020D2\u001c\u0010T\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010V\u0012\u0004\u0012\u00020F0UH\u0002J\u001e\u0010n\u001a\u00020h2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020p082\u0006\u0010q\u001a\u00020DH\u0002J.\u0010r\u001a\u00020F2\u0006\u0010G\u001a\u00020<2\u001c\u0010T\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010V\u0012\u0004\u0012\u00020F0UH\u0002J\u0018\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020D2\u0006\u0010v\u001a\u00020DH\u0002J\u001a\u0010w\u001a\u00020F2\b\u0010e\u001a\u0004\u0018\u00010\u00042\b\u0010f\u001a\u0004\u0018\u00010\u0004J\u000e\u0010x\u001a\u00020F2\u0006\u0010y\u001a\u00020zJ\u001a\u0010{\u001a\u00020F2\b\u0010e\u001a\u0004\u0018\u00010\u00042\b\u0010f\u001a\u0004\u0018\u00010\u0004J\u000e\u0010|\u001a\u00020F2\u0006\u0010y\u001a\u00020zJ6\u0010}\u001a\u00020F2\u0006\u0010~\u001a\u00020M2\u0006\u0010G\u001a\u00020<2\u001c\u0010T\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010V\u0012\u0004\u0012\u00020F0UH\u0002J\u0016\u0010\u007f\u001a\u00020\u00042\u0006\u0010~\u001a\u00020M2\u0006\u0010G\u001a\u00020<JC\u0010\u0080\u0001\u001a\u00020F2\u0006\u0010i\u001a\u00020j2\b\u0010k\u001a\u0004\u0018\u00010l2\n\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u00012\u001c\u0010T\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010V\u0012\u0004\u0012\u00020F0UJ5\u0010\u0083\u0001\u001a\u00020F2\u0006\u0010u\u001a\u00020D2\u0006\u0010v\u001a\u00020D2\u001c\u0010T\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010V\u0012\u0004\u0012\u00020F0UJ0\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u00152\u0006\u0010u\u001a\u00020D2\u0006\u0010v\u001a\u00020D2\t\b\u0002\u0010\u0085\u0001\u001a\u00020DH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0086\u0001J=\u0010\u0087\u0001\u001a\u00020F2\u000e\u0010\u0088\u0001\u001a\t\u0012\u0004\u0012\u00020p0\u0089\u00012\u0006\u0010q\u001a\u00020D2\u001c\u0010T\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0006\u0012\u0004\u0018\u00010V\u0012\u0004\u0012\u00020F0UJ0\u0010\u008a\u0001\u001a\u00020F2\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u001d\u0010T\u001a\u0019\u0012\u0007\u0012\u0005\u0018\u00010\u008d\u0001\u0012\u0006\u0012\u0004\u0018\u00010V\u0012\u0004\u0012\u00020F0UJ\u0011\u0010\u008e\u0001\u001a\u00020F2\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001J\u000f\u0010\u0091\u0001\u001a\u00020F2\u0006\u0010_\u001a\u00020\u0004J3\u0010\u0092\u0001\u001a\u00020F2\u0006\u0010\f\u001a\u00020\r2\n\u00103\u001a\u00060\u0004j\u0002`42\n\u0010\u001c\u001a\u00060\u0004j\u0002`\u001d2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0093\u0001\u001a\u00020F2\u0007\u0010\u008f\u0001\u001a\u00020cH\u0002J0\u0010\u0094\u0001\u001a\u00020F2\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u001d\u0010T\u001a\u0019\u0012\u0007\u0012\u0005\u0018\u00010\u008d\u0001\u0012\u0006\u0012\u0004\u0018\u00010V\u0012\u0004\u0012\u00020F0UR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00060\u0004j\u0002`\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\nR\u0019\u0010 \u001a\n \"*\u0004\u0018\u00010!0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020.X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001e\u00103\u001a\u00060\u0004j\u0002`4X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\b\"\u0004\b6\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0097\u0001"}, d2={"Lcom/apphud/sdk/managers/RequestManager;", "", "()V", "MUST_REGISTER_ERROR", "", "value", "advertisingId", "getAdvertisingId", "()Ljava/lang/String;", "setAdvertisingId", "(Ljava/lang/String;)V", "apiKey", "applicationContext", "Landroid/content/Context;", "getApplicationContext", "()Landroid/content/Context;", "setApplicationContext", "(Landroid/content/Context;)V", "attributionMapper", "Lcom/apphud/sdk/mappers/AttributionMapper;", "currentUser", "Lcom/apphud/sdk/domain/Customer;", "getCurrentUser", "()Lcom/apphud/sdk/domain/Customer;", "setCurrentUser", "(Lcom/apphud/sdk/domain/Customer;)V", "customerMapper", "Lcom/apphud/sdk/mappers/CustomerMapper;", "deviceId", "Lcom/apphud/sdk/DeviceId;", "getDeviceId", "setDeviceId", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getGson", "()Lcom/google/gson/Gson;", "parser", "Lcom/apphud/sdk/parser/Parser;", "getParser", "()Lcom/apphud/sdk/parser/Parser;", "paywallsMapper", "Lcom/apphud/sdk/mappers/PaywallsMapper;", "productMapper", "Lcom/apphud/sdk/mappers/ProductMapper;", "storage", "Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "getStorage", "()Lcom/apphud/sdk/storage/SharedPreferencesStorage;", "setStorage", "(Lcom/apphud/sdk/storage/SharedPreferencesStorage;)V", "userId", "Lcom/apphud/sdk/UserId;", "getUserId", "setUserId", "allProducts", "", "Lcom/apphud/sdk/domain/ApphudGroup;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildGetRequest", "Lokhttp3/Request;", "url", "Ljava/net/URL;", "buildPostRequest", "params", "buildPrettyPrintedBy", "jsonString", "canPerformRequest", "", "checkLock403", "", "request", "response", "Lokhttp3/Response;", "cleanRegistration", "fetchAdvertisingId", "getOkHttpClient", "Lokhttp3/OkHttpClient;", "retry", "grantPromotional", "daysCount", "", "productId", "permissionGroup", "completionHandler", "Lkotlin/Function2;", "Lcom/apphud/sdk/ApphudError;", "grantPromotionalBody", "Lcom/apphud/sdk/body/GrantPromotionalBody;", "grantPromotionalBody$sdk_release", "isNetworkAvailable", "logRequestFinish", "logRequestStart", "makeErrorLogsBody", "Lcom/apphud/sdk/body/ErrorLogsBody;", "message", "apphud_product_id", "makeErrorLogsBody$sdk_release", "makePaywallEventBody", "Lcom/apphud/sdk/body/PaywallEventBody;", "name", "paywall_id", "product_id", "makePurchaseBody", "Lcom/apphud/sdk/body/PurchaseBody;", "purchase", "Lcom/android/billingclient/api/Purchase;", "details", "Lcom/android/billingclient/api/SkuDetails;", "makeRequest", "makeRestorePurchasesBody", "purchases", "Lcom/apphud/sdk/domain/PurchaseRecordDetails;", "skipObserverModeParam", "makeUserRegisteredRequest", "mkRegistrationBody", "Lcom/apphud/sdk/body/RegistrationBody;", "needPaywalls", "isNew", "paywallCheckoutInitiated", "paywallClosed", "paywall", "Lcom/apphud/sdk/domain/ApphudPaywall;", "paywallPaymentCancelled", "paywallShown", "performRequest", "client", "performRequestSync", "purchased", "apphudProduct", "Lcom/apphud/sdk/domain/ApphudProduct;", "registration", "registrationSync", "forceRegistration", "(ZZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restorePurchases", "purchaseRecordDetailsSet", "", "send", "attributionBody", "Lcom/apphud/sdk/body/AttributionBody;", "Lcom/apphud/sdk/domain/Attribution;", "sendBenchmarkLogs", "body", "Lcom/apphud/sdk/body/BenchmarkBody;", "sendErrorLogs", "setParams", "trackPaywallEvent", "userProperties", "userPropertiesBody", "Lcom/apphud/sdk/body/UserPropertiesBody;", "sdk_release"})
public final class RequestManager {
    @NotNull
    public static final RequestManager INSTANCE = new RequestManager();
    @NotNull
    private static final String MUST_REGISTER_ERROR = " :You must call the Apphud.start method once when your application starts before calling any other methods.";
    @Nullable
    private static Customer currentUser;
    private static final Gson gson;
    @NotNull
    private static final Parser parser;
    @NotNull
    private static final ProductMapper productMapper;
    @NotNull
    private static final PaywallsMapper paywallsMapper;
    @NotNull
    private static final AttributionMapper attributionMapper;
    @NotNull
    private static final CustomerMapper customerMapper;
    @Nullable
    private static String apiKey;
    public static String userId;
    public static String deviceId;
    public static Context applicationContext;
    public static SharedPreferencesStorage storage;
    @Nullable
    private static String advertisingId;

    private RequestManager() {
    }

    @Nullable
    public final Customer getCurrentUser() {
        return currentUser;
    }

    public final void setCurrentUser(@Nullable Customer customer2) {
        currentUser = customer2;
    }

    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final Parser getParser() {
        return parser;
    }

    @NotNull
    public final String getUserId() {
        String string = userId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"userId");
        return null;
    }

    public final void setUserId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        userId = string;
    }

    @NotNull
    public final String getDeviceId() {
        String string = deviceId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"deviceId");
        return null;
    }

    public final void setDeviceId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        deviceId = string;
    }

    @NotNull
    public final Context getApplicationContext() {
        Context context = applicationContext;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
        return null;
    }

    public final void setApplicationContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        applicationContext = context;
    }

    @NotNull
    public final SharedPreferencesStorage getStorage() {
        SharedPreferencesStorage sharedPreferencesStorage = storage;
        if (sharedPreferencesStorage != null) {
            return sharedPreferencesStorage;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"storage");
        return null;
    }

    public final void setStorage(@NotNull SharedPreferencesStorage sharedPreferencesStorage) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferencesStorage, (String)"<set-?>");
        storage = sharedPreferencesStorage;
    }

    @Nullable
    public final String getAdvertisingId() {
        return this.getStorage().getAdvertisingId();
    }

    public final void setAdvertisingId(@Nullable String value) {
        advertisingId = value;
        if (!Intrinsics.areEqual((Object)this.getStorage().getAdvertisingId(), (Object)value)) {
            this.getStorage().setAdvertisingId(value);
            ApphudLog.log$default(ApphudLog.INSTANCE, "advertisingId = " + this.getAdvertisingId() + " is fetched and saved", false, 2, null);
        }
    }

    public final void setParams(@NotNull Context applicationContext, @NotNull String userId, @NotNull String deviceId, @Nullable String apiKey) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        this.setApplicationContext(applicationContext);
        this.setUserId(userId);
        this.setDeviceId(deviceId);
        String string = apiKey;
        if (string != null) {
            String it = string;
            boolean bl = false;
            RequestManager.apiKey = it;
        }
        this.setStorage(new SharedPreferencesStorage(this.getApplicationContext(), parser));
        currentUser = null;
    }

    public static /* synthetic */ void setParams$default(RequestManager requestManager, Context context, String string, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        requestManager.setParams(context, string, string2, string3);
    }

    public final void cleanRegistration() {
        currentUser = null;
        this.setAdvertisingId(null);
        apiKey = null;
    }

    private final boolean canPerformRequest() {
        return applicationContext != null && userId != null && deviceId != null && apiKey != null;
    }

    private final OkHttpClient getOkHttpClient(boolean retry) {
        HttpRetryInterceptor retryInterceptor = new HttpRetryInterceptor();
        HeadersInterceptor headersInterceptor = new HeadersInterceptor(apiKey);
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(RequestManager::getOkHttpClient$lambda-3);
        logging.level(HttpLoggingInterceptor.Level.NONE);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (retry) {
            builder.addInterceptor((Interceptor)retryInterceptor);
        }
        builder.addNetworkInterceptor((Interceptor)headersInterceptor);
        builder.addNetworkInterceptor((Interceptor)logging);
        return builder.build();
    }

    static /* synthetic */ OkHttpClient getOkHttpClient$default(RequestManager requestManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return requestManager.getOkHttpClient(bl);
    }

    private final void logRequestStart(Request request) {
        try {
            Charset charset;
            Ref.ObjectRef body = new Ref.ObjectRef();
            body.element = "";
            RequestBody requestBody = request.body();
            if (requestBody == null) {
                charset = null;
            } else {
                Unit unit;
                RequestBody it = requestBody;
                boolean bl = false;
                Buffer buffer = new Buffer();
                it.writeTo((BufferedSink)buffer);
                Charset charset2 = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(\"UTF-8\")");
                body.element = buffer.readString(charset2);
                String string = (String)body.element;
                if (string != null) {
                    String it2 = string;
                    boolean bl2 = false;
                    if (INSTANCE.getParser().isJson(it2)) {
                        body.element = INSTANCE.buildPrettyPrintedBy(it2);
                    }
                }
                String string2 = (String)body.element;
                if (string2 == null) {
                    unit = null;
                } else {
                    String it3 = string2;
                    boolean bl3 = false;
                    if (((CharSequence)it3).length() > 0) {
                        body.element = Intrinsics.stringPlus((String)"\n", (Object)it3);
                    }
                    unit = Unit.INSTANCE;
                }
                charset2 = unit;
                charset = charset2 == null ? new Function0<Unit>((Ref.ObjectRef<String>)body){
                    final /* synthetic */ Ref.ObjectRef<String> $body;
                    {
                        this.$body = $body;
                        super(0);
                    }

                    public final void invoke() {
                        this.$body.element = "";
                    }
                } : charset2;
            }
            ApphudLog.logI$default(ApphudLog.INSTANCE, "Start " + request.method() + " request " + request.url() + " with params:" + body.element, false, 2, null);
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "";
            }
            ApphudLog.logE$default(ApphudLog.INSTANCE, string, false, 2, null);
        }
    }

    private final void logRequestFinish(Request request, Response response) {
        try {
            String string;
            BufferedSource source;
            ResponseBody responseBody;
            ResponseBody responseBody2 = responseBody = response.body();
            BufferedSource bufferedSource = source = responseBody2 == null ? null : responseBody2.source();
            if (bufferedSource != null) {
                bufferedSource.request(Long.MAX_VALUE);
            }
            BufferedSource bufferedSource2 = source;
            if (bufferedSource2 == null) {
                string = null;
            } else {
                Buffer buffer = bufferedSource2.getBuffer();
                if (buffer == null) {
                    string = null;
                } else {
                    Buffer buffer2 = buffer.clone();
                    if (buffer2 == null) {
                        string = null;
                    } else {
                        Charset charset = Charset.forName("UTF-8");
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
                        string = buffer2.readString(charset);
                    }
                }
            }
            String buffer = string;
            String outputBody = null;
            outputBody = "";
            String string2 = buffer;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                if (INSTANCE.getParser().isJson(buffer)) {
                    String string3 = INSTANCE.buildPrettyPrintedBy(it);
                    if (string3 == null) {
                        string3 = "";
                    }
                    outputBody = string3;
                }
            }
            ApphudLog.logI$default(ApphudLog.INSTANCE, "Finished " + request.method() + " request " + request.url() + " with response: " + response.code() + '\n' + outputBody, false, 2, null);
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "";
            }
            ApphudLog.logE$default(ApphudLog.INSTANCE, string, false, 2, null);
        }
    }

    private final void performRequest(OkHttpClient client, Request request, Function2<? super String, ? super ApphudError, Unit> completionHandler) {
        try {
            if (HeadersInterceptor.Shared.isBlocked()) {
                String message = "Unable to perform API requests, because your account has been suspended.";
                ApphudLog.logE$default(ApphudLog.INSTANCE, message, false, 2, null);
                completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
            } else {
                this.logRequestStart(request);
                Response response = client.newCall(request).execute();
                ApphudLog.INSTANCE.logBenchmark(request.url().encodedPath(), response.receivedResponseAtMillis() - response.sentRequestAtMillis());
                this.logRequestFinish(request, response);
                if (response.isSuccessful()) {
                    Unit unit;
                    Unit unit2;
                    ResponseBody responseBody = response.body();
                    if (responseBody == null) {
                        unit2 = null;
                    } else {
                        ResponseBody it = responseBody;
                        boolean bl = false;
                        completionHandler.invoke((Object)it.string(), null);
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit == null) {
                        RequestManager $this$performRequest_u24lambda_u2d9 = this;
                        boolean bl = false;
                        completionHandler.invoke(null, (Object)new ApphudError("Request failed", null, response.code()));
                    }
                } else {
                    this.checkLock403(request, response);
                    String message = "finish " + request.method() + " request " + request.url() + " failed with code: " + response.code() + " response: " + this.buildPrettyPrintedBy(String.valueOf(response.body()));
                    completionHandler.invoke(null, (Object)new ApphudError(message, null, response.code()));
                }
            }
        }
        catch (IOException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Undefined error";
            }
            String message = string;
            completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
        }
    }

    @NotNull
    public final String performRequestSync(@NotNull OkHttpClient client, @NotNull Request request) throws Exception {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (HeadersInterceptor.Shared.isBlocked()) {
            String message = "SDK networking is locked until application restart";
            ApphudLog.logE$default(ApphudLog.INSTANCE, message, false, 2, null);
            throw new Exception(message);
        }
        this.logRequestStart(request);
        Response response = client.newCall(request).execute();
        ApphudLog.INSTANCE.logBenchmark(request.url().encodedPath(), response.receivedResponseAtMillis() - response.sentRequestAtMillis());
        this.logRequestFinish(request, response);
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        String responseBody2 = responseBody.string();
        if (response.isSuccessful()) {
            return responseBody2;
        }
        this.checkLock403(request, response);
        String message = "finish " + request.method() + " request " + request.url() + " failed with code: " + response.code() + " response: " + this.buildPrettyPrintedBy(responseBody2);
        throw new Exception(message);
    }

    private final void checkLock403(Request request, Response response) {
        if (response.code() == 403 && Intrinsics.areEqual((Object)request.method(), (Object)"POST") && StringsKt.endsWith$default((String)request.url().encodedPath(), (String)"/customers", (boolean)false, (int)2, null)) {
            HeadersInterceptor.Shared.setBlocked(true);
        }
    }

    private final void makeRequest(Request request, boolean retry, Function2<? super String, ? super ApphudError, Unit> completionHandler) {
        OkHttpClient httpClient = this.getOkHttpClient(retry);
        this.performRequest(httpClient, request, completionHandler);
    }

    static /* synthetic */ void makeRequest$default(RequestManager requestManager, Request request, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        requestManager.makeRequest(request, bl, (Function2<? super String, ? super ApphudError, Unit>)function2);
    }

    private final void makeUserRegisteredRequest(Request request, Function2<? super String, ? super ApphudError, Unit> completionHandler) {
        OkHttpClient httpClient = RequestManager.getOkHttpClient$default(this, false, 1, null);
        if (currentUser == null) {
            this.registration(true, true, (Function2<? super Customer, ? super ApphudError, Unit>)((Function2)new Function2<Customer, ApphudError, Unit>(httpClient, request, completionHandler){
                final /* synthetic */ OkHttpClient $httpClient;
                final /* synthetic */ Request $request;
                final /* synthetic */ Function2<String, ApphudError, Unit> $completionHandler;
                {
                    this.$httpClient = $httpClient;
                    this.$request = $request;
                    this.$completionHandler = $completionHandler;
                    super(2);
                }

                public final void invoke(@Nullable Customer customer2, @Nullable ApphudError error) {
                    block2: {
                        Unit unit;
                        Function2<String, ApphudError, Unit> function2;
                        Unit unit2;
                        Function2<String, ApphudError, Unit> function22 = customer2;
                        if (function22 == null) {
                            unit2 = null;
                        } else {
                            function2 = function22;
                            OkHttpClient okHttpClient = this.$httpClient;
                            Request request = this.$request;
                            Function2<String, ApphudError, Unit> function23 = this.$completionHandler;
                            Function2<String, ApphudError, Unit> it = function2;
                            boolean bl = false;
                            RequestManager.access$performRequest(RequestManager.INSTANCE, okHttpClient, request, function23);
                            unit2 = unit = Unit.INSTANCE;
                        }
                        if (unit != null) break block2;
                        RequestManager requestManager = RequestManager.INSTANCE;
                        function2 = this.$completionHandler;
                        RequestManager $this$invoke_u24lambda_u2d1 = requestManager;
                        boolean bl = false;
                        function2.invoke(null, (Object)error);
                    }
                }
            }));
        } else {
            this.performRequest(httpClient, request, completionHandler);
        }
    }

    private final Request buildPostRequest(URL url, Object params) {
        String json = parser.toJson(params);
        MediaType mediaType = MediaType.Companion.get("application/json; charset=utf-8");
        RequestBody requestBody = RequestBody.Companion.create(json, mediaType);
        Request.Builder request = new Request.Builder();
        return request.url(url).post(requestBody).build();
    }

    private final Request buildGetRequest(URL url) {
        Request.Builder request = new Request.Builder();
        return request.url(url).get().build();
    }

    @Nullable
    public final Object fetchAdvertisingId(@NotNull Continuation<? super String> $completion) {
        Continuation<? super String> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        String advId = null;
        if (ApphudUtils.INSTANCE.getAdTracking()) {
            try {
                ApphudLog.logI$default(ApphudLog.INSTANCE, "start load advertisingId", false, 2, null);
                advId = AdvertisingIdClient.getAdvertisingIdInfo((Context)INSTANCE.getApplicationContext()).getId();
                ApphudLog.logI$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"success load advertisingId: ", (Object)advId), false, 2, null);
            }
            catch (IOException e) {
                ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"finish load advertisingId ", (Object)e), false, 2, null);
            }
            catch (IllegalStateException e) {
                ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"finish load advertisingId ", (Object)e), false, 2, null);
            }
            catch (GooglePlayServicesNotAvailableException e) {
                ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"finish load advertisingId ", (Object)((Object)e)), false, 2, null);
            }
            catch (GooglePlayServicesRepairableException e) {
                ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"finish load advertisingId ", (Object)((Object)e)), false, 2, null);
            }
        }
        continuation2.resumeWith(Result.constructor-impl(advId));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object registrationSync(boolean needPaywalls, boolean isNew, boolean forceRegistration, @NotNull Continuation<? super Customer> $completion) {
        Continuation<? super Customer> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        if (!INSTANCE.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "registrationSync  :You must call the Apphud.start method once when your application starts before calling any other methods.", false, 2, null);
            continuation2.resumeWith(Result.constructor-impl(null));
        }
        if (INSTANCE.getCurrentUser() == null || forceRegistration) {
            ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("customers").build();
            Request request = INSTANCE.buildPostRequest(new URL(apphudUrl.getUrl()), INSTANCE.mkRegistrationBody(needPaywalls, isNew));
            OkHttpClient httpClient = RequestManager.getOkHttpClient$default(INSTANCE, false, 1, null);
            try {
                Object object;
                ResponseDto responseDto2;
                String serverResponse = INSTANCE.performRequestSync(httpClient, request);
                Parser parser = INSTANCE.getParser();
                Type type2 = new TypeToken<ResponseDto<CustomerDto>>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026o<CustomerDto>>() {}.type");
                ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
                if (responseDto3 == null) {
                    object = null;
                } else {
                    Customer customer2;
                    ResponseDto cDto = responseDto3;
                    boolean bl2 = false;
                    RequestManager requestManager = INSTANCE;
                    CustomerDto customerDto = (CustomerDto)cDto.getData().getResults();
                    if (customerDto == null) {
                        customer2 = null;
                    } else {
                        void customerObj;
                        CustomerDto customerDto2 = customerDto;
                        RequestManager requestManager2 = requestManager;
                        boolean bl3 = false;
                        customer2 = customerMapper.map((CustomerDto)customerObj);
                        requestManager = requestManager2;
                    }
                    requestManager.setCurrentUser(customer2);
                    continuation2.resumeWith(Result.constructor-impl((Object)INSTANCE.getCurrentUser()));
                    object = type2 = Unit.INSTANCE;
                }
                if (type2 == null) {
                    RequestManager $this$registrationSync_u24lambda_u2d14_u24lambda_u2d13 = INSTANCE;
                    boolean bl4 = false;
                    continuation2.resumeWith(Result.constructor-impl(null));
                }
            }
            catch (Exception ex) {
                String string = ex.getMessage();
                if (string == null) {
                    string = "Undefined error";
                }
                String message = string;
                ApphudLog.logE$default(ApphudLog.INSTANCE, message, false, 2, null);
                continuation2.resumeWith(Result.constructor-impl(null));
            }
        } else {
            continuation2.resumeWith(Result.constructor-impl((Object)INSTANCE.getCurrentUser()));
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public static /* synthetic */ Object registrationSync$default(RequestManager requestManager, boolean bl, boolean bl2, boolean bl3, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl3 = false;
        }
        return requestManager.registrationSync(bl, bl2, bl3, (Continuation<? super Customer>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void registration(boolean needPaywalls, boolean isNew, @NotNull Function2<? super Customer, ? super ApphudError, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"registration", (Object)MUST_REGISTER_ERROR), false, 2, null);
            return;
        }
        if (currentUser == null) {
            ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("customers").build();
            Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), this.mkRegistrationBody(needPaywalls, isNew));
            OkHttpClient httpClient = RequestManager.getOkHttpClient$default(this, false, 1, null);
            try {
                Object object;
                ResponseDto responseDto2;
                String serverResponse = this.performRequestSync(httpClient, request);
                Type type2 = new TypeToken<ResponseDto<CustomerDto>>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026o<CustomerDto>>() {}.type");
                ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
                if (responseDto3 == null) {
                    object = null;
                } else {
                    Customer customer2;
                    ResponseDto cDto = responseDto3;
                    boolean bl = false;
                    RequestManager requestManager = INSTANCE;
                    CustomerDto customerDto = (CustomerDto)cDto.getData().getResults();
                    if (customerDto == null) {
                        customer2 = null;
                    } else {
                        void customerObj;
                        CustomerDto customerDto2 = customerDto;
                        RequestManager requestManager2 = requestManager;
                        boolean bl2 = false;
                        customer2 = customerMapper.map((CustomerDto)customerObj);
                        requestManager = requestManager2;
                    }
                    requestManager.setCurrentUser(customer2);
                    completionHandler.invoke((Object)INSTANCE.getCurrentUser(), null);
                    object = type2 = Unit.INSTANCE;
                }
                if (type2 == null) {
                    RequestManager $this$registration_u24lambda_u2d17 = this;
                    boolean bl = false;
                    completionHandler.invoke(null, (Object)new ApphudError("Registration failed", null, null, 6, null));
                }
            }
            catch (Exception ex) {
                String string = ex.getMessage();
                if (string == null) {
                    string = "Undefined error";
                }
                String message = string;
                completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
            }
        } else {
            completionHandler.invoke(null, null);
        }
    }

    @Nullable
    public final Object allProducts(@NotNull Continuation<? super List<ApphudGroup>> $completion) {
        Continuation<? super List<ApphudGroup>> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation continuation2 = (Continuation)safeContinuation;
        boolean bl = false;
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v2").path("products").build();
        Request request = INSTANCE.buildGetRequest(new URL(apphudUrl.getUrl()));
        RequestManager.makeRequest$default(INSTANCE, request, false, (Function2)new Function2<String, ApphudError, Unit>((Continuation<? super List<ApphudGroup>>)continuation2){
            final /* synthetic */ Continuation<List<ApphudGroup>> $continuation;
            {
                this.$continuation = $continuation;
                super(2);
            }

            public final void invoke(@Nullable String serverResponse, @Nullable ApphudError error) {
                block8: {
                    Unit unit;
                    Continuation<List<ApphudGroup>> continuation;
                    Unit unit2;
                    Continuation<List<ApphudGroup>> continuation2 = serverResponse;
                    if (continuation2 == null) {
                        unit2 = null;
                    } else {
                        Object object;
                        ResponseDto responseDto2;
                        continuation = continuation2;
                        Continuation<List<ApphudGroup>> continuation3 = this.$continuation;
                        Continuation<List<ApphudGroup>> it = continuation;
                        boolean bl = false;
                        Parser parser = RequestManager.INSTANCE.getParser();
                        Type type2 = new TypeToken<ResponseDto<List<? extends ApphudGroupDto>>>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object: TypeToken<Respon\u2026pphudGroupDto>>>(){}.type");
                        ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson((String)serverResponse, type2);
                        if (responseDto3 == null) {
                            object = null;
                        } else {
                            List<ApphudGroup> list;
                            ResponseDto response = responseDto3;
                            boolean bl2 = false;
                            List list2 = (List)response.getData().getResults();
                            if (list2 == null) {
                                list = null;
                            } else {
                                List it1 = list2;
                                boolean bl3 = false;
                                list = RequestManager.access$getProductMapper$p().map(it1);
                            }
                            List<ApphudGroup> productsList = list;
                            continuation3.resumeWith(Result.constructor-impl(productsList));
                            object = type2 = Unit.INSTANCE;
                        }
                        if (type2 == null) {
                            RequestManager $this$invoke_u24lambda_u2d3_u24lambda_u2d2 = RequestManager.INSTANCE;
                            boolean bl4 = false;
                            ApphudLog.logE$default(ApphudLog.INSTANCE, "Failed to load products", false, 2, null);
                            continuation3.resumeWith(Result.constructor-impl(null));
                        }
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit != null) break block8;
                    RequestManager requestManager = RequestManager.INSTANCE;
                    continuation = this.$continuation;
                    RequestManager $this$invoke_u24lambda_u2d4 = requestManager;
                    boolean bl = false;
                    if (error != null) {
                        ApphudLog.logE$default(ApphudLog.INSTANCE, error.getMessage(), false, 2, null);
                    }
                    continuation.resumeWith(Result.constructor-impl(null));
                }
            }
        }, 2, null);
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public final void purchased(@NotNull Purchase purchase2, @Nullable SkuDetails details2, @Nullable ApphudProduct apphudProduct, @NotNull Function2<? super Customer, ? super ApphudError, Unit> completionHandler) {
        PurchaseBody purchaseBody;
        PurchaseBody purchaseBody2;
        Object it;
        PurchaseBody purchaseBody3;
        Intrinsics.checkNotNullParameter((Object)purchase2, (String)"purchase");
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"purchased", (Object)MUST_REGISTER_ERROR), false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("subscriptions").build();
        SkuDetails skuDetails2 = details2;
        if (skuDetails2 == null) {
            purchaseBody3 = null;
        } else {
            it = skuDetails2;
            boolean bl = false;
            purchaseBody3 = INSTANCE.makePurchaseBody(purchase2, (SkuDetails)it, null, null);
        }
        PurchaseBody purchaseBody4 = purchaseBody3;
        if (purchaseBody4 == null) {
            ApphudProduct apphudProduct2 = apphudProduct;
            if (apphudProduct2 == null) {
                purchaseBody2 = null;
            } else {
                it = apphudProduct2;
                boolean bl = false;
                purchaseBody2 = INSTANCE.makePurchaseBody(purchase2, ((ApphudProduct)it).getSkuDetails(), ((ApphudProduct)it).getPaywall_id(), ((ApphudProduct)it).getId());
            }
        } else {
            purchaseBody2 = purchaseBody = purchaseBody4;
        }
        if (purchaseBody == null) {
            String string;
            String string2 = "SkuDetails and ApphudProduct can not be null at the same time";
            ApphudProduct apphudProduct3 = apphudProduct;
            if (apphudProduct3 == null) {
                string = null;
            } else {
                it = apphudProduct3;
                String string3 = string2;
                boolean bl = false;
                string = " [Apphud product ID: " + ((ApphudProduct)it).getId() + ']';
                string2 = string3;
            }
            String message = Intrinsics.stringPlus((String)string2, string);
            ApphudLog.logE$default(ApphudLog.INSTANCE, message, false, 2, null);
            completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
            return;
        }
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), purchaseBody);
        this.makeUserRegisteredRequest(request, (Function2<? super String, ? super ApphudError, Unit>)((Function2)new Function2<String, ApphudError, Unit>(completionHandler){
            final /* synthetic */ Function2<Customer, ApphudError, Unit> $completionHandler;
            {
                this.$completionHandler = $completionHandler;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@Nullable String serverResponse, @Nullable ApphudError error) {
                block7: {
                    Unit unit;
                    Function2<Customer, ApphudError, Unit> function2;
                    Unit unit2;
                    Function2<Customer, ApphudError, Unit> function22 = serverResponse;
                    if (function22 == null) {
                        unit2 = null;
                    } else {
                        Object object;
                        ResponseDto responseDto2;
                        function2 = function22;
                        Function2<Customer, ApphudError, Unit> function23 = this.$completionHandler;
                        Function2<Customer, ApphudError, Unit> it = function2;
                        boolean bl = false;
                        Parser parser = RequestManager.INSTANCE.getParser();
                        Type type2 = new TypeToken<ResponseDto<CustomerDto>>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026o<CustomerDto>>() {}.type");
                        ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson((String)serverResponse, type2);
                        if (responseDto3 == null) {
                            object = null;
                        } else {
                            Customer customer2;
                            ResponseDto cDto = responseDto3;
                            boolean bl2 = false;
                            RequestManager requestManager = RequestManager.INSTANCE;
                            CustomerDto customerDto = (CustomerDto)cDto.getData().getResults();
                            if (customerDto == null) {
                                customer2 = null;
                            } else {
                                void customerObj;
                                CustomerDto customerDto2 = customerDto;
                                RequestManager requestManager2 = requestManager;
                                boolean bl3 = false;
                                customer2 = RequestManager.access$getCustomerMapper$p().map((CustomerDto)customerObj);
                                requestManager = requestManager2;
                            }
                            requestManager.setCurrentUser(customer2);
                            function23.invoke((Object)RequestManager.INSTANCE.getCurrentUser(), null);
                            object = type2 = Unit.INSTANCE;
                        }
                        if (type2 == null) {
                            RequestManager $this$invoke_u24lambda_u2d3_u24lambda_u2d2 = RequestManager.INSTANCE;
                            boolean bl4 = false;
                            function23.invoke(null, (Object)new ApphudError("Purchase failed", null, null, 6, null));
                        }
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit != null) break block7;
                    RequestManager requestManager = RequestManager.INSTANCE;
                    function2 = this.$completionHandler;
                    RequestManager $this$invoke_u24lambda_u2d4 = requestManager;
                    boolean bl = false;
                    function2.invoke(null, (Object)error);
                }
            }
        }));
    }

    public final void restorePurchases(@NotNull Set<PurchaseRecordDetails> purchaseRecordDetailsSet, boolean skipObserverModeParam, @NotNull Function2<? super Customer, ? super ApphudError, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter(purchaseRecordDetailsSet, (String)"purchaseRecordDetailsSet");
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"restorePurchases", (Object)MUST_REGISTER_ERROR), false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("subscriptions").build();
        PurchaseBody purchaseBody = this.makeRestorePurchasesBody(CollectionsKt.toList((Iterable)purchaseRecordDetailsSet), skipObserverModeParam);
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), purchaseBody);
        this.makeUserRegisteredRequest(request, (Function2<? super String, ? super ApphudError, Unit>)((Function2)new Function2<String, ApphudError, Unit>(completionHandler){
            final /* synthetic */ Function2<Customer, ApphudError, Unit> $completionHandler;
            {
                this.$completionHandler = $completionHandler;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@Nullable String serverResponse, @Nullable ApphudError error) {
                block7: {
                    Unit unit;
                    Function2<Customer, ApphudError, Unit> function2;
                    Unit unit2;
                    Function2<Customer, ApphudError, Unit> function22 = serverResponse;
                    if (function22 == null) {
                        unit2 = null;
                    } else {
                        Object object;
                        ResponseDto responseDto2;
                        function2 = function22;
                        Function2<Customer, ApphudError, Unit> function23 = this.$completionHandler;
                        Function2<Customer, ApphudError, Unit> it = function2;
                        boolean bl = false;
                        Parser parser = RequestManager.INSTANCE.getParser();
                        Type type2 = new TypeToken<ResponseDto<CustomerDto>>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026o<CustomerDto>>() {}.type");
                        ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson((String)serverResponse, type2);
                        if (responseDto3 == null) {
                            object = null;
                        } else {
                            Customer customer2;
                            ResponseDto cDto = responseDto3;
                            boolean bl2 = false;
                            RequestManager requestManager = RequestManager.INSTANCE;
                            CustomerDto customerDto = (CustomerDto)cDto.getData().getResults();
                            if (customerDto == null) {
                                customer2 = null;
                            } else {
                                void customerObj;
                                CustomerDto customerDto2 = customerDto;
                                RequestManager requestManager2 = requestManager;
                                boolean bl3 = false;
                                customer2 = RequestManager.access$getCustomerMapper$p().map((CustomerDto)customerObj);
                                requestManager = requestManager2;
                            }
                            requestManager.setCurrentUser(customer2);
                            function23.invoke((Object)RequestManager.INSTANCE.getCurrentUser(), null);
                            object = type2 = Unit.INSTANCE;
                        }
                        if (type2 == null) {
                            RequestManager $this$invoke_u24lambda_u2d3_u24lambda_u2d2 = RequestManager.INSTANCE;
                            boolean bl4 = false;
                            function23.invoke(null, (Object)new ApphudError("Failed to restore purchases", null, null, 6, null));
                        }
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit != null) break block7;
                    RequestManager requestManager = RequestManager.INSTANCE;
                    function2 = this.$completionHandler;
                    RequestManager $this$invoke_u24lambda_u2d4 = requestManager;
                    boolean bl = false;
                    function2.invoke(null, (Object)error);
                }
            }
        }));
    }

    public final void send(@NotNull AttributionBody attributionBody, @NotNull Function2<? super Attribution, ? super ApphudError, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter((Object)attributionBody, (String)"attributionBody");
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"send", (Object)MUST_REGISTER_ERROR), false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("customers/attribution").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), attributionBody);
        this.makeUserRegisteredRequest(request, (Function2<? super String, ? super ApphudError, Unit>)((Function2)new Function2<String, ApphudError, Unit>(completionHandler){
            final /* synthetic */ Function2<Attribution, ApphudError, Unit> $completionHandler;
            {
                this.$completionHandler = $completionHandler;
                super(2);
            }

            public final void invoke(@Nullable String serverResponse, @Nullable ApphudError error) {
                block7: {
                    Unit unit;
                    Function2<Attribution, ApphudError, Unit> function2;
                    Unit unit2;
                    Function2<Attribution, ApphudError, Unit> function22 = serverResponse;
                    if (function22 == null) {
                        unit2 = null;
                    } else {
                        Object object;
                        ResponseDto responseDto2;
                        function2 = function22;
                        Function2<Attribution, ApphudError, Unit> function23 = this.$completionHandler;
                        Function2<Attribution, ApphudError, Unit> it = function2;
                        boolean bl = false;
                        Parser parser = RequestManager.INSTANCE.getParser();
                        Type type2 = new TypeToken<ResponseDto<AttributionDto>>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026ttributionDto>>() {}.type");
                        ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson((String)serverResponse, type2);
                        if (responseDto3 == null) {
                            object = null;
                        } else {
                            Attribution attribution;
                            ResponseDto response = responseDto3;
                            boolean bl2 = false;
                            AttributionDto attributionDto = (AttributionDto)response.getData().getResults();
                            if (attributionDto == null) {
                                attribution = null;
                            } else {
                                AttributionDto it1 = attributionDto;
                                boolean bl3 = false;
                                attribution = RequestManager.access$getAttributionMapper$p().map(it1);
                            }
                            Attribution attribution2 = attribution;
                            function23.invoke((Object)attribution2, null);
                            object = type2 = Unit.INSTANCE;
                        }
                        if (type2 == null) {
                            RequestManager $this$invoke_u24lambda_u2d3_u24lambda_u2d2 = RequestManager.INSTANCE;
                            boolean bl4 = false;
                            function23.invoke(null, (Object)new ApphudError("Failed to send attribution", null, null, 6, null));
                        }
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit != null) break block7;
                    RequestManager requestManager = RequestManager.INSTANCE;
                    function2 = this.$completionHandler;
                    RequestManager $this$invoke_u24lambda_u2d4 = requestManager;
                    boolean bl = false;
                    function2.invoke(null, (Object)error);
                }
            }
        }));
    }

    public final void userProperties(@NotNull UserPropertiesBody userPropertiesBody, @NotNull Function2<? super Attribution, ? super ApphudError, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter((Object)userPropertiesBody, (String)"userPropertiesBody");
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"userProperties", (Object)MUST_REGISTER_ERROR), false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("customers/properties").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), userPropertiesBody);
        this.makeUserRegisteredRequest(request, (Function2<? super String, ? super ApphudError, Unit>)((Function2)new Function2<String, ApphudError, Unit>(completionHandler){
            final /* synthetic */ Function2<Attribution, ApphudError, Unit> $completionHandler;
            {
                this.$completionHandler = $completionHandler;
                super(2);
            }

            public final void invoke(@Nullable String serverResponse, @Nullable ApphudError error) {
                block7: {
                    Unit unit;
                    Function2<Attribution, ApphudError, Unit> function2;
                    Unit unit2;
                    Function2<Attribution, ApphudError, Unit> function22 = serverResponse;
                    if (function22 == null) {
                        unit2 = null;
                    } else {
                        Object object;
                        ResponseDto responseDto2;
                        function2 = function22;
                        Function2<Attribution, ApphudError, Unit> function23 = this.$completionHandler;
                        Function2<Attribution, ApphudError, Unit> it = function2;
                        boolean bl = false;
                        Parser parser = RequestManager.INSTANCE.getParser();
                        Type type2 = new TypeToken<ResponseDto<AttributionDto>>(){}.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026ttributionDto>>() {}.type");
                        ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson((String)serverResponse, type2);
                        if (responseDto3 == null) {
                            object = null;
                        } else {
                            Attribution attribution;
                            ResponseDto response = responseDto3;
                            boolean bl2 = false;
                            AttributionDto attributionDto = (AttributionDto)response.getData().getResults();
                            if (attributionDto == null) {
                                attribution = null;
                            } else {
                                AttributionDto it1 = attributionDto;
                                boolean bl3 = false;
                                attribution = RequestManager.access$getAttributionMapper$p().map(it1);
                            }
                            Attribution attribution2 = attribution;
                            function23.invoke((Object)attribution2, null);
                            object = type2 = Unit.INSTANCE;
                        }
                        if (type2 == null) {
                            RequestManager $this$invoke_u24lambda_u2d3_u24lambda_u2d2 = RequestManager.INSTANCE;
                            boolean bl4 = false;
                            function23.invoke(null, (Object)new ApphudError("Failed to send properties", null, null, 6, null));
                        }
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit != null) break block7;
                    RequestManager requestManager = RequestManager.INSTANCE;
                    function2 = this.$completionHandler;
                    RequestManager $this$invoke_u24lambda_u2d4 = requestManager;
                    boolean bl = false;
                    function2.invoke(null, (Object)error);
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void grantPromotional(int daysCount, @Nullable String productId, @Nullable ApphudGroup permissionGroup, @NotNull Function2<? super Customer, ? super ApphudError, Unit> completionHandler) {
        Intrinsics.checkNotNullParameter(completionHandler, (String)"completionHandler");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"grantPromotional", (Object)MUST_REGISTER_ERROR), false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("promotions").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), this.grantPromotionalBody$sdk_release(daysCount, productId, permissionGroup));
        OkHttpClient httpClient = RequestManager.getOkHttpClient$default(this, false, 1, null);
        try {
            Object object;
            ResponseDto responseDto2;
            String serverResponse = this.performRequestSync(httpClient, request);
            Type type2 = new TypeToken<ResponseDto<CustomerDto>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"object : TypeToken<Respo\u2026o<CustomerDto>>() {}.type");
            ResponseDto responseDto3 = responseDto2 = (ResponseDto)parser.fromJson(serverResponse, type2);
            if (responseDto3 == null) {
                object = null;
            } else {
                Customer customer2;
                ResponseDto cDto = responseDto3;
                boolean bl = false;
                RequestManager requestManager = INSTANCE;
                CustomerDto customerDto = (CustomerDto)cDto.getData().getResults();
                if (customerDto == null) {
                    customer2 = null;
                } else {
                    void customerObj;
                    CustomerDto customerDto2 = customerDto;
                    RequestManager requestManager2 = requestManager;
                    boolean bl2 = false;
                    customer2 = customerMapper.map((CustomerDto)customerObj);
                    requestManager = requestManager2;
                }
                requestManager.setCurrentUser(customer2);
                completionHandler.invoke((Object)INSTANCE.getCurrentUser(), null);
                object = type2 = Unit.INSTANCE;
            }
            if (type2 == null) {
                RequestManager $this$grantPromotional_u24lambda_u2d24 = this;
                boolean bl = false;
                completionHandler.invoke(null, (Object)new ApphudError("Promotional request failed", null, null, 6, null));
            }
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "Undefined error";
            }
            String message = string;
            completionHandler.invoke(null, (Object)new ApphudError(message, null, null, 6, null));
        }
    }

    public final void paywallShown(@NotNull ApphudPaywall paywall) {
        Intrinsics.checkNotNullParameter((Object)paywall, (String)"paywall");
        this.trackPaywallEvent(RequestManager.makePaywallEventBody$default(this, "paywall_shown", paywall.getId(), null, 4, null));
    }

    public final void paywallClosed(@NotNull ApphudPaywall paywall) {
        Intrinsics.checkNotNullParameter((Object)paywall, (String)"paywall");
        this.trackPaywallEvent(RequestManager.makePaywallEventBody$default(this, "paywall_closed", paywall.getId(), null, 4, null));
    }

    public final void paywallCheckoutInitiated(@Nullable String paywall_id, @Nullable String product_id) {
        this.trackPaywallEvent(this.makePaywallEventBody("paywall_checkout_initiated", paywall_id, product_id));
    }

    public final void paywallPaymentCancelled(@Nullable String paywall_id, @Nullable String product_id) {
        this.trackPaywallEvent(this.makePaywallEventBody("paywall_payment_cancelled", paywall_id, product_id));
    }

    private final void trackPaywallEvent(PaywallEventBody body) {
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"trackPaywallEvent", (Object)MUST_REGISTER_ERROR), false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("events").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), body);
        this.makeUserRegisteredRequest(request, (Function2<? super String, ? super ApphudError, Unit>)((Function2)trackPaywallEvent.2.INSTANCE));
    }

    public final void sendErrorLogs(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"sendErrorLogs", (Object)MUST_REGISTER_ERROR), false, 2, null);
            return;
        }
        ErrorLogsBody body = this.makeErrorLogsBody$sdk_release(message, ApphudUtils.INSTANCE.getPackageName());
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v1").path("logs").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), body);
        this.makeRequest(request, false, (Function2<? super String, ? super ApphudError, Unit>)((Function2)sendErrorLogs.2.INSTANCE));
    }

    public final void sendBenchmarkLogs(@NotNull BenchmarkBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        if (!this.canPerformRequest()) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, Intrinsics.stringPlus((String)"sendErrorLogs", (Object)MUST_REGISTER_ERROR), false, 2, null);
            return;
        }
        ApphudUrl apphudUrl = new ApphudUrl.Builder().host(HeadersInterceptor.Shared.getHOST()).version("v2").path("logs").build();
        Request request = this.buildPostRequest(new URL(apphudUrl.getUrl()), body);
        this.makeRequest(request, false, (Function2<? super String, ? super ApphudError, Unit>)((Function2)sendBenchmarkLogs.2.INSTANCE));
    }

    private final boolean isNetworkAvailable() {
        Object object = this.getApplicationContext().getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        if (Build.VERSION.SDK_INT >= 29) {
            NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
            if (capabilities != null) {
                if (capabilities.hasTransport(0)) {
                    return true;
                }
                if (capabilities.hasTransport(1)) {
                    return true;
                }
                if (capabilities.hasTransport(3)) {
                    return true;
                }
            }
        } else {
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            if (activeNetworkInfo != null && activeNetworkInfo.isConnected()) {
                return true;
            }
        }
        return false;
    }

    private final PaywallEventBody makePaywallEventBody(String name, String paywall_id, String product_id) {
        String it;
        Map properties2 = new LinkedHashMap();
        String string = paywall_id;
        if (string != null) {
            it = string;
            boolean bl = false;
            properties2.put("paywall_id", it);
        }
        String string2 = product_id;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            properties2.put("product_id", it);
        }
        return new PaywallEventBody(name, this.getUserId(), this.getDeviceId(), ApphudExtensionsKt.isDebuggable(this.getApplicationContext()) ? "sandbox" : "production", System.currentTimeMillis(), !properties2.isEmpty() ? properties2 : null);
    }

    static /* synthetic */ PaywallEventBody makePaywallEventBody$default(RequestManager requestManager, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return requestManager.makePaywallEventBody(string, string2, string3);
    }

    private final RegistrationBody mkRegistrationBody(boolean needPaywalls, boolean isNew) {
        String string = ConfigurationCompat.getLocales((Configuration)Resources.getSystem().getConfiguration()).get(0).toString();
        String string2 = ContextKt.buildAppVersion(this.getApplicationContext());
        String string3 = Build.MANUFACTURER;
        String string4 = Build.MODEL;
        String string5 = Build.VERSION.RELEASE;
        String string6 = ContextKt.buildAppVersion(this.getApplicationContext());
        String string7 = ApphudUtils.INSTANCE.getAdTracking() ? this.getAdvertisingId() : null;
        String string8 = this.getUserId();
        String string9 = this.getDeviceId();
        String string10 = TimeZone.getDefault().getID();
        boolean bl = ApphudExtensionsKt.isDebuggable(this.getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MANUFACTURER");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MODEL");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"RELEASE");
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"id");
        return new RegistrationBody(string, "1.5.6", string2, string3, string4, "Android", string5, string6, null, string7, string8, string9, string10, bl, isNew, needPaywalls);
    }

    private final PurchaseBody makePurchaseBody(Purchase purchase2, SkuDetails details2, String paywall_id, String apphud_product_id) {
        String string;
        String string2 = this.getDeviceId();
        String string3 = purchase2.getOrderId();
        SkuDetails skuDetails2 = details2;
        if (skuDetails2 == null) {
            string = null;
        } else {
            SkuDetails skuDetails3 = skuDetails2;
            String string4 = string3;
            String string5 = string2;
            boolean bl = false;
            String string6 = details2.getSku();
            string2 = string5;
            string3 = string4;
            string = string6;
        }
        String string7 = string;
        if (string == null) {
            ArrayList arrayList = purchase2.getSkus();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"purchase.skus");
            string7 = (String)CollectionsKt.first((List)arrayList);
        }
        String string8 = string7;
        Intrinsics.checkNotNullExpressionValue(string8, (String)"details?.let { details.s\u2026 ?: purchase.skus.first()");
        String string9 = string8;
        string8 = purchase2.getPurchaseToken();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"purchase.purchaseToken");
        SkuDetails skuDetails4 = details2;
        SkuDetails skuDetails5 = details2;
        SkuDetails skuDetails6 = details2;
        boolean bl = false;
        String string10 = apphud_product_id;
        String string11 = paywall_id;
        String string12 = skuDetails6 == null ? null : skuDetails6.getSubscriptionPeriod();
        Long l = skuDetails5 == null ? null : Long.valueOf(skuDetails5.getPriceAmountMicros());
        String string13 = skuDetails4 == null ? null : skuDetails4.getPriceCurrencyCode();
        String string14 = string8;
        String string15 = string9;
        String string16 = string3;
        List list = CollectionsKt.listOf((Object)new PurchaseItemObserverBody(string16, string15, string14, string13, l, string12, string11, string10, bl));
        String string17 = string2;
        return new PurchaseBody(string17, list);
    }

    /*
     * WARNING - void declaration
     */
    private final PurchaseBody makeRestorePurchasesBody(List<PurchaseRecordDetails> purchases, boolean skipObserverModeParam) {
        PurchaseBody purchaseBody;
        if (skipObserverModeParam) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = purchases;
            String string = this.getDeviceId();
            boolean $i$f$map = false;
            void var5_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void purchase2;
                PurchaseRecordDetails purchaseRecordDetails = (PurchaseRecordDetails)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = purchase2.getDetails().getSku();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"purchase.details.sku");
                String string3 = string2;
                string2 = purchase2.getRecord().getPurchaseToken();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"purchase.record.purchaseToken");
                collection.add(new PurchaseItemBody(null, string3, string2, purchase2.getDetails().getPriceCurrencyCode(), purchase2.getDetails().getPriceAmountMicros(), purchase2.getDetails().getSubscriptionPeriod(), null, null));
            }
            List list = (List)destination$iv$iv;
            String string4 = string;
            purchaseBody = new PurchaseBody(string4, list);
        } else {
            Iterable $this$map$iv = purchases;
            String string = this.getDeviceId();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PurchaseRecordDetails purchase2 = (PurchaseRecordDetails)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string5 = purchase2.getDetails().getSku();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"purchase.details.sku");
                String string6 = string5;
                string5 = purchase2.getRecord().getPurchaseToken();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"purchase.record.purchaseToken");
                collection.add(new PurchaseItemObserverBody(null, string6, string5, purchase2.getDetails().getPriceCurrencyCode(), purchase2.getDetails().getPriceAmountMicros(), purchase2.getDetails().getSubscriptionPeriod(), null, null, true));
            }
            List list = (List)destination$iv$iv;
            String string7 = string;
            purchaseBody = new PurchaseBody(string7, list);
        }
        return purchaseBody;
    }

    @NotNull
    public final ErrorLogsBody makeErrorLogsBody$sdk_release(@NotNull String message, @Nullable String apphud_product_id) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new ErrorLogsBody(message, apphud_product_id, this.getUserId(), this.getDeviceId(), ApphudExtensionsKt.isDebuggable(this.getApplicationContext()) ? "sandbox" : "production", System.currentTimeMillis());
    }

    public static /* synthetic */ ErrorLogsBody makeErrorLogsBody$sdk_release$default(RequestManager requestManager, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return requestManager.makeErrorLogsBody$sdk_release(string, string2);
    }

    @NotNull
    public final GrantPromotionalBody grantPromotionalBody$sdk_release(int daysCount, @Nullable String productId, @Nullable ApphudGroup permissionGroup) {
        ApphudGroup apphudGroup = permissionGroup;
        return new GrantPromotionalBody(daysCount, this.getUserId(), this.getDeviceId(), productId, (String)(apphudGroup == null ? null : apphudGroup.getId()));
    }

    public static /* synthetic */ GrantPromotionalBody grantPromotionalBody$sdk_release$default(RequestManager requestManager, int n, String string, ApphudGroup apphudGroup, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            apphudGroup = null;
        }
        return requestManager.grantPromotionalBody$sdk_release(n, string, apphudGroup);
    }

    private final String buildPrettyPrintedBy(String jsonString) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            if (jsonObject != null) {
                return jsonObject.toString(4);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return null;
    }

    private static final void getOkHttpClient$lambda-3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (parser.isJson(it)) {
            Unit unit;
            Unit unit2;
            String string = INSTANCE.buildPrettyPrintedBy(it);
            if (string == null) {
                unit2 = null;
            } else {
                String formattedJsonString = string;
                boolean bl = false;
                ApphudLog.logI$default(ApphudLog.INSTANCE, formattedJsonString, false, 2, null);
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit == null) {
                RequestManager $this$getOkHttpClient_u24lambda_u2d3_u24lambda_u2d2 = INSTANCE;
                boolean bl = false;
                ApphudLog.logI$default(ApphudLog.INSTANCE, it, false, 2, null);
            }
        } else {
            ApphudLog.logI$default(ApphudLog.INSTANCE, it, false, 2, null);
        }
    }

    public static final /* synthetic */ void access$performRequest(RequestManager $this, OkHttpClient client, Request request, Function2 completionHandler) {
        $this.performRequest(client, request, (Function2<? super String, ? super ApphudError, Unit>)completionHandler);
    }

    public static final /* synthetic */ CustomerMapper access$getCustomerMapper$p() {
        return customerMapper;
    }

    public static final /* synthetic */ AttributionMapper access$getAttributionMapper$p() {
        return attributionMapper;
    }

    public static final /* synthetic */ ProductMapper access$getProductMapper$p() {
        return productMapper;
    }

    static {
        gson = new GsonBuilder().serializeNulls().create();
        Gson gson = RequestManager.gson;
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"gson");
        parser = new GsonParser(gson);
        productMapper = new ProductMapper();
        paywallsMapper = new PaywallsMapper(parser);
        attributionMapper = new AttributionMapper();
        customerMapper = new CustomerMapper(new SubscriptionMapper(), paywallsMapper);
    }
}

