/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.managers;

import com.apphud.sdk.ApphudLog;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/apphud/sdk/managers/HttpRetryInterceptor;", "Lokhttp3/Interceptor;", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "sdk_release"})
public final class HttpRetryInterceptor
implements Interceptor {
    private static final long STEP = 3000L;
    private static final int MAX_COUNT = 30;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response2 = null;
        boolean isSuccess = false;
        int tryCount = 0;
        while (!isSuccess && tryCount < 30) {
            try {
                Thread.sleep(3000L);
                response2 = chain.proceed(request);
                isSuccess = response2.isSuccessful();
                if (isSuccess) continue;
                ApphudLog.logE$default(ApphudLog.INSTANCE, "Request (" + request.url().encodedPath() + ") failed with code (" + response2.code() + "). Will retry in 3 seconds (" + tryCount + ").", false, 2, null);
            }
            catch (Exception e) {
                Response response3 = response2;
                ApphudLog.logE$default(ApphudLog.INSTANCE, "Request (" + request.url().encodedPath() + ") failed with code (" + (response3 != null ? response3.code() : 0) + "). Will retry in 3 seconds (" + tryCount + ").", false, 2, null);
            }
            finally {
                if (!isSuccess) {
                    Response response4 = response2;
                    if (response4 != null) {
                        response4.close();
                    }
                }
                int n = tryCount;
                tryCount = (byte)(n + 1);
            }
        }
        if (!isSuccess && tryCount >= 30) {
            ApphudLog.logE$default(ApphudLog.INSTANCE, "Reached max number (30) of (" + request.url().encodedPath() + ") request retries. Exiting..", false, 2, null);
        }
        if ((response = response2) == null) {
            response = chain.proceed(request);
        }
        return response;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/apphud/sdk/managers/HttpRetryInterceptor$Companion;", "", "()V", "MAX_COUNT", "", "STEP", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

