/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.client;

import com.apphud.sdk.ApphudError;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.body.AttributionBody;
import com.apphud.sdk.body.DeviceIdBody;
import com.apphud.sdk.body.ErrorLogsBody;
import com.apphud.sdk.body.PaywallEventBody;
import com.apphud.sdk.body.PurchaseBody;
import com.apphud.sdk.body.PushBody;
import com.apphud.sdk.body.RegistrationBody;
import com.apphud.sdk.body.UserPropertiesBody;
import com.apphud.sdk.client.ApphudClient;
import com.apphud.sdk.client.ApphudServiceV1;
import com.apphud.sdk.client.ApphudServiceV2;
import com.apphud.sdk.client.HttpUrlConnectionExecutor;
import com.apphud.sdk.client.NetworkExecutor;
import com.apphud.sdk.client.ThreadsUtils;
import com.apphud.sdk.client.dto.ApphudGroupDto;
import com.apphud.sdk.client.dto.ApphudPaywallDto;
import com.apphud.sdk.client.dto.AttributionDto;
import com.apphud.sdk.client.dto.CustomerDto;
import com.apphud.sdk.client.dto.ResponseDto;
import com.apphud.sdk.domain.ApphudGroup;
import com.apphud.sdk.domain.ApphudPaywall;
import com.apphud.sdk.domain.Attribution;
import com.apphud.sdk.domain.Customer;
import com.apphud.sdk.mappers.AttributionMapper;
import com.apphud.sdk.mappers.CustomerMapper;
import com.apphud.sdk.mappers.PaywallsMapper;
import com.apphud.sdk.mappers.ProductMapper;
import com.apphud.sdk.mappers.SubscriptionMapper;
import com.apphud.sdk.parser.Parser;
import com.apphud.sdk.tasks.AttributionCallable;
import com.apphud.sdk.tasks.ErrorLogsCallable;
import com.apphud.sdk.tasks.LoopRunnable;
import com.apphud.sdk.tasks.PaywallEventCallable;
import com.apphud.sdk.tasks.PaywallsCallable;
import com.apphud.sdk.tasks.ProductsCallable;
import com.apphud.sdk.tasks.PurchaseCallable;
import com.apphud.sdk.tasks.PushCallable;
import com.apphud.sdk.tasks.RegistrationCallable;
import com.apphud.sdk.tasks.UserPropertiesCallable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\u0019\u001a\u00020\u001a2\u001c\u0010\u001b\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\u0004\u0012\u00020\u001a0\u001cj\u0002`\u001fJ6\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2&\u0010\u001b\u001a\"\u0012\f\u0012\n\u0012\u0004\u0012\u00020$\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020\u001a0#j\u0002`&J0\u0010'\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020(2 \u0010\u001b\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020\u001a0#j\u0002`*J&\u0010+\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020,2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u001a0\u001cj\u0002`-J&\u0010.\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020/2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001a0\u001cj\u0002`1J&\u0010.\u001a\u00020\u001a2\u0006\u0010!\u001a\u0002022\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001a0\u001cj\u0002`1J\u000e\u00103\u001a\u00020\u001a2\u0006\u0010!\u001a\u000204J\u000e\u00105\u001a\u00020\u001a2\u0006\u0010!\u001a\u000206J&\u00107\u001a\u00020\u001a2\u0006\u0010!\u001a\u0002082\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u001a0\u001cj\u0002`1R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/apphud/sdk/client/ApphudClient;", "", "apiKey", "", "Lcom/apphud/sdk/ApiKey;", "parser", "Lcom/apphud/sdk/parser/Parser;", "(Ljava/lang/String;Lcom/apphud/sdk/parser/Parser;)V", "attributionMapper", "Lcom/apphud/sdk/mappers/AttributionMapper;", "customerMapper", "Lcom/apphud/sdk/mappers/CustomerMapper;", "executorV1", "Lcom/apphud/sdk/client/NetworkExecutor;", "executorV2", "paywallsMapper", "Lcom/apphud/sdk/mappers/PaywallsMapper;", "productMapper", "Lcom/apphud/sdk/mappers/ProductMapper;", "serviceV1", "Lcom/apphud/sdk/client/ApphudServiceV1;", "serviceV2", "Lcom/apphud/sdk/client/ApphudServiceV2;", "thread", "Lcom/apphud/sdk/client/ThreadsUtils;", "allProducts", "", "callback", "Lkotlin/Function1;", "", "Lcom/apphud/sdk/domain/ApphudGroup;", "Lcom/apphud/sdk/ProductsCallback;", "paywalls", "body", "Lcom/apphud/sdk/body/DeviceIdBody;", "Lkotlin/Function2;", "Lcom/apphud/sdk/domain/ApphudPaywall;", "Lcom/apphud/sdk/ApphudError;", "Lcom/apphud/sdk/PaywallCallback;", "purchased", "Lcom/apphud/sdk/body/PurchaseBody;", "Lcom/apphud/sdk/domain/Customer;", "Lcom/apphud/sdk/PurchasedCallback;", "registrationUser", "Lcom/apphud/sdk/body/RegistrationBody;", "Lcom/apphud/sdk/CustomerCallback;", "send", "Lcom/apphud/sdk/body/AttributionBody;", "Lcom/apphud/sdk/domain/Attribution;", "Lcom/apphud/sdk/AttributionCallback;", "Lcom/apphud/sdk/body/PushBody;", "sendErrorLogs", "Lcom/apphud/sdk/body/ErrorLogsBody;", "trackPaywallEvent", "Lcom/apphud/sdk/body/PaywallEventBody;", "userProperties", "Lcom/apphud/sdk/body/UserPropertiesBody;", "sdk_release"})
public final class ApphudClient {
    private final ProductMapper productMapper;
    private final PaywallsMapper paywallsMapper;
    private final AttributionMapper attributionMapper;
    private final CustomerMapper customerMapper;
    private final ThreadsUtils thread;
    private final NetworkExecutor executorV1;
    private final ApphudServiceV1 serviceV1;
    private final NetworkExecutor executorV2;
    private final ApphudServiceV2 serviceV2;
    private final Parser parser;

    public final void registrationUser(@NotNull RegistrationBody body, @NotNull Function1<? super Customer, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        RegistrationCallable callable = new RegistrationCallable(body, this.serviceV1);
        this.thread.registration(callable, (Function1)new Function1<ResponseDto<CustomerDto>, Unit>(this, callback){
            final /* synthetic */ ApphudClient this$0;
            final /* synthetic */ Function1 $callback;

            public final void invoke(@NotNull ResponseDto<CustomerDto> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                CustomerDto customerDto = response.getData().getResults();
                if (customerDto == null) {
                    ApphudLog.log$default(ApphudLog.INSTANCE, "Response success but result is null", false, 2, null);
                } else {
                    this.$callback.invoke((Object)ApphudClient.access$getCustomerMapper$p(this.this$0).map(response.getData().getResults()));
                }
            }
            {
                this.this$0 = apphudClient;
                this.$callback = function1;
                super(1);
            }
        });
    }

    public final void allProducts(@NotNull Function1<? super List<ApphudGroup>, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        ProductsCallable callable = new ProductsCallable(this.serviceV2);
        this.thread.allProducts(new LoopRunnable(callable, null, (Function1)new Function1<ResponseDto<List<? extends ApphudGroupDto>>, Unit>(this, callback){
            final /* synthetic */ ApphudClient this$0;
            final /* synthetic */ Function1 $callback;

            public final void invoke(@NotNull ResponseDto<List<ApphudGroupDto>> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                List<ApphudGroupDto> list = response.getData().getResults();
                if (list == null) {
                    ApphudLog.log$default(ApphudLog.INSTANCE, "Response success but result is null", false, 2, null);
                } else {
                    this.$callback.invoke(ApphudClient.access$getProductMapper$p(this.this$0).map(response.getData().getResults()));
                }
            }
            {
                this.this$0 = apphudClient;
                this.$callback = function1;
                super(1);
            }
        }, 2, null));
    }

    public final void send(@NotNull AttributionBody body, @NotNull Function1<? super Attribution, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        AttributionCallable callable = new AttributionCallable(body, this.serviceV1);
        this.thread.execute(new LoopRunnable(callable, null, (Function1)new Function1<ResponseDto<AttributionDto>, Unit>(this, callback){
            final /* synthetic */ ApphudClient this$0;
            final /* synthetic */ Function1 $callback;

            public final void invoke(@NotNull ResponseDto<AttributionDto> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                AttributionDto attributionDto = response.getData().getResults();
                if (attributionDto == null) {
                    ApphudLog.log$default(ApphudLog.INSTANCE, "Response success but result is null", false, 2, null);
                } else {
                    this.$callback.invoke((Object)ApphudClient.access$getAttributionMapper$p(this.this$0).map(response.getData().getResults()));
                }
            }
            {
                this.this$0 = apphudClient;
                this.$callback = function1;
                super(1);
            }
        }, 2, null));
    }

    public final void send(@NotNull PushBody body, @NotNull Function1<? super Attribution, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        PushCallable callable = new PushCallable(body, this.serviceV1);
        this.thread.execute(new LoopRunnable(callable, null, (Function1)new Function1<ResponseDto<AttributionDto>, Unit>(this, callback){
            final /* synthetic */ ApphudClient this$0;
            final /* synthetic */ Function1 $callback;

            public final void invoke(@NotNull ResponseDto<AttributionDto> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                AttributionDto attributionDto = response.getData().getResults();
                if (attributionDto == null) {
                    ApphudLog.log$default(ApphudLog.INSTANCE, "Response success but result is null", false, 2, null);
                } else {
                    this.$callback.invoke((Object)ApphudClient.access$getAttributionMapper$p(this.this$0).map(response.getData().getResults()));
                }
            }
            {
                this.this$0 = apphudClient;
                this.$callback = function1;
                super(1);
            }
        }, 2, null));
    }

    public final void purchased(@NotNull PurchaseBody body, @NotNull Function2<? super Customer, ? super ApphudError, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        PurchaseCallable callable = new PurchaseCallable(body, this.serviceV1);
        this.thread.execute(new LoopRunnable(callable, null, (Function1)new Function1<ResponseDto<CustomerDto>, Unit>(this, callback){
            final /* synthetic */ ApphudClient this$0;
            final /* synthetic */ Function2 $callback;

            /*
             * Enabled aggressive block sorting
             */
            public final void invoke(@NotNull ResponseDto<CustomerDto> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                CustomerDto customerDto = response.getData().getResults();
                if (customerDto != null) {
                    this.$callback.invoke((Object)ApphudClient.access$getCustomerMapper$p(this.this$0).map(response.getData().getResults()), null);
                    return;
                }
                ApphudLog.log$default(ApphudLog.INSTANCE, "Response success but result is null: + " + String.valueOf(response.getErrors()), false, 2, null);
                List<Object> list = response.getErrors();
                Integer code = list != null && (list = list.toString()) != null && StringsKt.contains$default((CharSequence)((CharSequence)((Object)list)), (CharSequence)"PUB key nor PRIV", (boolean)false, (int)2, null) ? Integer.valueOf(422) : null;
                this.$callback.invoke(null, (Object)new ApphudError(String.valueOf(response.getErrors()), null, code, 2, null));
            }
            {
                this.this$0 = apphudClient;
                this.$callback = function2;
                super(1);
            }
        }, 2, null));
    }

    public final void userProperties(@NotNull UserPropertiesBody body, @NotNull Function1<? super Attribution, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        UserPropertiesCallable callable = new UserPropertiesCallable(body, this.serviceV1);
        this.thread.execute(new LoopRunnable(callable, null, (Function1)new Function1<ResponseDto<AttributionDto>, Unit>(this, callback){
            final /* synthetic */ ApphudClient this$0;
            final /* synthetic */ Function1 $callback;

            public final void invoke(@NotNull ResponseDto<AttributionDto> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                AttributionDto attributionDto = response.getData().getResults();
                if (attributionDto == null) {
                    ApphudLog.log$default(ApphudLog.INSTANCE, "Response success but result is null", false, 2, null);
                } else {
                    this.$callback.invoke((Object)ApphudClient.access$getAttributionMapper$p(this.this$0).map(response.getData().getResults()));
                }
            }
            {
                this.this$0 = apphudClient;
                this.$callback = function1;
                super(1);
            }
        }, 2, null));
    }

    public final void paywalls(@NotNull DeviceIdBody body, @NotNull Function2<? super List<ApphudPaywall>, ? super ApphudError, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        PaywallsCallable callable = new PaywallsCallable(body, this.serviceV2);
        this.thread.execute(new LoopRunnable(callable, null, (Function1)new Function1<ResponseDto<List<? extends ApphudPaywallDto>>, Unit>(this, callback){
            final /* synthetic */ ApphudClient this$0;
            final /* synthetic */ Function2 $callback;

            public final void invoke(@NotNull ResponseDto<List<ApphudPaywallDto>> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                List<ApphudPaywallDto> list = response.getData().getResults();
                if (list == null) {
                    ApphudLog.log$default(ApphudLog.INSTANCE, "Response success but result is null: + " + String.valueOf(response.getErrors()), false, 2, null);
                    this.$callback.invoke(null, (Object)new ApphudError(String.valueOf(response.getErrors()), null, null, 6, null));
                } else {
                    this.$callback.invoke(ApphudClient.access$getPaywallsMapper$p(this.this$0).map(response.getData().getResults()), null);
                }
            }
            {
                this.this$0 = apphudClient;
                this.$callback = function2;
                super(1);
            }
        }, 2, null));
    }

    public final void sendErrorLogs(@NotNull ErrorLogsBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        ErrorLogsCallable callable = new ErrorLogsCallable(body, this.serviceV1);
        this.thread.execute(new LoopRunnable(callable, null, sendErrorLogs.1.INSTANCE, 2, null));
    }

    public final void trackPaywallEvent(@NotNull PaywallEventBody body) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        PaywallEventCallable callable = new PaywallEventCallable(body, this.serviceV1);
        this.thread.execute(new LoopRunnable(callable, null, trackPaywallEvent.1.INSTANCE, 2, null));
    }

    public ApphudClient(@NotNull String apiKey, @NotNull Parser parser) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        this.parser = parser;
        this.productMapper = new ProductMapper();
        this.paywallsMapper = new PaywallsMapper(this.parser);
        this.attributionMapper = new AttributionMapper();
        this.customerMapper = new CustomerMapper(new SubscriptionMapper(), this.paywallsMapper);
        this.thread = new ThreadsUtils();
        this.executorV1 = new HttpUrlConnectionExecutor("https://api.apphud.com", "v1", this.parser);
        this.serviceV1 = new ApphudServiceV1(apiKey, this.executorV1);
        this.executorV2 = new HttpUrlConnectionExecutor("https://api.apphud.com", "v2", this.parser);
        this.serviceV2 = new ApphudServiceV2(apiKey, this.executorV2);
    }

    public static final /* synthetic */ CustomerMapper access$getCustomerMapper$p(ApphudClient $this) {
        return $this.customerMapper;
    }

    public static final /* synthetic */ ProductMapper access$getProductMapper$p(ApphudClient $this) {
        return $this.productMapper;
    }

    public static final /* synthetic */ AttributionMapper access$getAttributionMapper$p(ApphudClient $this) {
        return $this.attributionMapper;
    }

    public static final /* synthetic */ PaywallsMapper access$getPaywallsMapper$p(ApphudClient $this) {
        return $this.paywallsMapper;
    }
}

