/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.org.apache.http.client.protocol;

import com.appdynamics.serverless.tracers.dependencies.org.apache.http.Header;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HeaderElement;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpEntity;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpException;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpResponse;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpResponseInterceptor;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.annotation.Immutable;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.client.config.RequestConfig;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.client.entity.DecompressingEntity;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.client.entity.DeflateInputStream;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.client.entity.InputStreamFactory;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.client.protocol.HttpClientContext;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.config.Lookup;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.config.RegistryBuilder;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.zip.GZIPInputStream;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private static final InputStreamFactory GZIP = new InputStreamFactory(){

        @Override
        public InputStream create(InputStream instream) throws IOException {
            return new GZIPInputStream(instream);
        }
    };
    private static final InputStreamFactory DEFLATE = new InputStreamFactory(){

        @Override
        public InputStream create(InputStream instream) throws IOException {
            return new DeflateInputStream(instream);
        }
    };
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry, boolean ignoreUnknown) {
        this.decoderRegistry = decoderRegistry != null ? decoderRegistry : RegistryBuilder.create().register("gzip", GZIP).register("x-gzip", GZIP).register("deflate", DEFLATE).build();
        this.ignoreUnknown = ignoreUnknown;
    }

    public ResponseContentEncoding(boolean ignoreUnknown) {
        this(null, ignoreUnknown);
    }

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry) {
        this(decoderRegistry, true);
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (requestConfig.isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            for (HeaderElement codec : codecs = ceheader.getElements()) {
                String codecname = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity(new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(codecname) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + codec.getName());
            }
        }
    }
}

