/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.org.apache.http.client.protocol;

import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpEntity;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpEntityEnclosingRequest;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpException;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpRequest;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpRequestInterceptor;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.HttpVersion;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.ProtocolVersion;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.annotation.Immutable;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.client.config.RequestConfig;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.client.protocol.HttpClientContext;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.protocol.HttpContext;
import com.appdynamics.serverless.tracers.dependencies.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

