/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.feign.okhttp;

import com.appdynamics.serverless.tracers.dependencies.feign.Client;
import com.appdynamics.serverless.tracers.dependencies.feign.Request;
import com.appdynamics.serverless.tracers.dependencies.feign.Response;
import com.appdynamics.serverless.tracers.dependencies.okhttp3.Headers;
import com.appdynamics.serverless.tracers.dependencies.okhttp3.MediaType;
import com.appdynamics.serverless.tracers.dependencies.okhttp3.Request;
import com.appdynamics.serverless.tracers.dependencies.okhttp3.RequestBody;
import com.appdynamics.serverless.tracers.dependencies.okhttp3.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class OkHttpClient
implements Client {
    private final com.appdynamics.serverless.tracers.dependencies.okhttp3.OkHttpClient delegate;

    public OkHttpClient() {
        this(new com.appdynamics.serverless.tracers.dependencies.okhttp3.OkHttpClient());
    }

    public OkHttpClient(com.appdynamics.serverless.tracers.dependencies.okhttp3.OkHttpClient delegate) {
        this.delegate = delegate;
    }

    static com.appdynamics.serverless.tracers.dependencies.okhttp3.Request toOkHttpRequest(Request input) {
        boolean isMethodWithBody;
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(input.url());
        MediaType mediaType = null;
        boolean hasAcceptHeader = false;
        for (String field : input.headers().keySet()) {
            if (field.equalsIgnoreCase("Accept")) {
                hasAcceptHeader = true;
            }
            for (String value : input.headers().get(field)) {
                if (field.equalsIgnoreCase("Content-Type")) {
                    mediaType = MediaType.parse(value);
                    if (input.charset() == null) continue;
                    mediaType.charset(input.charset());
                    continue;
                }
                requestBuilder.addHeader(field, value);
            }
        }
        if (!hasAcceptHeader) {
            requestBuilder.addHeader("Accept", "*/*");
        }
        byte[] inputBody = input.body();
        boolean bl = isMethodWithBody = "POST".equals(input.method()) || "PUT".equals(input.method());
        if (isMethodWithBody && inputBody == null) {
            inputBody = new byte[]{};
        }
        RequestBody body = inputBody != null ? RequestBody.create(mediaType, inputBody) : null;
        requestBuilder.method(input.method(), body);
        return requestBuilder.build();
    }

    private static Response toFeignResponse(com.appdynamics.serverless.tracers.dependencies.okhttp3.Response input) throws IOException {
        return Response.create(input.code(), input.message(), OkHttpClient.toMap(input.headers()), OkHttpClient.toBody(input.body()));
    }

    private static Map<String, Collection<String>> toMap(Headers headers) {
        return headers.toMultimap();
    }

    private static Response.Body toBody(final ResponseBody input) throws IOException {
        if (input == null || input.contentLength() == 0L) {
            return null;
        }
        final Integer length = input.contentLength() >= 0L && input.contentLength() <= Integer.MAX_VALUE ? Integer.valueOf((int)input.contentLength()) : null;
        return new Response.Body(){

            @Override
            public void close() throws IOException {
                input.close();
            }

            @Override
            public Integer length() {
                return length;
            }

            @Override
            public boolean isRepeatable() {
                return false;
            }

            @Override
            public InputStream asInputStream() throws IOException {
                return input.byteStream();
            }

            @Override
            public Reader asReader() throws IOException {
                return input.charStream();
            }
        };
    }

    @Override
    public Response execute(Request input, Request.Options options) throws IOException {
        com.appdynamics.serverless.tracers.dependencies.okhttp3.OkHttpClient requestScoped = this.delegate.connectTimeoutMillis() != options.connectTimeoutMillis() || this.delegate.readTimeoutMillis() != options.readTimeoutMillis() ? this.delegate.newBuilder().connectTimeout(options.connectTimeoutMillis(), TimeUnit.MILLISECONDS).readTimeout(options.readTimeoutMillis(), TimeUnit.MILLISECONDS).build() : this.delegate;
        com.appdynamics.serverless.tracers.dependencies.okhttp3.Request request = OkHttpClient.toOkHttpRequest(input);
        com.appdynamics.serverless.tracers.dependencies.okhttp3.Response response = requestScoped.newCall(request).execute();
        return OkHttpClient.toFeignResponse(response);
    }
}

