/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.feign.gson;

import com.appdynamics.serverless.tracers.dependencies.com.google.gson.Gson;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.JsonIOException;
import com.appdynamics.serverless.tracers.dependencies.com.google.gson.TypeAdapter;
import com.appdynamics.serverless.tracers.dependencies.feign.Response;
import com.appdynamics.serverless.tracers.dependencies.feign.Util;
import com.appdynamics.serverless.tracers.dependencies.feign.codec.Decoder;
import com.appdynamics.serverless.tracers.dependencies.feign.gson.GsonFactory;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;

public class GsonDecoder
implements Decoder {
    private final Gson gson;

    public GsonDecoder(Iterable<TypeAdapter<?>> adapters) {
        this(GsonFactory.create(adapters));
    }

    public GsonDecoder() {
        this(Collections.emptyList());
    }

    public GsonDecoder(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Object decode(Response response, Type type) throws IOException {
        if (response.status() == 404) {
            return Util.emptyValueOf(type);
        }
        if (response.body() == null) {
            return null;
        }
        Reader reader = response.body().asReader();
        try {
            Object t = this.gson.fromJson(reader, type);
            return t;
        }
        catch (JsonIOException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)IOException.class.cast(e.getCause());
            }
            throw e;
        }
        finally {
            Util.ensureClosed(reader);
        }
    }
}

