/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.feign;

import com.appdynamics.serverless.tracers.dependencies.feign.Util;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;

public final class Request {
    private final String method;
    private final String url;
    private final Map<String, Collection<String>> headers;
    private final byte[] body;
    private final Charset charset;

    public static Request create(String method, String url, Map<String, Collection<String>> headers, byte[] body, Charset charset) {
        return new Request(method, url, headers, body, charset);
    }

    Request(String method, String url, Map<String, Collection<String>> headers, byte[] body, Charset charset) {
        this.method = Util.checkNotNull(method, "method of %s", url);
        this.url = Util.checkNotNull(url, "url", new Object[0]);
        this.headers = Util.checkNotNull(headers, "headers of %s %s", method, url);
        this.body = body;
        this.charset = charset;
    }

    public String method() {
        return this.method;
    }

    public String url() {
        return this.url;
    }

    public Map<String, Collection<String>> headers() {
        return this.headers;
    }

    public Charset charset() {
        return this.charset;
    }

    public byte[] body() {
        return this.body;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.method).append(' ').append(this.url).append(" HTTP/1.1\n");
        for (String field : this.headers.keySet()) {
            for (String value : Util.valuesOrEmpty(this.headers, field)) {
                builder.append(field).append(": ").append(value).append('\n');
            }
        }
        if (this.body != null) {
            builder.append('\n').append(this.charset != null ? new String(this.body, this.charset) : "Binary data");
        }
        return builder.toString();
    }

    public static class Options {
        private final int connectTimeoutMillis;
        private final int readTimeoutMillis;

        public Options(int connectTimeoutMillis, int readTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.readTimeoutMillis = readTimeoutMillis;
        }

        public Options() {
            this(10000, 60000);
        }

        public int connectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public int readTimeoutMillis() {
            return this.readTimeoutMillis;
        }
    }
}

