/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.serverless.tracers.dependencies.feign;

import com.appdynamics.serverless.tracers.dependencies.feign.Request;
import com.appdynamics.serverless.tracers.dependencies.feign.Response;
import com.appdynamics.serverless.tracers.dependencies.feign.RetryableException;
import com.appdynamics.serverless.tracers.dependencies.feign.Util;
import java.io.IOException;

public class FeignException
extends RuntimeException {
    private static final long serialVersionUID = 0L;
    private int status;

    protected FeignException(String message, Throwable cause) {
        super(message, cause);
    }

    protected FeignException(String message) {
        super(message);
    }

    protected FeignException(int status, String message) {
        super(message);
        this.status = status;
    }

    public int status() {
        return this.status;
    }

    static FeignException errorReading(Request request, Response ignored, IOException cause) {
        return new FeignException(String.format("%s reading %s %s", cause.getMessage(), request.method(), request.url()), cause);
    }

    public static FeignException errorStatus(String methodKey, Response response) {
        String message = String.format("status %s reading %s", response.status(), methodKey);
        try {
            if (response.body() != null) {
                String body = Util.toString(response.body().asReader());
                message = message + "; content:\n" + body;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new FeignException(response.status(), message);
    }

    static FeignException errorExecuting(Request request, IOException cause) {
        return new RetryableException(String.format("%s executing %s %s", cause.getMessage(), request.method(), request.url()), cause, null);
    }
}

